## Gazebo Msgs 8.x

### Gazebo Msgs 8.6.0 (2022-08-02)

1. Increase `Utility` test coverage
    * [Pull request #283](https://github.com/gazebosim/gz-msgs/pull/283)

1. Change `IGN_DESIGNATION` to `GZ_DESIGNATION`
    * [Pull request #282](https://github.com/gazebosim/gz-msgs/pull/282)
    * [Pull request #284](https://github.com/gazebosim/gz-msgs/pull/284)

1. Add entity wrench message
    * [Pull request #274](https://github.com/gazebosim/gz-msgs/pull/274)

1. Ignition -> Gazebo
    * [Pull request #273](https://github.com/gazebosim/gz-msgs/pull/273)

1. Add `ACTOR` and `WORLD` types to entity
    * [Pull request #275](https://github.com/gazebosim/gz-msgs/pull/275)

### Ignition Msgs 8.5.0 (2022-06-23)

1. Add entity plugin v proto file
    * [Pull request #261](https://github.com/gazebosim/gz-msgs/pull/261)

1. Bash completion for flags
    * [Pull request #254](https://github.com/gazebosim/gz-msgs/pull/254)

1. Remove dead files
    * [Pull request #255](https://github.com/gazebosim/gz-msgs/pull/255)

1. Fix typo REGRESION/REGRESSION
    * [Pull request #247](https://github.com/gazebosim/gz-msgs/pull/247)

1. Generator: Add missing std namespace to string arguments
    * [Pull request #242](https://github.com/gazebosim/gz-msgs/pull/242)

### Ignition Msgs 8.4.0 (2022-04-06)

1. Add Dataframe msg
    * [Pull request #238](https://github.com/ignitionrobotics/ign-msgs/pull/238)

### Ignition Msgs 8.3.0 (2022-03-24)

1. Focal CI: static checkers and doxygen linters
    * [Pull request #230](https://github.com/ignitionrobotics/ign-msgs/pull/230)

1. Pose, twist and odometry with covariance msgs
    * [Pull request #224](https://github.com/ignitionrobotics/ign-msgs/pull/224)

1. Add wheel slip message definition
    * [Pull request #205](https://github.com/ignitionrobotics/ign-msgs/pull/205)
    * [Pull request #227](https://github.com/ignitionrobotics/ign-msgs/pull/227)

1. Add Ubuntu Jammy CI
    * [Pull request #225](https://github.com/ignitionrobotics/ign-msgs/pull/225)

1. Add PointCloudPacked iterators
    * [Pull request #210](https://github.com/ignitionrobotics/ign-msgs/pull/210)
    * [Pull request #218](https://github.com/ignitionrobotics/ign-msgs/pull/218)

1. Document pose + spherical coordinates combination on spawn
    * [Pull request #212](https://github.com/ignitionrobotics/ign-msgs/pull/212)

1. Utility_TEST: adjust expectations for 32-bit arch (#120)
    * [Pull request #120) (#196](https://github.com/ignitionrobotics/ign-msgs/pull/120) (#196)

### Ignition Msgs 8.2.0 (2021-12-14)

1. Add NavSat messages
    * [Pull request #206](https://github.com/ignitionrobotics/ign-msgs/pull/206)

### Ignition Msgs 8.1.0 (2021-11-02)

1. Added WorldControlState message.
    * [Pull request #190](https://github.com/ignitionrobotics/ign-msgs/pull/190)

1. Fixed trivial typo in command line help message.
    * [Pull request #191](https://github.com/ignitionrobotics/ign-msgs/pull/191)

### Ignition Msgs 8.0.0 (2021-09-27)

1. scene.proto: add shadow_caster_material_name
    * [Pull request #179](https://github.com/ignitionrobotics/ign-msgs/pull/179)

1. 🌐 Spherical coordinates conversion and commands
    * [Pull request #177](https://github.com/ignitionrobotics/ign-msgs/pull/177)

1. Add BoundingBox Msg
    * [Pull request #165](https://github.com/ignitionrobotics/ign-msgs/pull/165)

1. Add particle scatter ratio field to particle emitter
    * [Pull request #162](https://github.com/ignitionrobotics/ign-msgs/pull/162)

1. Add particle emitters to link.proto and add topic to particle_emitter.proto
    * [Pull request #153](https://github.com/ignitionrobotics/ign-msgs/pull/153)

1. Infrastructure
    * [Pull request #159](https://github.com/ignitionrobotics/ign-msgs/pull/159)
    * [Pull request #155](https://github.com/ignitionrobotics/ign-msgs/pull/155)
    * [Pull request #151](https://github.com/ignitionrobotics/ign-msgs/pull/151)

## Ignition Msgs 7.x

### Ignition Msgs 7.3.0 (2022-03-17)

1. Backport NavSat message for bridge compatibility
    * [Pull request #231](https://github.com/ignitionrobotics/ign-msgs/pull/231)

1. Focal CI: static checkers and doxygen linters
    * [Pull request #230](https://github.com/ignitionrobotics/ign-msgs/pull/230)

1. Add wheel slip message definition
    * [Pull request #205](https://github.com/ignitionrobotics/ign-msgs/pull/205)
    * [Pull request #227](https://github.com/ignitionrobotics/ign-msgs/pull/227)

1. Add PointCloudPacked iterators
    * [Pull request #210](https://github.com/ignitionrobotics/ign-msgs/pull/210)
    * [Pull request #218](https://github.com/ignitionrobotics/ign-msgs/pull/218)

1. Utility\_TEST: adjust expectations for 32-bit arch (#120)
    * [Pull request #120) (#196](https://github.com/ignitionrobotics/ign-msgs/pull/120) (#196)

1. Fix trivial typo in command line help message
    * [Pull request #191](https://github.com/ignitionrobotics/ign-msgs/pull/191)

1. Support colcon in windows CI
    * [Pull request #189](https://github.com/ignitionrobotics/ign-msgs/pull/189)

1. 🥳 Update ign-tools issue on README
    * [Pull request #184](https://github.com/ignitionrobotics/ign-msgs/pull/184)

### Ignition Msgs 7.2.0 (2021-09-10)

1. Adds PerformanceSensorMetrics proto message.
    * [Pull request #172](https://github.com/ignitionrobotics/ign-msgs/pull/172)

1. Detect ign instead of using cmake module to check for ignition-tools
    * [Pull request #166](https://github.com/ignitionrobotics/ign-msgs/pull/166)

1. Bazel build support
    * [Pull request #95](https://github.com/ignitionrobotics/ign-msgs/pull/95)

1. Remove tools/code_check and update codecov
    * [Pull request #164](https://github.com/ignitionrobotics/ign-msgs/pull/164)

1. Fixed the width spelling in a comment
    * [Pull request #161](https://github.com/ignitionrobotics/ign-msgs/pull/161)

### Ignition Msgs 7.1.0 (2021-04-30)

1. Added particle_emitter vector message
    * [Pull request #149](https://github.com/ignitionrobotics/ign-msgs/pull/149)

### Ignition Msgs 7.0.0 (2021-03-30)

1. Master branch updates
    * [Pull request #141](https://github.com/ignitionrobotics/ign-msgs/pull/141)

1. Added light intensity to light.proto
    * [Pull request #131](https://github.com/ignitionrobotics/ign-msgs/pull/131)

1. Add double sided field to material
    * [Pull request #130](https://github.com/ignitionrobotics/ign-msgs/pull/130)

1. Added capsule and ellipsoid geom msgs
    * [Pull request #128](https://github.com/ignitionrobotics/ign-msgs/pull/128)

1. Add lightmap texcoord set
    * [Pull request #124](https://github.com/ignitionrobotics/ign-msgs/pull/124)

1. README updates for Edifice
    * [Pull request #125](https://github.com/ignitionrobotics/ign-msgs/pull/125)
    * [Pull request #148](https://github.com/ignitionrobotics/ign-msgs/pull/148)

1. Added render order to material msgs
    * [Pull request #118](https://github.com/ignitionrobotics/ign-msgs/pull/118)

1. Added run_to_sim_time to world_control message.
    * [Pull request #108](https://github.com/ignitionrobotics/ign-msgs/pull/108)

1. Add a is_periodic_change field to SerializedStateMap
    * [Pull request #119](https://github.com/ignitionrobotics/ign-msgs/pull/119)

1. Remove deprecations, and a now invalid todo
    * [Pull request #112](https://github.com/ignitionrobotics/ign-msgs/pull/112)

1. Added light map to material.proto
    * [Pull request #111](https://github.com/ignitionrobotics/ign-msgs/pull/111)

## Ignition Msgs 6.x

### Ignition Msgs 6.6.0 (2021-08-30)

1. Adds PerformanceSensorMetrics proto message.
    * [Pull request #172](https://github.com/ignitionrobotics/ign-msgs/pull/172)

1. Detect ign instead of using cmake module to check for ignition-tools
    * [Pull request #166](https://github.com/ignitionrobotics/ign-msgs/pull/166)

1. Bazel build support for ign-msgs6
    * [Pull request #95](https://github.com/ignitionrobotics/ign-msgs/pull/95)

1. Remove tools/code_check and update codecov
    * [Pull request #164](https://github.com/ignitionrobotics/ign-msgs/pull/164)

### Ignition Msgs 6.5.0 (2021-04-06)

1. Added particle_emitter vector message
    * [Pull request 149](https://github.com/ignitionrobotics/ign-msgs/pull/149)

### Ignition Msgs 6.4.0 (2021-03-01)

1. Support 'has' functionality in particle Emitter.
    * [Pull request 137](https://github.com/ignitionrobotics/ign-msgs/pull/137)

1. Add ignition version of nav_msgs/OccupancyGrid.
    * [Pull request 138](https://github.com/ignitionrobotics/ign-msgs/pull/138)

### Ignition Msgs 6.3.0 (2021-02-17)

1. Particle emitter message.
    * [Pull request 127](https://github.com/ignitionrobotics/ign-msgs/pull/127)

1. Add std:: to strings in Generator.cc/hh
    * [Pull request 129](https://github.com/ignitionrobotics/ign-msgs/pull/129)

1. Add windows installation; move installation in README to tutorial
    * [Pull request 126](https://github.com/ignitionrobotics/ign-msgs/pull/126)

1. Includes changes found in version 5.6.0.

### Ignition Msgs 6.2.0 (2020-12-22)

1. Make ignstrtok private to Utility.cc
    * [Pull request 107](https://github.com/ignitionrobotics/ign-msgs/pull/107)

1. Added JointTrajectory message
    * [Pull request 106](https://github.com/ignitionrobotics/ign-msgs/pull/106)

1. Added Statistics message
    * [Pull request 110](https://github.com/ignitionrobotics/ign-msgs/pull/110)

### Ignition Msgs 6.1.0 (2020-12-01)

1. Includes changes found in version 5.4.0.

### Ignition Msgs 6.0.0 (2020-09-28)

1. Convert functions between duration and ignition::time.
    * [Pull request 85](https://github.com/ignitionrobotics/ign-msgs/pull/85)

1. Added utility functions to convert between msg::time and std::chrono time_point.
    * [Pull request 81](https://github.com/ignitionrobotics/ign-msgs/pull/81)

1. Update codeowners.
    * [Pull request 80](https://github.com/ignitionrobotics/ign-msgs/pull/80)

1. Included autogenerated code to the ign_create_docs function.
    * [Pull request 76](https://github.com/ignitionrobotics/ign-msgs/pull/76)

1. Feature/add visual arrow and axis.
    * [Pull request 62](https://github.com/ignitionrobotics/ign-msgs/pull/62)

1. Add Cone Geometry Type to marker.proto.
    * [Pull request 61](https://github.com/ignitionrobotics/ign-msgs/pull/61)

1. Use `/bigobj` in MSVC to support protobuf 3.12 library.
    * [Pull request 57](https://github.com/ignitionrobotics/ign-msgs/pull/57)

1. Workflow updates.
    * [Pull request 51](https://github.com/ignitionrobotics/ign-msgs/pull/51)

1. Add Cone Geometry Message.
    * [Pull request 47](https://github.com/ignitionrobotics/ign-msgs/pull/47)

1. Add .gitignore.
    * [Pull request 44](https://github.com/ignitionrobotics/ign-msgs/pull/44)

1. Update BitBucket links.
    * [Pull request 41](https://github.com/ignitionrobotics/ign-msgs/pull/41)

## Ignition Msgs 5.x

### Ignition Msgs 5.10.0 (2022-07-18)

1. Add entity wrench message
    * [Pull request #274](https://github.com/gazebosim/gz-msgs/pull/274)

1. Ignition -> Gazebo
    * [Pull request #273](https://github.com/gazebosim/gz-msgs/pull/273)

1. Add ACTOR and WORLD types to entity
    * [Pull request #275](https://github.com/gazebosim/gz-msgs/pull/275)

1. Bash completion for flags
    * [Pull request #254](https://github.com/gazebosim/gz-msgs/pull/254)

1. Remove dead files
    * [Pull request #255](https://github.com/gazebosim/gz-msgs/pull/255)

1. Fix typo REGRESION/REGRESSION
    * [Pull request #247](https://github.com/gazebosim/gz-msgs/pull/247)

1. Generator: Add missing std namespace to string arguments
    * [Pull request #242](https://github.com/gazebosim/gz-msgs/pull/242)

### Ignition Msgs 5.9.0 (2022-03-16)

1. Backport NavSat message for ROS bridge compatibility
    * [Pull request #231](https://github.com/ignitionrobotics/ign-msgs/pull/231)

1. Focal CI: static checkers and doxygen linters
    * [Pull request #230](https://github.com/ignitionrobotics/ign-msgs/pull/230)

1. Add PointCloudPacked iterators
    * [Pull request #210](https://github.com/ignitionrobotics/ign-msgs/pull/210)
    * [Pull request #218](https://github.com/ignitionrobotics/ign-msgs/pull/218)

### Ignition Msgs 5.8.1 (2021-10-29)

1. Utility\_TEST: adjust expectations for 32-bit arch (Backport of #120)
    * [Pull request #120](https://github.com/ignitionrobotics/ign-msgs/pull/120)
    * [Pull request #196](https://github.com/ignitionrobotics/ign-msgs/pull/196)

1. Fix trivial typo in command line help message
    * [Pull request #191](https://github.com/ignitionrobotics/ign-msgs/pull/191)

1. 🥳 Update ign-tools issue on README
    * [Pull request #184](https://github.com/ignitionrobotics/ign-msgs/pull/184)

### Ignition Msgs 5.8.0 (2021-08-06)

1. Adds PerformanceSensorMetrics proto message.
    * [Pull request #172](https://github.com/ignitionrobotics/ign-msgs/pull/172)

1. Detect ign instead of using cmake module to check for ignition-tools
    * [Pull request #166](https://github.com/ignitionrobotics/ign-msgs/pull/166)

1. Remove tools/code\_check and update codecov
    * [Pull request #164](https://github.com/ignitionrobotics/ign-msgs/pull/164)

### Ignition Msgs 5.7.0 (2021-03-17)

1. Add ignition version of nav\_msgs/OccupancyGrid (backport #138)
    * [Pull request 143](https://github.com/ignitionrobotics/ign-msgs/pull/143)
    * [Pull request 143](https://github.com/ignitionrobotics/ign-msgs/pull/138)

1. Master branch updates
    * [Pull request 141](https://github.com/ignitionrobotics/ign-msgs/pull/141)

1. Add windows installation; move installation in README to tutorial
    * [Pull request 126](https://github.com/ignitionrobotics/ign-msgs/pull/126)

### Ignition Msgs 5.6.0 (2020-12-28)

1. Add JointTrajectory message.
    * [Pull request 106](https://github.com/ignitionrobotics/ign-msgs/pull/106)
    * [Pull request 117](https://github.com/ignitionrobotics/ign-msgs/pull/117)

### Ignition Msgs 5.5.0 (2020-12-21)

1. Add statistics message.
    * [Pull request 110](https://github.com/ignitionrobotics/ign-msgs/pull/110)

### Ignition Msgs 5.4.0 (2020-11-12)

1. Add CMake options to support cross-compilation.
    * [Pull request 60](https://github.com/ignitionrobotics/ign-msgs/pull/60)

1. Add Focal CI.
    * [Pull request 73](https://github.com/ignitionrobotics/ign-msgs/pull/73)

1. Include autogenerated code for the ign\_create\_docs function.
    * [Pull request 76](https://github.com/ignitionrobotics/ign-msgs/pull/76)
    * [Pull request 78](https://github.com/ignitionrobotics/ign-msgs/pull/78)
    * [Pull request 79](https://github.com/ignitionrobotics/ign-msgs/pull/79)

1. Use modern CMake targets when including ignition-math.
    * [Pull request 82](https://github.com/ignitionrobotics/ign-msgs/pull/82)

1. Bump versions in readme.
    * [Pull request 88](https://github.com/ignitionrobotics/ign-msgs/pull/88)

1. Bump readme math version.
    * [Pull request 90](https://github.com/ignitionrobotics/ign-msgs/pull/90)

1. Improve fork experience.
    * [Pull request 94](https://github.com/ignitionrobotics/ign-msgs/pull/94)

1. Add dependency conversion for model.config's.
    * [Pull request 91](https://github.com/ignitionrobotics/ign-msgs/pull/91)

1. Resolved updated codecheck issues.
    * [Pull request 96](https://github.com/ignitionrobotics/ign-msgs/pull/96)

### Ignition Msgs 5.3.0 (2020-05-20)

1. Use modern CMake targets when including ignition-math.
    * [Pull request 82](https://github.com/ignitionrobotics/ign-msgs/pull/82)

1. Included autogenerated code to the ign_create_docs function.
    * [Pull request 78](https://github.com/ignitionrobotics/ign-msgs/pull/78)

1. Support multiple messages in a proto file.
    * [Pull request 70](https://github.com/ignitionrobotics/ign-msgs/pull/70)

1. Add CMake options to support cross-compilation.
    * [Pull request 60](https://github.com/ignitionrobotics/ign-msgs/pull/60)

1. Added the `EntityFactory_V` message.
    * [Pull request 58](https://github.com/ignitionrobotics/ign-msgs/pull/58)

### Ignition Msgs 5.2.0 (2020-05-14)

1. Handle empty xml elements
    * [BitBucket pull request 172](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/172)

1. Ignore deprecation warnings on generated code
    * [BitBucket pull request 170](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/170)

1. Add SdfGeneratorConfig message containing configuration options for generating SDFormat from currently loaded worlds
    * [BitBucket pull request 174](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/174)

1. BitBucket to GitHub migration
    * [Pull request](https://github.com/ignitionrobotics/ign-msgs/pull/39)
    * [Pull request](https://github.com/ignitionrobotics/ign-msgs/pull/40)
    * [Pull request](https://github.com/ignitionrobotics/ign-msgs/pull/43)

### Ignition Msgs 5.1.0

1. Add ConvertPixelFormatType functions to Utility.hh
    * [BitBucket pull request 169](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/169)

### Ignition Msgs 5.0.0 (2019-12-09)

1. Add support for sdformat frame semantics
    * [BitBucket pull request 160](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/160)

1. Add emissive_map field to material.proto
    * [BitBucket pull request 155](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/155)

1. Add discovery message
    * [BitBucket pull request 159](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/159)

1. Deprecate all double fields in joint_cmd and pid, replace with Double
    * [BitBucket pull request 162](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/162)

1. Factory relative to
    * [BitBucket pull request 163](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/163)

1. Added `fuel_metadata.proto`, `version.proto`, `version_range.proto`, and `versioned_name.proto` message files. Added conversion functions to/from the model.config/metadata.pbtxt formats.
    * [BitBucket pull request 157](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/157)


## Ignition Msgs 4.x

### Ignition Msgs 4.9.0 (2020-05-20)

1. Included autogenerated code to the ign_create_docs function.
    * [Pull request 79](https://github.com/ignitionrobotics/ign-msgs/pull/79)

1. Add Focal CI.
    * [Pull request 73](https://github.com/ignitionrobotics/ign-msgs/pull/73)

1. Added the `EntityFactory_V` message.
    * [Pull request 58](https://github.com/ignitionrobotics/ign-msgs/pull/58)

### Ignition Msgs 4.8.0 (2020-04-09)

1. Add SdfGeneratorConfig message containing configuration options for generating SDFormat from currently loaded worlds
    * [BitBucket pull request 174](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/174)

1. Fix linking order of Protocol Buffers static libraries on GCC
    * [BitBucket pull request 151](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/151)

1. Ignore deprecation warnings on generated code
    * [BitBucket pull request 170](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/170)

### Ignition Msgs 4.7.0 (2019-08-22)

1. Add video record message
    * [BitBucket pull request 149](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/149)

### Ignition Msgs 4.6.0 (2019-08-16)

1. Add Actor message
    * [BitBucket pull request 147](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/147)

### Ignition Msgs 4.5.0 (2019-07-19)

1. Add battery state message
    * [BitBucket pull request 145](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/145)

### Ignition Msgs 4.4.0 (2019-07-16)

1. Added SerializedEntityMap, SerializedStateMap, and SerializedStepMap
   messages which match SerializedEntity, SerializedState, and SerializedStep messages except that the former uses `map` data structures.
    * [BitBucket pull request 143](https://github.com/ignitionrobotics/ign-common/pull-requests/143)

### Ignition Msgs 4.2.0

1. Added odometry message
    * [BitBucket pull request 137](https://github.com/ignitionrobotics/ign-common/pull-requests/137)

### Ignition Msgs 4.1.0

1. Added camera info message
    * [BitBucket pull request 136](https://github.com/ignitionrobotics/ign-common/pull-requests/136)

### Ignition Msgs 4.0.0 (2019-05-20)

1. Add world stats to packet message.
    * [BitBucket pull request 125](https://github.com/ignitionrobotics/ign-common/pull-requests/125)

1. Deprecating `raysensor.proto`, and replacing with `lidar_sensor.proto`.
    * [BitBucket pull request 124](https://github.com/ignitionrobotics/ign-common/pull-requests/124)

1. Added orientation reference frame information to `imu_sensor.proto`.
    * [BitBucket pull request 121](https://github.com/ignitionrobotics/ign-common/pull-requests/121)

1. New actuators `actuators.proto` message.
    * [BitBucket pull request 123](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/123)
    * [BitBucket pull request 129](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/129)

1. Added Physically Based Rendering (PBR) message to `material.proto`
    * [BitBucket pull request 120](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/120)

1. Corrected `BAYER_RGGR8` to `BAYER_BGGR8` in `PixelFormatType` located in
`proto/ignition/msgs/image.proto`.
    * [BitBucket pull request 118](https://github.com/ignitionrobotics/ign-common/pull-requests/118)

1. Adding `dynamic_bias_stddev` and `dynamic_bias_correlation_time` sensor noise parameters.
    * [BitBucket pull request 117](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/117)

1. Added `fluid_pressure.proto` and `air_pressure_sensor.proto`.
    * [BitBucket pull request 116](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/116)

1. Added `step_size` to `WorldStatistics` and `SerializedStep`
    * [BitBucket pull request 122](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/122)

1. Added an `altimeter_sensor.proto` message that encapsulates information
   about an altimeter sensor.
    * [BitBucket pull request 114](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/114)

1. Added a `magnetometer_sensor.proto` message that encapsulates information
   about  a magnetometer sensor.
    * [BitBucket pull request 113](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/113)

1. image: `pixel_format` field is deprecated, use `pixel_format_type` with enum `PixelFormatType` instead.
    * [BitBucket pull request 106](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/106)
    * [BitBucket pull request 95](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/95)

1. Updated `model.proto` with more documentation. Position, velocity, force,
   and acceleration information for joint have been moved to the `axis.proto`
   message, see the Migration guide. The `ign.hh` header file is no longer
   installed.
    * [BitBucket pull request 104](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/104)

1. Change serialized field from string to bytes.
    * [BitBucket pull request 102](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/102)

1. Install ruby files into versioned folder
    * [BitBucket pull request 109](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/109)
    * [Issue 24](https://github.com/ignitionrobotics/ign-msgs/issues/24)
    * [Issue 27](https://github.com/ignitionrobotics/ign-msgs/issues/27)

## Ignition Msgs 3.x

### Ignition Msgs 3.x.x

1. Install ruby files into versioned folder
    * [BitBucket pull request 111](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/111)
    * [Issue 24](https://github.com/ignitionrobotics/ign-msgs/issues/24)
    * [Issue 27](https://github.com/ignitionrobotics/ign-msgs/issues/27)

1. Fix linking order of Protocol Buffers static libraries on GCC
    * [BitBucket pull request 151](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/151)

### Ignition Msgs 3.2.0

1. Added Pose_V, Time, and Clock fields to packet.proto
    * [BitBucket pull request 108](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/108)

### Ignition Msgs 3.1.0

1. Added serialized messages: SerializedState, SerializedEntity, SerializedComponent
    * [BitBucket pull request 99](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/99)

1. image.proto: add `PixelFormatType` enum, copied from `ignition::common::Image::PixelFormatType`
    * [BitBucket pull request 97](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/97)


### Ignition Msgs 3.0.0

1. axis\_aligned\_box: new message and conversion functions
    * [BitBucket pull request 91](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/91)

1. contacts: use Entity instead of string to specify entities in contact
    * [BitBucket pull request 90](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/90)

1. entity: new message to uniquely identify an entity
    * [BitBucket pull request 87](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/87)

1. entity\_factory: refactor message, remove edit\_name field
    * [BitBucket pull request 86](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/86)
    * [Issue 25](https://github.com/ignitionrobotics/ign-msgs/issues/25)

1. Add twist message
    * [BitBucket pull request 83](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/83)

1. Update light msgs fields
    * [BitBucket pull request 78](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/78)

1. Combine docs
    * [BitBucket pull request 75](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/75)

1. configure.bat: don't need to list recursive dependencies
    * [BitBucket pull request 74](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/74)

1. Update gtest
    * [BitBucket pull request 73](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/73)

1. Upgrade to protobuf3
    * [BitBucket pull request 69](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/69)

1. Fix ruby message generation.
    * [BitBucket pull request 47](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/47)


## Ignition Msgs 2.x

### Ignition Msgs 2.x.x

1. Fix linking order of Protocol Buffers static libraries on GCC
    * [BitBucket pull request 151](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/151)

### Ignition Msgs 2.1.0

1. Upgrade to ign-math6
    * [BitBucket pull request 138](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/138)


### Ignition Msgs 2.0.0

1. sonar: add geometry field
    * [BitBucket pull request 82](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/82)

1. log\_control, log\_status: add record\_resources bool to match osrf/gazebo PR 3008
    * [BitBucket pull request 76](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/76)
    * [osrf/gazebo Pull request 3008](https://osrf-migration.github.io/gazebo-gh-pages/#!/osrf/gazebo/pull-requests/3008)

1. Added inline versioned namespace. Generator.hh is no longer installed
    * [BitBucket pull request 59](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/59)

1. Upgrade to ign-cmake1
    * [BitBucket pull request 55](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/55)

1. Extend Factory class
    * [BitBucket pull request 61](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/61)
    * [BitBucket pull request 66](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/66)

1. Add real\_time\_factor field to WorldStatistics
    * [BitBucket pull request 67](https://osrf-migration.github.io/ignition-gh-pages/#!/ignitionrobotics/ign-msgs/pull-requests/67)
