/*
 *                         OpenSplice DDS
 *
 *   This software and documentation are Copyright 2006 to TO_YEAR PrismTech
 *   Limited, its affiliated companies and licensors. All rights reserved.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
#include "dds/core/detail/dds_builtinTopicsSplDcps.h"
#include "dds/core/detail/dds_builtinTopics.h"

#include <v_copyIn.h>
#include <v_topic.h>
#include <os_stdlib.h>
#include <string.h>
#include <os_report.h>

#include "org/opensplice/core/policy/PolicyDelegate.hpp"
#include "org/opensplice/core/ReportUtils.hpp"

v_copyin_result
__DDS_octSeq__copyIn(
    c_base base,
    const dds::core::ByteSeq *from,
    _DDS_octSeq *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    c_type type0 = NULL;
    c_type subtype0 = NULL;
    c_ulong length0;
    c_octet *dest0;

    // TODO: Grab type from c_base parameter.
    if (type0 == NULL) {
        subtype0 = c_type(c_metaResolve (c_metaObject(base), "c_octet"));
        type0 = c_metaSequenceTypeNew(c_metaObject(base),"C_SEQUENCE<c_octet>",subtype0,0);
        c_free(subtype0);
    }
    length0 = from->size();
    dest0 = (c_octet *)c_newSequence_s(c_collectionType(type0), length0);
    if(dest0 != NULL) {
        /* Code generated by C:\cygwin\home\git_master\ospli\src\tools\idlpp\code\idl_genCorbaCxxCopyin.c at line 2017 */
        const c_octet *buf0;
        buf0 = (const c_octet *)(&(from[0]));
        memcpy (dest0,buf0,length0* sizeof(*dest0));
        *to = (_DDS_octSeq)dest0;
    } else {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    c_free(type0);
    return result;
}

v_copyin_result
__DDS_BuiltinTopicKey_t__copyIn(
    c_base base,
    const dds::topic::BuiltinTopicKey *from,
    _DDS_BuiltinTopicKey_t *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    memcpy (to, from->value(), sizeof (*to));
    return result;
}

v_copyin_result
__DDS_StringSeq__copyIn(
    c_base base,
    const dds::core::StringSeq *from,
    _DDS_StringSeq *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    c_type type0 = NULL;
    c_type subtype0 = NULL;
    c_ulong length0;
    c_string *dest0;

    // TODO: Grab type from c_base parameter.
    if (type0 == NULL) {
        subtype0 = c_type(c_metaResolve (c_metaObject(base), "c_string"));
        type0 = c_metaSequenceTypeNew(c_metaObject(base),"C_SEQUENCE<c_string>",subtype0,0);
        c_free(subtype0);
    }
    length0 = from->size();
    dest0 = (c_string *)c_newSequence_s(c_collectionType(type0), length0);
    if(dest0 != NULL) {
        unsigned int i0;
        for (i0 = 0; (i0 < length0) && V_COPYIN_RESULT_IS_OK(result); i0++) {
            dest0[i0] = c_stringNew_s(base, (*from)[i0].c_str());
            if(dest0[i0] == NULL) {
                result = V_COPYIN_RESULT_OUT_OF_MEMORY;
            }
        }
        *to = (_DDS_StringSeq)dest0;
    } else {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    c_free(type0);
    return result;
}

v_copyin_result
__DDS_Duration_t__copyIn(
    c_base base,
    const struct dds::core::Duration *from,
    struct _DDS_Duration_t *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    to->sec = (c_long)from->sec();
    to->nanosec = (c_ulong)from->nanosec();
    return result;
}

v_copyin_result
__DDS_UserDataQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::UserData *from,
    struct _DDS_UserDataQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::ByteSeq userData = from->value();
        result = __DDS_octSeq__copyIn(base, &userData, &to->value);
    }
    return result;
}

v_copyin_result
__DDS_TopicDataQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::TopicData *from,
    struct _DDS_TopicDataQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::ByteSeq topicData = from->value();
        result = __DDS_octSeq__copyIn(base, &topicData, &to->value);
    }
    return result;
}

v_copyin_result
__DDS_GroupDataQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::GroupData *from,
    struct _DDS_GroupDataQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::ByteSeq groupData = from->value();
        result = __DDS_octSeq__copyIn(base, &groupData, &to->value);
    }
    return result;
}

v_copyin_result
__DDS_TransportPriorityQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::TransportPriority *from,
    struct _DDS_TransportPriorityQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    to->value = (c_long)from->value();
    return result;
}

v_copyin_result
__DDS_LifespanQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::Lifespan *from,
    struct _DDS_LifespanQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::Duration duration = from->duration();
        result = __DDS_Duration_t__copyIn(base, &duration, &to->duration);
    }
    return result;
}

v_copyin_result
__DDS_DurabilityQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::Durability *from,
    struct _DDS_DurabilityQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    if((((c_long)from->kind()) >= 0) && (((c_long)from->kind()) < 4) ){
        to->kind = (enum _DDS_DurabilityQosPolicyKind)from->kind();
    } else {
        OS_REPORT (OS_ERROR, "copyIn", 0,"Member 'dds::core::policy::Durability.kind' of type 'dds::core::policy::DurabilityKind' is out of range.");
        result = V_COPYIN_RESULT_INVALID;
    }
    return result;
}

v_copyin_result
__DDS_PresentationQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::Presentation *from,
    struct _DDS_PresentationQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    if((((c_long)from->access_scope()) >= 0) && (((c_long)from->access_scope()) < 3) ){
        to->access_scope = (enum _DDS_PresentationQosPolicyAccessScopeKind)from->access_scope();
    } else {
        OS_REPORT (OS_ERROR, "copyIn", 0,"Member 'dds::core::policy::Presentation.access_scope' of type 'dds::core::policy::PresentationAccessScopeKind' is out of range.");
        result = V_COPYIN_RESULT_INVALID;
    }
    to->coherent_access = (c_bool)from->coherent_access();
    to->ordered_access = (c_bool)from->ordered_access();
    return result;
}

v_copyin_result
__DDS_DeadlineQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::Deadline *from,
    struct _DDS_DeadlineQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::Duration period = from->period();
        result = __DDS_Duration_t__copyIn(base, &period, &to->period);
    }
    return result;
}

v_copyin_result
__DDS_LatencyBudgetQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::LatencyBudget *from,
    struct _DDS_LatencyBudgetQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::Duration duration = from->duration();
        result = __DDS_Duration_t__copyIn(base, &duration, &to->duration);
    }
    return result;
}

v_copyin_result
__DDS_OwnershipQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::Ownership *from,
    struct _DDS_OwnershipQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    if((((c_long)from->kind()) >= 0) && (((c_long)from->kind()) < 2) ){
        to->kind = (enum _DDS_OwnershipQosPolicyKind)from->kind();
    } else {
        OS_REPORT (OS_ERROR, "copyIn", 0,"Member 'dds::core::policy::Ownership.kind' of type 'dds::core::policy::OwnershipKind' is out of range.");
        result = V_COPYIN_RESULT_INVALID;
    }
    return result;
}

v_copyin_result
__DDS_OwnershipStrengthQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::OwnershipStrength *from,
    struct _DDS_OwnershipStrengthQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    to->value = (c_long)from->value();
    return result;
}

v_copyin_result
__DDS_LivelinessQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::Liveliness *from,
    struct _DDS_LivelinessQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if((((c_long)from->kind()) >= 0) && (((c_long)from->kind()) < 3) ){
        to->kind = (enum _DDS_LivelinessQosPolicyKind)from->kind();
    } else {
        OS_REPORT (OS_ERROR, "copyIn", 0,"Member 'dds::core::policy::Liveliness.kind' of type 'dds::core::policy::LivelinessKind' is out of range.");
        result = V_COPYIN_RESULT_INVALID;
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::Duration lease_duration = from->lease_duration();
        result = __DDS_Duration_t__copyIn(base, &lease_duration, &to->lease_duration);
    }
    return result;
}

v_copyin_result
__DDS_TimeBasedFilterQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::TimeBasedFilter *from,
    struct _DDS_TimeBasedFilterQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::Duration minimum_separation = from->minimum_separation();
        result = __DDS_Duration_t__copyIn(base, &minimum_separation, &to->minimum_separation);
    }
    return result;
}

v_copyin_result
__DDS_PartitionQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::Partition *from,
    struct _DDS_PartitionQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::StringSeq name = from->name();
        result = __DDS_StringSeq__copyIn(base, &name, &to->name);
    }
    return result;
}

v_copyin_result
__DDS_ReliabilityQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::Reliability *from,
    struct _DDS_ReliabilityQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if((((c_long)from->kind()) >= 0) && (((c_long)from->kind()) < 2) ){
        to->kind = (enum _DDS_ReliabilityQosPolicyKind)from->kind();
    } else {
        OS_REPORT (OS_ERROR, "copyIn", 0,"Member 'dds::core::policy::Reliability.kind' of type 'dds::core::policy::ReliabilityKind' is out of range.");
        result = V_COPYIN_RESULT_INVALID;
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::Duration max_blocking_time = from->max_blocking_time();
        result = __DDS_Duration_t__copyIn(base, &max_blocking_time, &to->max_blocking_time);
    }
    to->synchronous = (c_bool)(*from)->synchronous();
    return result;
}

v_copyin_result
__DDS_DestinationOrderQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::DestinationOrder *from,
    struct _DDS_DestinationOrderQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    if((((c_long)from->kind()) >= 0) && (((c_long)from->kind()) < 2) ){
        to->kind = (enum _DDS_DestinationOrderQosPolicyKind)from->kind();
    } else {
        OS_REPORT (OS_ERROR, "copyIn", 0,"Member 'dds::core::policy::DestinationOrder.kind' of type 'dds::core::policy::DestinationOrderKind' is out of range.");
        result = V_COPYIN_RESULT_INVALID;
    }
    return result;
}

v_copyin_result
__DDS_HistoryQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::History *from,
    struct _DDS_HistoryQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    if((((c_long)from->kind()) >= 0) && (((c_long)from->kind()) < 2) ){
        to->kind = (enum _DDS_HistoryQosPolicyKind)from->kind();
    } else {
        OS_REPORT (OS_ERROR, "copyIn", 0,"Member 'const dds::core::policy::History.kind' of type 'dds::core::policy::HistoryKind' is out of range.");
        result = V_COPYIN_RESULT_INVALID;
    }
    to->depth = (c_long)from->depth();
    return result;
}

v_copyin_result
__DDS_ResourceLimitsQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::ResourceLimits *from,
    struct _DDS_ResourceLimitsQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    to->max_samples = (c_long)from->max_samples();
    to->max_instances = (c_long)from->max_instances();
    to->max_samples_per_instance = (c_long)from->max_samples_per_instance();
    return result;
}

v_copyin_result
__DDS_DurabilityServiceQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::DurabilityService *from,
    struct _DDS_DurabilityServiceQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::Duration service_cleanup_delay = from->service_cleanup_delay();
        result = __DDS_Duration_t__copyIn(base, &service_cleanup_delay, &to->service_cleanup_delay);
    }
    if((((c_long)from->history_kind()) >= 0) && (((c_long)from->history_kind()) < 2) ){
        to->history_kind = (enum _DDS_HistoryQosPolicyKind)from->history_kind();
    } else {
        OS_REPORT (OS_ERROR, "copyIn", 0,"Member 'dds::core::policy::DurabilityService.history_kind' of type 'dds::core::policy::HistoryKind' is out of range.");
        result = V_COPYIN_RESULT_INVALID;
    }
    to->history_depth = (c_long)from->history_depth();
    to->max_samples = (c_long)from->max_samples();
    to->max_instances = (c_long)from->max_instances();
    to->max_samples_per_instance = (c_long)from->max_samples_per_instance();
    return result;
}

v_copyin_result
__DDS_ProductDataQosPolicy__copyIn(
    c_base base,
    const org::opensplice::core::policy::ProductData *from,
    struct _DDS_ProductDataQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    to->value = c_stringNew_s(base, from->name().c_str());
    if(to->value == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    return result;
}

v_copyin_result
__DDS_EntityFactoryQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::EntityFactory *from,
    struct _DDS_EntityFactoryQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    to->autoenable_created_entities = (c_bool)from->autoenable_created_entities();
    return result;
}

v_copyin_result
__DDS_ShareQosPolicy__copyIn(
    c_base base,
    const org::opensplice::core::policy::Share *from,
    struct _DDS_ShareQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    to->name = c_stringNew_s(base, from->name().c_str());
    if(to->name == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    to->enable = (c_bool)from->enable();
    return result;
}

v_copyin_result
__DDS_WriterDataLifecycleQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::WriterDataLifecycle *from,
    struct _DDS_WriterDataLifecycleQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    to->autodispose_unregistered_instances = (c_bool)(*from).autodispose_unregistered_instances();
    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::Duration autopurge_suspended_samples_delay = (*from)->autopurge_suspended_samples_delay();
        result = __DDS_Duration_t__copyIn(base, &autopurge_suspended_samples_delay, &to->autopurge_suspended_samples_delay);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::Duration autounregister_instance_delay = (*from)->autounregister_instance_delay();
        result = __DDS_Duration_t__copyIn(base, &autounregister_instance_delay, &to->autounregister_instance_delay);
    }
    return result;
}

v_copyin_result
__DDS_InvalidSampleVisibilityQosPolicy__copyIn(
    c_base base,
    const org::opensplice::core::policy::InvalidSampleVisibility::Type *from,
    struct _DDS_InvalidSampleVisibilityQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    if((c_long) (*from) >= 0 && (c_long) (*from) < 3 ){
        to->kind = (enum _DDS_InvalidSampleVisibilityQosPolicyKind) (*from);
    } else {
        OS_REPORT (OS_ERROR, "copyIn", 0,"Member 'org::opensplice::core::policy::InvalidSampleVisibility' of type 'org::opensplice::core::policy::InvalidSampleVisibilityKind' is out of range.");
        result = V_COPYIN_RESULT_INVALID;
    }
    return result;
}

v_copyin_result
__DDS_SubscriptionKeyQosPolicy__copyIn(
    c_base base,
    const org::opensplice::core::policy::SubscriptionKey *from,
    struct _DDS_SubscriptionKeyQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    to->use_key_list = (c_bool)from->use_key_list();
    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::StringSeq key_list = from->key();
        result = __DDS_StringSeq__copyIn(base, &key_list, &to->key_list);
    }
    return result;
}

v_copyin_result
__DDS_ReaderDataLifecycleQosPolicy__copyIn(
    c_base base,
    const dds::core::policy::ReaderDataLifecycle *from,
    struct _DDS_ReaderDataLifecycleQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::Duration autopurge_nowriter_samples_delay = (*from).autopurge_nowriter_samples_delay();
        result = __DDS_Duration_t__copyIn(base, &autopurge_nowriter_samples_delay, &to->autopurge_nowriter_samples_delay);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::Duration autopurge_disposed_samples_delay = (*from).autopurge_disposed_samples_delay();
        result = __DDS_Duration_t__copyIn(base, &autopurge_disposed_samples_delay, &to->autopurge_disposed_samples_delay);
    }
    to->autopurge_dispose_all = (c_bool)(*from)->autopurge_dispose_all();
    to->enable_invalid_samples = (c_bool)(*from)->enable_invalid_samples();
    if(V_COPYIN_RESULT_IS_OK(result)){
        org::opensplice::core::policy::InvalidSampleVisibility::Type visibility = (*from)->invalid_sample_visibility();
        result = __DDS_InvalidSampleVisibilityQosPolicy__copyIn(base, &visibility, &to->invalid_sample_visibility);
    }
    return result;
}

v_copyin_result
__DDS_UserKeyQosPolicy__copyIn(
    c_base base,
    const org::opensplice::core::policy::SubscriptionKey *from,
    struct _DDS_UserKeyQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    size_t strLen = 0, size = from->key().size(), i;

    to->enable = (c_bool)from->use_key_list();
    if (to->enable) {
        try {
            org::opensplice::core::policy::helper::convertStringSeq(from->key(), to->expression, ",");
        } catch (int32_t error) {
            result = V_COPYIN_RESULT_OUT_OF_MEMORY;
        }
    }
    return result;
}

v_copyin_result
__DDS_ReaderLifespanQosPolicy__copyIn(
    c_base base,
    const org::opensplice::core::policy::ReaderLifespan *from,
    struct _DDS_ReaderLifespanQosPolicy *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    to->use_lifespan = (c_bool)from->used();
    if(V_COPYIN_RESULT_IS_OK(result)){
        dds::core::Duration duration = from->duration();
        result = __DDS_Duration_t__copyIn(base, &duration, &to->duration);
    }
    return result;
}

v_copyin_result
__DDS_TypeHash__copyIn(
    c_base base,
    const class org::opensplice::topic::TypeHash *from,
    struct _DDS_TypeHash *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    to->msb = (c_ulonglong) from->msb();
    to->lsb = (c_ulonglong) from->lsb();
    return result;
}

v_copyin_result
__DDS_ParticipantBuiltinTopicData__copyIn(
    c_base base,
    const dds::topic::ParticipantBuiltinTopicData *from,
    struct _DDS_ParticipantBuiltinTopicData *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->key(), &to->key);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_UserDataQosPolicy__copyIn(base, &from->user_data(), &to->user_data);
    }
    return result;
}

v_copyin_result
__DDS_TopicBuiltinTopicData__copyIn(
    c_base base,
    const dds::topic::TopicBuiltinTopicData *from,
    struct _DDS_TopicBuiltinTopicData *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->key(), &to->key);
    }
    to->name = c_stringNew_s(base, from->name().c_str());
    if(to->name == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    to->type_name = c_stringNew_s(base, from->type_name().c_str());
    if(to->type_name == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_DurabilityQosPolicy__copyIn(base, &from->durability(), &to->durability);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_DurabilityServiceQosPolicy__copyIn(base, &from->durability_service(), &to->durability_service);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_DeadlineQosPolicy__copyIn(base, &from->deadline(), &to->deadline);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_LatencyBudgetQosPolicy__copyIn(base, &from->latency_budget(), &to->latency_budget);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_LivelinessQosPolicy__copyIn(base, &from->liveliness(), &to->liveliness);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ReliabilityQosPolicy__copyIn(base, &from->reliability(), &to->reliability);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_TransportPriorityQosPolicy__copyIn(base, &from->transport_priority(), &to->transport_priority);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_LifespanQosPolicy__copyIn(base, &from->lifespan(), &to->lifespan);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_DestinationOrderQosPolicy__copyIn(base, &from->destination_order(), &to->destination_order);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_HistoryQosPolicy__copyIn(base, &from->history(), &to->history);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ResourceLimitsQosPolicy__copyIn(base, &from->resource_limits(), &to->resource_limits);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_OwnershipQosPolicy__copyIn(base, &from->ownership(), &to->ownership);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_TopicDataQosPolicy__copyIn(base, &from->topic_data(), &to->topic_data);
    }
    return result;
}

v_copyin_result
__DDS_TypeBuiltinTopicData__copyIn(
    c_base base,
    const org::opensplice::topic::TypeBuiltinTopicData *from,
    struct _DDS_TypeBuiltinTopicData *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;
    (void) base;

    to->name = c_stringNew_s(base, from->name().c_str());
    if(to->name == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    to->data_representation_id = (c_short)from->data_representation_id();
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_TypeHash__copyIn(base, &from->type_hash(), &to->type_hash);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_octSeq__copyIn(base, &from->meta_data(), &to->meta_data);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_octSeq__copyIn(base, &from->extentions(), &to->extentions);
    }
    return result;
}

v_copyin_result
__DDS_PublicationBuiltinTopicData__copyIn(
    c_base base,
    const dds::topic::PublicationBuiltinTopicData *from,
    struct _DDS_PublicationBuiltinTopicData *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->key(), &to->key);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->participant_key(), &to->participant_key);
    }
    to->topic_name = c_stringNew_s(base, from->topic_name().c_str());
    if(to->topic_name == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    to->type_name = c_stringNew_s(base, from->type_name().c_str());
    if(to->type_name == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_DurabilityQosPolicy__copyIn(base, &from->durability(), &to->durability);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_DeadlineQosPolicy__copyIn(base, &from->deadline(), &to->deadline);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_LatencyBudgetQosPolicy__copyIn(base, &from->latency_budget(), &to->latency_budget);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_LivelinessQosPolicy__copyIn(base, &from->liveliness(), &to->liveliness);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ReliabilityQosPolicy__copyIn(base, &from->reliability(), &to->reliability);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_LifespanQosPolicy__copyIn(base, &from->lifespan(), &to->lifespan);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_DestinationOrderQosPolicy__copyIn(base, &from->destination_order(), &to->destination_order);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_UserDataQosPolicy__copyIn(base, &from->user_data(), &to->user_data);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_OwnershipQosPolicy__copyIn(base, &from->ownership(), &to->ownership);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_OwnershipStrengthQosPolicy__copyIn(base, &from->ownership_strength(), &to->ownership_strength);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_PresentationQosPolicy__copyIn(base, &from->presentation(), &to->presentation);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_PartitionQosPolicy__copyIn(base, &from->partition(), &to->partition);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_TopicDataQosPolicy__copyIn(base, &from->topic_data(), &to->topic_data);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_GroupDataQosPolicy__copyIn(base, &from->group_data(), &to->group_data);
    }
    return result;
}

v_copyin_result
__DDS_SubscriptionBuiltinTopicData__copyIn(
    c_base base,
    const dds::topic::SubscriptionBuiltinTopicData *from,
    struct _DDS_SubscriptionBuiltinTopicData *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->key(), &to->key);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->participant_key(), &to->participant_key);
    }
    to->topic_name = c_stringNew_s(base, from->topic_name().c_str());
    if(to->topic_name == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    to->type_name = c_stringNew_s(base, from->type_name().c_str());
    if(to->type_name == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_DurabilityQosPolicy__copyIn(base, &from->durability(), &to->durability);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_DeadlineQosPolicy__copyIn(base, &from->deadline(), &to->deadline);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_LatencyBudgetQosPolicy__copyIn(base, &from->latency_budget(), &to->latency_budget);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_LivelinessQosPolicy__copyIn(base, &from->liveliness(), &to->liveliness);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ReliabilityQosPolicy__copyIn(base, &from->reliability(), &to->reliability);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_OwnershipQosPolicy__copyIn(base, &from->ownership(), &to->ownership);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_DestinationOrderQosPolicy__copyIn(base, &from->destination_order(), &to->destination_order);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_UserDataQosPolicy__copyIn(base, &from->user_data(), &to->user_data);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_TimeBasedFilterQosPolicy__copyIn(base, &from->time_based_filter(), &to->time_based_filter);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_PresentationQosPolicy__copyIn(base, &from->presentation(), &to->presentation);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_PartitionQosPolicy__copyIn(base, &from->partition(), &to->partition);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_TopicDataQosPolicy__copyIn(base, &from->topic_data(), &to->topic_data);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_GroupDataQosPolicy__copyIn(base, &from->group_data(), &to->group_data);
    }
    return result;
}

v_copyin_result
__DDS_CMParticipantBuiltinTopicData__copyIn(
    c_base base,
    const org::opensplice::topic::CMParticipantBuiltinTopicData *from,
    struct _DDS_CMParticipantBuiltinTopicData *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->key(), &to->key);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ProductDataQosPolicy__copyIn(base, &from->product(), &to->product);
    }
    return result;
}

v_copyin_result
__DDS_CMPublisherBuiltinTopicData__copyIn(
    c_base base,
    const org::opensplice::topic::CMPublisherBuiltinTopicData *from,
    struct _DDS_CMPublisherBuiltinTopicData *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->key(), &to->key);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ProductDataQosPolicy__copyIn(base, &from->product(), &to->product);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->participant_key(), &to->participant_key);
    }
    to->name = c_stringNew_s(base, from->name().c_str());
    if(to->name == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_EntityFactoryQosPolicy__copyIn(base, &from->entity_factory(), &to->entity_factory);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_PartitionQosPolicy__copyIn(base, &from->partition(), &to->partition);
    }
    return result;
}

v_copyin_result
__DDS_CMSubscriberBuiltinTopicData__copyIn(
    c_base base,
    const org::opensplice::topic::CMSubscriberBuiltinTopicData *from,
    struct _DDS_CMSubscriberBuiltinTopicData *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->key(), &to->key);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ProductDataQosPolicy__copyIn(base, &from->product(), &to->product);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->participant_key(), &to->participant_key);
    }
    to->name = c_stringNew_s(base, from->name().c_str());
    if(to->name == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_EntityFactoryQosPolicy__copyIn(base, &from->entity_factory(), &to->entity_factory);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ShareQosPolicy__copyIn(base, &from->share(), &to->share);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_PartitionQosPolicy__copyIn(base, &from->partition(), &to->partition);
    }
    return result;
}

v_copyin_result
__DDS_CMDataWriterBuiltinTopicData__copyIn(
    c_base base,
    const org::opensplice::topic::CMDataWriterBuiltinTopicData *from,
    struct _DDS_CMDataWriterBuiltinTopicData *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->key(), &to->key);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ProductDataQosPolicy__copyIn(base, &from->product(), &to->product);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->publisher_key(), &to->publisher_key);
    }
    to->name = c_stringNew_s(base, from->name().c_str());
    if(to->name == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_HistoryQosPolicy__copyIn(base, &from->history(), &to->history);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ResourceLimitsQosPolicy__copyIn(base, &from->resource_limits(), &to->resource_limits);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_WriterDataLifecycleQosPolicy__copyIn(base, &from->writer_data_lifecycle(), &to->writer_data_lifecycle);
    }
    return result;
}

v_copyin_result
__DDS_CMDataReaderBuiltinTopicData__copyIn(
    c_base base,
    const org::opensplice::topic::CMDataReaderBuiltinTopicData *from,
    struct _DDS_CMDataReaderBuiltinTopicData *to)
{
    v_copyin_result result = V_COPYIN_RESULT_OK;

    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->key(), &to->key);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ProductDataQosPolicy__copyIn(base, &from->product(), &to->product);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_BuiltinTopicKey_t__copyIn(base, &from->subscriber_key(), &to->subscriber_key);
    }
    to->name = c_stringNew_s(base, from->name().c_str());
    if(to->name == NULL) {
        result = V_COPYIN_RESULT_OUT_OF_MEMORY;
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_HistoryQosPolicy__copyIn(base, &from->history(), &to->history);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ResourceLimitsQosPolicy__copyIn(base, &from->resource_limits(), &to->resource_limits);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ReaderDataLifecycleQosPolicy__copyIn(base, &from->reader_data_lifecycle(), &to->reader_data_lifecycle);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_UserKeyQosPolicy__copyIn(base, &from->subscription_keys(), &to->subscription_keys);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ReaderLifespanQosPolicy__copyIn(base, &from->reader_lifespan(), &to->reader_lifespan);
    }
    if(V_COPYIN_RESULT_IS_OK(result)){
        result = __DDS_ShareQosPolicy__copyIn(base, &from->share(), &to->share);
    }
    return result;
}

void
__DDS_octSeq__copyOut(
    const void *_from,
    void *_to)
{
    const _DDS_octSeq *from = (const _DDS_octSeq *)_from;
    dds::core::ByteSeq *to = (dds::core::ByteSeq *)_to;
    long size0;

    size0 = c_arraySize(c_sequence(*from));
    to->clear();
    to->reserve(size0);
    {
        to->insert(to->end(), *from, *from + size0);
    }
}

void
__DDS_BuiltinTopicKey_t__copyOut(
    const void *_from,
    void *_to)
{
    const _DDS_BuiltinTopicKey_t *from = (const _DDS_BuiltinTopicKey_t *)_from;
    dds::topic::BuiltinTopicKey *to = (dds::topic::BuiltinTopicKey *)_to;
    to->value((int32_t*) *from);
}

void
__DDS_StringSeq__copyOut(
    const void *_from,
    void *_to)
{
    const _DDS_StringSeq *from = (const _DDS_StringSeq *)_from;
    dds::core::StringSeq *to = (dds::core::StringSeq *)_to;
    long size0, i0;
    const c_string *src0 = (const c_string *)(*from);

    size0 = c_arraySize(c_sequence(src0));
    to->clear();
    to->reserve(size0);
    for (i0 = 0; i0 < size0; i0++) {
        (*to)[i0] = src0[i0];
    }
}

void
__DDS_Duration_t__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_Duration_t *from = (const struct _DDS_Duration_t *)_from;
    struct dds::core::Duration *to = (struct dds::core::Duration *)_to;
    to->sec((int64_t)from->sec);
    to->nanosec((uint32_t)from->nanosec);
}

void
__DDS_UserDataQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_UserDataQosPolicy *from = (const struct _DDS_UserDataQosPolicy *)_from;
    dds::core::policy::UserData *to = (dds::core::policy::UserData *)_to;
    {
        dds::core::ByteSeq userData;
        __DDS_octSeq__copyOut(&from->value, &userData);
        to->value(userData);
    }
}

void
__DDS_TopicDataQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_TopicDataQosPolicy *from = (const struct _DDS_TopicDataQosPolicy *)_from;
    dds::core::policy::TopicData *to = (dds::core::policy::TopicData *)_to;
    {
        dds::core::ByteSeq topicData;
        extern void __DDS_octSeq__copyOut(const void *, void *);
        __DDS_octSeq__copyOut(&from->value, &topicData);
        to->value(topicData);
    }
}

void
__DDS_GroupDataQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_GroupDataQosPolicy *from = (const struct _DDS_GroupDataQosPolicy *)_from;
    dds::core::policy::GroupData *to = (dds::core::policy::GroupData *)_to;
    {
        dds::core::ByteSeq groupData;
        __DDS_octSeq__copyOut(&from->value, &groupData);
        to->value(groupData);
    }
}

void
__DDS_TransportPriorityQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_TransportPriorityQosPolicy *from = (const struct _DDS_TransportPriorityQosPolicy *)_from;
    dds::core::policy::TransportPriority *to = (dds::core::policy::TransportPriority *)_to;
    to->value((int32_t) from->value);
}

void
__DDS_LifespanQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_LifespanQosPolicy *from = (const struct _DDS_LifespanQosPolicy *)_from;
    dds::core::policy::Lifespan *to = (dds::core::policy::Lifespan *)_to;
    {
        dds::core::Duration duration;
        __DDS_Duration_t__copyOut(&from->duration, &duration);
        to->duration(duration);
    }
}

void
__DDS_DurabilityQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_DurabilityQosPolicy *from = (const struct _DDS_DurabilityQosPolicy *)_from;
    dds::core::policy::Durability *to = (dds::core::policy::Durability *)_to;
    to->kind((dds::core::policy::DurabilityKind::Type) from->kind);
}

void
__DDS_PresentationQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_PresentationQosPolicy *from = (const struct _DDS_PresentationQosPolicy *)_from;
    dds::core::policy::Presentation *to = (dds::core::policy::Presentation *)_to;
    to->access_scope((dds::core::policy::PresentationAccessScopeKind::Type) from->access_scope);
    to->coherent_access((bool) from->coherent_access);
    to->ordered_access((bool) from->ordered_access);
}

void
__DDS_DeadlineQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_DeadlineQosPolicy *from = (const struct _DDS_DeadlineQosPolicy *)_from;
    dds::core::policy::Deadline *to = (dds::core::policy::Deadline *)_to;
    {
        dds::core::Duration period;
        __DDS_Duration_t__copyOut(&from->period, &period);
        to->period(period);
    }
}

void
__DDS_LatencyBudgetQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_LatencyBudgetQosPolicy *from = (const struct _DDS_LatencyBudgetQosPolicy *)_from;
    dds::core::policy::LatencyBudget *to = (dds::core::policy::LatencyBudget *)_to;
    {
        dds::core::Duration duration;
        __DDS_Duration_t__copyOut(&from->duration, &duration);
        to->duration(duration);
    }
}

void
__DDS_OwnershipQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_OwnershipQosPolicy *from = (const struct _DDS_OwnershipQosPolicy *)_from;
    dds::core::policy::Ownership *to = (dds::core::policy::Ownership *)_to;
    to->kind((dds::core::policy::OwnershipKind::Type) from->kind);
}

void
__DDS_OwnershipStrengthQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_OwnershipStrengthQosPolicy *from = (const struct _DDS_OwnershipStrengthQosPolicy *)_from;
    dds::core::policy::OwnershipStrength *to = (dds::core::policy::OwnershipStrength *)_to;
    to->value((int32_t) from->value);
}

void
__DDS_LivelinessQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_LivelinessQosPolicy *from = (const struct _DDS_LivelinessQosPolicy *)_from;
    dds::core::policy::Liveliness *to = (dds::core::policy::Liveliness *)_to;
    to->kind((dds::core::policy::LivelinessKind::Type) from->kind);
    {
        dds::core::Duration duration;
        __DDS_Duration_t__copyOut(&from->lease_duration, &duration);
        to->lease_duration(duration);
    }
}

void
__DDS_TimeBasedFilterQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_TimeBasedFilterQosPolicy *from = (const struct _DDS_TimeBasedFilterQosPolicy *)_from;
    dds::core::policy::TimeBasedFilter *to = (dds::core::policy::TimeBasedFilter *)_to;
    {
        dds::core::Duration minSep;
        __DDS_Duration_t__copyOut(&from->minimum_separation, &minSep);
        to->minimum_separation(minSep);
    }
}

void
__DDS_PartitionQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_PartitionQosPolicy *from = (const struct _DDS_PartitionQosPolicy *)_from;
    dds::core::policy::Partition *to = (dds::core::policy::Partition *)_to;
    {
        dds::core::StringSeq names;
        __DDS_StringSeq__copyOut(&from->name, &names);
        to->name(names);
    }
}

void
__DDS_ReliabilityQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_ReliabilityQosPolicy *from = (const struct _DDS_ReliabilityQosPolicy *)_from;
    dds::core::policy::Reliability *to = (dds::core::policy::Reliability *)_to;
    (*to).kind((dds::core::policy::ReliabilityKind::Type) from->kind);
    {
        dds::core::Duration duration;
        __DDS_Duration_t__copyOut(&from->max_blocking_time, &duration);
        (*to).max_blocking_time(duration);
    }
    (*to)->synchronous((bool) from->synchronous);
}

void
__DDS_DestinationOrderQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_DestinationOrderQosPolicy *from = (const struct _DDS_DestinationOrderQosPolicy *)_from;
    dds::core::policy::DestinationOrder *to = (dds::core::policy::DestinationOrder *)_to;
    to->kind((dds::core::policy::DestinationOrderKind::Type) from->kind);
}

void
__DDS_HistoryQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_HistoryQosPolicy *from = (const struct _DDS_HistoryQosPolicy *)_from;
    dds::core::policy::History *to = (dds::core::policy::History *)_to;
    to->kind((dds::core::policy::HistoryKind::Type) from->kind);
    to->depth((int32_t) from->depth);
}

void
__DDS_ResourceLimitsQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_ResourceLimitsQosPolicy *from = (const struct _DDS_ResourceLimitsQosPolicy *)_from;
    dds::core::policy::ResourceLimits *to = (dds::core::policy::ResourceLimits *)_to;
    to->max_samples((int32_t) from->max_samples);
    to->max_instances((int32_t) from->max_instances);
    to->max_samples_per_instance((int32_t) from->max_samples_per_instance);
}

void
__DDS_DurabilityServiceQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_DurabilityServiceQosPolicy *from = (const struct _DDS_DurabilityServiceQosPolicy *)_from;
    dds::core::policy::DurabilityService *to = (dds::core::policy::DurabilityService *)_to;
    {
        dds::core::Duration delay;
        __DDS_Duration_t__copyOut(&from->service_cleanup_delay, &delay);
        to->service_cleanup_delay(delay);
    }
    to->history_kind((dds::core::policy::HistoryKind::Type) from->history_kind);
    to->history_depth((int32_t) from->history_depth);
    to->max_samples((int32_t) from->max_samples);
    to->max_instances((int32_t) from->max_instances);
    to->max_samples_per_instance((int32_t) from->max_samples_per_instance);
}

void
__DDS_ProductDataQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_ProductDataQosPolicy *from = (const struct _DDS_ProductDataQosPolicy *)_from;
    org::opensplice::core::policy::ProductData *to = (org::opensplice::core::policy::ProductData *)_to;
    to->name(from->value ? from->value : "");
}

void
__DDS_EntityFactoryQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_EntityFactoryQosPolicy *from = (const struct _DDS_EntityFactoryQosPolicy *)_from;
    dds::core::policy::EntityFactory *to = (dds::core::policy::EntityFactory *)_to;
    to->autoenable_created_entities((bool) from->autoenable_created_entities);
}

void
__DDS_ShareQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_ShareQosPolicy *from = (const struct _DDS_ShareQosPolicy *)_from;
    org::opensplice::core::policy::Share *to = (org::opensplice::core::policy::Share *)_to;
    to->name(from->name ? from->name : "");
    to->enable((bool) from->enable);
}

void
__DDS_WriterDataLifecycleQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_WriterDataLifecycleQosPolicy *from = (const struct _DDS_WriterDataLifecycleQosPolicy *)_from;
    dds::core::policy::WriterDataLifecycle *to = (dds::core::policy::WriterDataLifecycle *)_to;
    (*to).autodispose_unregistered_instances((bool) from->autodispose_unregistered_instances);
    {
        dds::core::Duration delay;
        __DDS_Duration_t__copyOut(&from->autopurge_suspended_samples_delay, &delay);
        (*to)->autopurge_suspended_samples_delay(delay);
    }
    {
        dds::core::Duration delay;
        __DDS_Duration_t__copyOut(&from->autounregister_instance_delay, &delay);
        (*to)->autounregister_instance_delay(delay);
    }
}

void
__DDS_InvalidSampleVisibilityQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_InvalidSampleVisibilityQosPolicy *from = (const struct _DDS_InvalidSampleVisibilityQosPolicy *)_from;
    org::opensplice::core::policy::InvalidSampleVisibility::Type *to = (org::opensplice::core::policy::InvalidSampleVisibility::Type *)_to;
    *to = (org::opensplice::core::policy::InvalidSampleVisibility::Type) from->kind;
}

void
__DDS_SubscriptionKeyQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_SubscriptionKeyQosPolicy *from = (const struct _DDS_SubscriptionKeyQosPolicy *)_from;
    org::opensplice::core::policy::SubscriptionKey *to = (org::opensplice::core::policy::SubscriptionKey *)_to;
    to->use_key_list((bool) from->use_key_list);
    {
        dds::core::StringSeq keyList;
        __DDS_StringSeq__copyOut((const void *)&from->key_list, &keyList);
        to->key(keyList);
    }
}

void
__DDS_ReaderDataLifecycleQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_ReaderDataLifecycleQosPolicy *from = (const struct _DDS_ReaderDataLifecycleQosPolicy *)_from;
    dds::core::policy::ReaderDataLifecycle *to = (dds::core::policy::ReaderDataLifecycle *)_to;
    {
        dds::core::Duration delay;
        __DDS_Duration_t__copyOut(&from->autopurge_nowriter_samples_delay, &delay);
        (*to).autopurge_nowriter_samples_delay(delay);
    }
    {
        dds::core::Duration delay;
        __DDS_Duration_t__copyOut(&from->autopurge_disposed_samples_delay, &delay);
        (*to).autopurge_disposed_samples_delay(delay);
    }
    (*to)->autopurge_dispose_all((bool) from->autopurge_dispose_all);
    (*to)->enable_invalid_samples((bool) from->enable_invalid_samples);
    {
        org::opensplice::core::policy::InvalidSampleVisibility::Type visibility;
        __DDS_InvalidSampleVisibilityQosPolicy__copyOut(&from->invalid_sample_visibility, &visibility);
        (*to)->invalid_sample_visibility(visibility);
    }
}

void
__DDS_UserKeyQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_UserKeyQosPolicy *from = (const struct _DDS_UserKeyQosPolicy *)_from;
    org::opensplice::core::policy::SubscriptionKey *to = (org::opensplice::core::policy::SubscriptionKey *)_to;
    to->use_key_list((bool) from->enable);
    {
        dds::core::StringSeq expression;
        org::opensplice::core::policy::helper::convertStringSeq(from->expression, expression, ",");
        to->key(expression);
    }
}

void
__DDS_ReaderLifespanQosPolicy__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_ReaderLifespanQosPolicy *from = (const struct _DDS_ReaderLifespanQosPolicy *)_from;
    org::opensplice::core::policy::ReaderLifespan *to = (org::opensplice::core::policy::ReaderLifespan *)_to;
    to->used((bool) from->use_lifespan);
    {
        dds::core::Duration duration;
        __DDS_Duration_t__copyOut(&from->duration, &duration);
        to->duration(duration);
    }
}

void
__DDS_TypeHash__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_TypeHash *from = (const struct _DDS_TypeHash *)_from;
    org::opensplice::topic::TypeHash *to = (org::opensplice::topic::TypeHash *)_to;
    to->msb((uint64_t) from->msb);
    to->lsb((uint64_t) from->lsb);
}

void
__DDS_ParticipantBuiltinTopicData__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_ParticipantBuiltinTopicData *from = (const struct _DDS_ParticipantBuiltinTopicData *)_from;
    dds::topic::ParticipantBuiltinTopicData *to = (dds::topic::ParticipantBuiltinTopicData *)_to;
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->key, &key);
        (*to)->key(key);
    }
    {
        dds::core::policy::UserData userData;
        __DDS_UserDataQosPolicy__copyOut(&from->user_data, &userData);
        (*to)->user_data(userData);
    }
}

void
__DDS_TopicBuiltinTopicData__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_TopicBuiltinTopicData *from = (const struct _DDS_TopicBuiltinTopicData *)_from;
    dds::topic::TopicBuiltinTopicData *to = (dds::topic::TopicBuiltinTopicData *)_to;
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->key, &key);
        (*to)->key(key);
    }
    (*to)->name(from->name ? from->name : "");
    (*to)->type_name(from->type_name ? from->type_name : "");
    {
        dds::core::policy::Durability durability;
        __DDS_DurabilityQosPolicy__copyOut(&from->durability, &durability);
        (*to)->durability(durability);
    }
    {
        dds::core::policy::DurabilityService durabilityService;
        __DDS_DurabilityServiceQosPolicy__copyOut(&from->durability_service, &durabilityService);
        (*to)->durability_service(durabilityService);
    }
    {
        dds::core::policy::Deadline deadline;
        __DDS_DeadlineQosPolicy__copyOut(&from->deadline, &deadline);
        (*to)->deadline(deadline);
    }
    {
        dds::core::policy::LatencyBudget budget;
        __DDS_LatencyBudgetQosPolicy__copyOut(&from->latency_budget, &budget);
        (*to)->latency_budget(budget);
    }
    {
        dds::core::policy::Liveliness liveliness;
        __DDS_LivelinessQosPolicy__copyOut(&from->liveliness, &liveliness);
        (*to)->liveliness(liveliness);
    }
    {
        dds::core::policy::Reliability reliability;
        __DDS_ReliabilityQosPolicy__copyOut(&from->reliability, &reliability);
        (*to)->reliability(reliability);
    }
    {
        dds::core::policy::TransportPriority priority;
        __DDS_TransportPriorityQosPolicy__copyOut(&from->transport_priority, &priority);
        (*to)->transport_priority(priority);
    }
    {
        dds::core::policy::Lifespan lifespan;
        __DDS_LifespanQosPolicy__copyOut(&from->lifespan, &lifespan);
        (*to)->lifespan(lifespan);
    }
    {
        dds::core::policy::DestinationOrder order;
        __DDS_DestinationOrderQosPolicy__copyOut(&from->destination_order, &order);
        (*to)->destination_order(order);
    }
    {
        dds::core::policy::History history;
        __DDS_HistoryQosPolicy__copyOut(&from->history, &history);
        (*to)->history(history);
    }
    {
        dds::core::policy::ResourceLimits limits;
        __DDS_ResourceLimitsQosPolicy__copyOut(&from->resource_limits, &limits);
        (*to)->resource_limits(limits);
    }
    {
        dds::core::policy::Ownership ownership;
        __DDS_OwnershipQosPolicy__copyOut(&from->ownership, &ownership);
        (*to)->ownership(ownership);
    }
    {
        dds::core::policy::TopicData topicData;
        __DDS_TopicDataQosPolicy__copyOut(&from->topic_data, &topicData);
        (*to)->topic_data(topicData);
    }
}

void
__DDS_TypeBuiltinTopicData__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_TypeBuiltinTopicData *from = (const struct _DDS_TypeBuiltinTopicData *)_from;
    org::opensplice::topic::TypeBuiltinTopicData *to = (org::opensplice::topic::TypeBuiltinTopicData *)_to;
    (*to)->name(from->name ? from->name : "");
    (*to)->data_representation_id((org::opensplice::topic::DataRepresentationId_t)from->data_representation_id);
    {
        org::opensplice::topic::TypeHash hash;
        __DDS_TypeHash__copyOut(&from->type_hash, &hash);
        (*to)->type_hash(hash);
    }
    {
        dds::core::ByteSeq metaData;
        __DDS_octSeq__copyOut(&from->meta_data, &metaData);
        (*to)->meta_data(metaData);
    }
    {
        dds::core::ByteSeq extentions;
        __DDS_octSeq__copyOut(&from->extentions, &extentions);
        (*to)->extentions(extentions);
    }
}

void
__DDS_PublicationBuiltinTopicData__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_PublicationBuiltinTopicData *from = (const struct _DDS_PublicationBuiltinTopicData *)_from;
    dds::topic::PublicationBuiltinTopicData *to = (dds::topic::PublicationBuiltinTopicData *)_to;
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->key, &key);
        (*to)->key(key);
    }
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->participant_key, &key);
        (*to)->participant_key(key);
    }
    (*to)->topic_name(from->topic_name ? from->topic_name : "");
    (*to)->type_name(from->type_name ? from->type_name : "");
    {
        dds::core::policy::Durability durability;
        __DDS_DurabilityQosPolicy__copyOut(&from->durability,&durability);
        (*to)->durability(durability);
    }
    {
        dds::core::policy::Deadline deadline;
        __DDS_DeadlineQosPolicy__copyOut(&from->deadline, &deadline);
        (*to)->deadline(deadline);
    }
    {
        dds::core::policy::LatencyBudget budget;
        __DDS_LatencyBudgetQosPolicy__copyOut(&from->latency_budget, &budget);
        (*to)->latency_budget(budget);
    }
    {
        dds::core::policy::Liveliness liveliness;
        __DDS_LivelinessQosPolicy__copyOut(&from->liveliness, &liveliness);
        (*to)->liveliness(liveliness);
    }
    {
        dds::core::policy::Reliability reliability;
        __DDS_ReliabilityQosPolicy__copyOut(&from->reliability, &reliability);
        (*to)->reliability(reliability);
    }
    {
        dds::core::policy::Lifespan lifespan;
        __DDS_LifespanQosPolicy__copyOut(&from->lifespan, &lifespan);
        (*to)->lifespan(lifespan);
    }
    {
        dds::core::policy::DestinationOrder order;
        __DDS_DestinationOrderQosPolicy__copyOut(&from->destination_order, &order);
        (*to)->destination_order(order);
    }
    {
        dds::core::policy::UserData userData;
        __DDS_UserDataQosPolicy__copyOut(&from->user_data, &userData);
        (*to)->user_data(userData);
    }
    {
        dds::core::policy::Ownership ownership;
        __DDS_OwnershipQosPolicy__copyOut(&from->ownership, &ownership);
        (*to)->ownership(ownership);
    }
    {
        dds::core::policy::OwnershipStrength strength;
        __DDS_OwnershipStrengthQosPolicy__copyOut(&from->ownership_strength, &strength);
        (*to)->ownership_strength(strength);
    }
    {
        dds::core::policy::Presentation presentation;
        __DDS_PresentationQosPolicy__copyOut(&from->presentation, &presentation);
        (*to)->presentation(presentation);
    }
    {
        dds::core::policy::Partition partition;
        __DDS_PartitionQosPolicy__copyOut(&from->partition, &partition);
        (*to)->partition(partition);
    }
    {
        dds::core::policy::TopicData topicData;
        __DDS_TopicDataQosPolicy__copyOut(&from->topic_data, &topicData);
        (*to)->topic_data(topicData);
    }
    {
        dds::core::policy::GroupData groupData;
        __DDS_GroupDataQosPolicy__copyOut(&from->group_data, &groupData);
        (*to)->group_data(groupData);
    }
}

void
__DDS_SubscriptionBuiltinTopicData__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_SubscriptionBuiltinTopicData *from = (const struct _DDS_SubscriptionBuiltinTopicData *)_from;
    dds::topic::SubscriptionBuiltinTopicData *to = (dds::topic::SubscriptionBuiltinTopicData *)_to;
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->key, &key);
        (*to)->key(key);
    }
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->participant_key, &key);
        (*to)->participant_key(key);
    }
    (*to)->topic_name(from->topic_name ? from->topic_name : "");
    (*to)->type_name(from->type_name ? from->type_name : "");
    {
        dds::core::policy::Durability durability;
        __DDS_DurabilityQosPolicy__copyOut(&from->durability,&durability);
        (*to)->durability(durability);
    }
    {
        dds::core::policy::Deadline deadline;
        __DDS_DeadlineQosPolicy__copyOut(&from->deadline, &deadline);
        (*to)->deadline(deadline);
    }
    {
        dds::core::policy::LatencyBudget budget;
        __DDS_LatencyBudgetQosPolicy__copyOut(&from->latency_budget, &budget);
        (*to)->latency_budget(budget);
    }
    {
        dds::core::policy::Liveliness liveliness;
        __DDS_LivelinessQosPolicy__copyOut(&from->liveliness, &liveliness);
        (*to)->liveliness(liveliness);
    }
    {
        dds::core::policy::Reliability reliability;
        __DDS_ReliabilityQosPolicy__copyOut(&from->reliability, &reliability);
        (*to)->reliability(reliability);
    }
    {
        dds::core::policy::Ownership ownership;
        __DDS_OwnershipQosPolicy__copyOut(&from->ownership, &ownership);
        (*to)->ownership(ownership);
    }
    {
        dds::core::policy::DestinationOrder order;
        __DDS_DestinationOrderQosPolicy__copyOut(&from->destination_order, &order);
        (*to)->destination_order(order);
    }
    {
        dds::core::policy::UserData userData;
        __DDS_UserDataQosPolicy__copyOut(&from->user_data, &userData);
        (*to)->user_data(userData);
    }
    {
        dds::core::policy::TimeBasedFilter filter;
        __DDS_TimeBasedFilterQosPolicy__copyOut(&from->time_based_filter, &filter);
        (*to)->time_based_filter(filter);
    }
    {
        dds::core::policy::Presentation presentation;
        __DDS_PresentationQosPolicy__copyOut(&from->presentation, &presentation);
        (*to)->presentation(presentation);
    }
    {
        dds::core::policy::Partition partition;
        __DDS_PartitionQosPolicy__copyOut(&from->partition, &partition);
        (*to)->partition(partition);
    }
    {
        dds::core::policy::TopicData topicData;
        __DDS_TopicDataQosPolicy__copyOut(&from->topic_data, &topicData);
        (*to)->topic_data(topicData);
    }
    {
        dds::core::policy::GroupData groupData;
        __DDS_GroupDataQosPolicy__copyOut(&from->group_data, &groupData);
        (*to)->group_data(groupData);
    }
}

void
__DDS_CMParticipantBuiltinTopicData__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_CMParticipantBuiltinTopicData *from = (const struct _DDS_CMParticipantBuiltinTopicData *)_from;
    org::opensplice::topic::CMParticipantBuiltinTopicData *to = (org::opensplice::topic::CMParticipantBuiltinTopicData *)_to;
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->key, &key);
        (*to)->key(key);
    }
    {
        org::opensplice::core::policy::ProductData productData;
        __DDS_ProductDataQosPolicy__copyOut(&from->product, &productData);
        (*to)->product(productData);
    }
}

void
__DDS_CMPublisherBuiltinTopicData__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_CMPublisherBuiltinTopicData *from = (const struct _DDS_CMPublisherBuiltinTopicData *)_from;
    org::opensplice::topic::CMPublisherBuiltinTopicData *to = (org::opensplice::topic::CMPublisherBuiltinTopicData *)_to;
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->key, &key);
        (*to)->key(key);
    }
    {
        org::opensplice::core::policy::ProductData productData;
        __DDS_ProductDataQosPolicy__copyOut(&from->product, &productData);
        (*to)->product(productData);
    }
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->participant_key, &key);
        (*to)->participant_key(key);
    }
    (*to)->name(from->name ? from->name : "");
    {
        dds::core::policy::EntityFactory toggle;
        __DDS_EntityFactoryQosPolicy__copyOut(&from->entity_factory, &toggle);
        (*to)->entity_factory(toggle);
    }
    {
        dds::core::policy::Partition partition;
        __DDS_PartitionQosPolicy__copyOut(&from->partition, &partition);
        (*to)->partition(partition);
    }
}

void
__DDS_CMSubscriberBuiltinTopicData__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_CMSubscriberBuiltinTopicData *from = (const struct _DDS_CMSubscriberBuiltinTopicData *)_from;
    org::opensplice::topic::CMSubscriberBuiltinTopicData *to = (org::opensplice::topic::CMSubscriberBuiltinTopicData *)_to;
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->key, &key);
        (*to)->key(key);
    }
    {
        org::opensplice::core::policy::ProductData productData;
        __DDS_ProductDataQosPolicy__copyOut(&from->product, &productData);
        (*to)->product(productData);
    }
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->participant_key, &key);
        (*to)->participant_key(key);
    }
    (*to)->name(from->name ? from->name : "");
    {
        dds::core::policy::EntityFactory toggle;
        __DDS_EntityFactoryQosPolicy__copyOut(&from->entity_factory, &toggle);
        (*to)->entity_factory(toggle);
    }
    {
        org::opensplice::core::policy::Share share;
        __DDS_ShareQosPolicy__copyOut(&from->share, &share);
        (*to)->share(share);
    }
    {
        dds::core::policy::Partition partition;
        __DDS_PartitionQosPolicy__copyOut(&from->partition, &partition);
        (*to)->partition(partition);
    }
}

void
__DDS_CMDataWriterBuiltinTopicData__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_CMDataWriterBuiltinTopicData *from = (const struct _DDS_CMDataWriterBuiltinTopicData *)_from;
    org::opensplice::topic::CMDataWriterBuiltinTopicData *to = (org::opensplice::topic::CMDataWriterBuiltinTopicData *)_to;
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->key, &key);
        (*to)->key(key);
    }
    {
        org::opensplice::core::policy::ProductData productData;
        __DDS_ProductDataQosPolicy__copyOut(&from->product, &productData);
        (*to)->product(productData);
    }
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->publisher_key, &key);
        (*to)->publisher_key(key);
    }
    (*to)->name(from->name ? from->name : "");
    {
        dds::core::policy::History history;
        __DDS_HistoryQosPolicy__copyOut(&from->history, &history);
        (*to)->history(history);
    }
    {
        dds::core::policy::ResourceLimits limits;
        __DDS_ResourceLimitsQosPolicy__copyOut(&from->resource_limits, &limits);
        (*to)->resource_limits(limits);
    }
    {
        dds::core::policy::WriterDataLifecycle lifecycle;
        __DDS_WriterDataLifecycleQosPolicy__copyOut(&from->writer_data_lifecycle, &lifecycle);
        (*to)->writer_data_lifecycle(lifecycle);
    }
}

void
__DDS_CMDataReaderBuiltinTopicData__copyOut(
    const void *_from,
    void *_to)
{
    const struct _DDS_CMDataReaderBuiltinTopicData *from = (const struct _DDS_CMDataReaderBuiltinTopicData *)_from;
    org::opensplice::topic::CMDataReaderBuiltinTopicData *to = (org::opensplice::topic::CMDataReaderBuiltinTopicData *)_to;
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->key, &key);
        (*to)->key(key);
    }
    {
        org::opensplice::core::policy::ProductData productData;
        __DDS_ProductDataQosPolicy__copyOut(&from->product, &productData);
        (*to)->product(productData);
    }
    {
        dds::topic::BuiltinTopicKey key;
        __DDS_BuiltinTopicKey_t__copyOut(&from->subscriber_key, &key);
        (*to)->subscriber_key(key);
    }
    (*to)->name(from->name ? from->name : "");
    {
        dds::core::policy::History history;
        __DDS_HistoryQosPolicy__copyOut(&from->history, &history);
        (*to)->history(history);
    }
    {
        dds::core::policy::ResourceLimits limits;
        __DDS_ResourceLimitsQosPolicy__copyOut(&from->resource_limits, &limits);
        (*to)->resource_limits(limits);
    }
    {
        dds::core::policy::ReaderDataLifecycle lifecycle;
        __DDS_ReaderDataLifecycleQosPolicy__copyOut(&from->reader_data_lifecycle, &lifecycle);
        (*to)->reader_data_lifecycle(lifecycle);
    }
    {
        org::opensplice::core::policy::SubscriptionKey keyList;
        __DDS_UserKeyQosPolicy__copyOut(&from->subscription_keys, &keyList);
        (*to)->subscription_keys(keyList);
    }
    {
        org::opensplice::core::policy::ReaderLifespan lifespan;
        __DDS_ReaderLifespanQosPolicy__copyOut(&from->reader_lifespan, &lifespan);
        (*to)->reader_lifespan(lifespan);
    }
    {
        org::opensplice::core::policy::Share share;
        __DDS_ShareQosPolicy__copyOut(&from->share, &share);
        (*to)->share(share);
    }
}

