/*
 *                         Vortex OpenSplice
 *
 *   This software and documentation are Copyright 2006 to TO_YEAR ADLINK
 *   Technology Limited, its affiliated companies and licensors. All rights
 *   reserved.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
package org.opensplice.cm.qos;

/**
 * Determines the mechanism  used by the application to determine whether an 
 * Entity is "active" (alive).
 * 
 * @date Jan 10, 2005 
 */
public class LivelinessKind {
    public static final int _AUTOMATIC          = 0;
    public static final int _PARTICIPANT        = 1;
    public static final int _TOPIC              = 2;
    
    /**
     * The infrastructure will automatically signal liveliness for the writers 
     * at least as often as required by the lease_duration in the 
     * LivelinessPolicy.
     */
    public static final LivelinessKind AUTOMATIC      = new LivelinessKind(_AUTOMATIC);
    
    /**
     * The service will assume that as long as at least one Entity within the
     * Participant has asserted its liveliness the other Entities in that same
     * Participant are also alive.
     */
    public static final LivelinessKind PARTICIPANT    = new LivelinessKind(_PARTICIPANT);
    
    /**
     * The service will only assume liveliness of the Writer if the application 
     * has asserted liveliness of that Writer itself.
     */
    public static final LivelinessKind TOPIC          = new LivelinessKind(_TOPIC);
    
    /**
     * Resolves the integer representation of the kind.
     * 
     * @return The integer representation of the kind.
     */
    public int value(){
        int result = -1;
        
        if(this.equals(AUTOMATIC)){
            result = _AUTOMATIC;
        } else if(this.equals(PARTICIPANT)){
            result = _PARTICIPANT;
        } else if(this.equals(TOPIC)){
            result = _TOPIC;
        }
        return result;
    }
    
    /**
     * Constructs the kind from its integer representation.
     * 
     * @return The created kind.
     */
    public static LivelinessKind from_int(int value){
        LivelinessKind result = null;
        
        if(value == _AUTOMATIC){
            result = AUTOMATIC;
        } else if(value == _PARTICIPANT){
            result = PARTICIPANT;
        } else if( value == _TOPIC){
            result = TOPIC;
        }
        return result;
    }
    
    /**
     * Constructs the kind from its string representation.
     * 
     * @return The created kind.
     */
    public static LivelinessKind from_string(String value){
        LivelinessKind result = null;
        
        if("V_LIVELINESS_AUTOMATIC".equals(value)){
            result = AUTOMATIC;
        } else if("V_LIVELINESS_PARTICIPANT".equals(value)){
            result = PARTICIPANT;
        } else if("V_LIVELINESS_TOPIC".equals(value)){
            result = TOPIC;
        } else if("AUTOMATIC".equals(value)){
            result = AUTOMATIC;
        } else if("PARTICIPANT".equals(value)){
            result = PARTICIPANT;
        } else if("TOPIC".equals(value)){
            result = TOPIC;
        }
        
        return result;
    }
    
    /**
     * Resolves the string representation of the kind.
     * 
     * @return The string representation of the kind.
     */
    @Override
    public String toString(){
        String result = "UNKNOWN";
        
        if(this.equals(AUTOMATIC)){
            result = "AUTOMATIC";
        } else if(this.equals(PARTICIPANT)){
            result = "PARTICIPANT";
        } else if(this.equals(TOPIC)){
            result = "TOPIC";
        }
        return result;
    }
    
    public String toKernelString(){
        String result = "UNKNOWN";
        
        if(this.equals(AUTOMATIC)){
            result = "V_LIVELINESS_AUTOMATIC";
        } else if(this.equals(PARTICIPANT)){
            result = "V_LIVELINESS_PARTICIPANT";
        } else if(this.equals(TOPIC)){
            result = "V_LIVELINESS_TOPIC";
        }
        return result;
    }
    
    protected LivelinessKind(int value){}
    
    
}
