The DataReader      {#DCPS_Modules_Subscription_DataReader}
===============

The DataReader is responsible for reading **typed** sample and sample information from the middleware and is equivalent to the DataWriter, the DataReader and DataWriter provide the bulk of Listeners, conditions and QoS available in DDS as they're the intermediaries between the middleware and the application.

The DataReader is an abstract class, that is always sub-classed by a typed specialisation, which is generated by the pre-processor:
- For a type **Foo** the preprocessor generates a **FooDataReader**
    - This typed subclass contains all the functions or methods that pass parameters of type Foo
        - *This was, type-safety is ensured by the compiler*
    - Since the Subscriber is type-independent, it can not return a typed DataReader: the result will have to be down-casted to its proper type by the application




### Applicable QoS

QoS      | Brief
---------|---------
\ref DCPS_QoS_UserData "USER_DATA"                          | User data
\ref DCPS_QoS_Durability "DURABILITY"                       | Expresses the lifetime of a sample
\ref DCPS_QoS_Deadline "DEADLINE"                           | Sets the period in which a sample must be received
\ref DCPS_QoS_LatencyBudget "LATENCY_BUDGET"                | Specifies the maximum acceptable delay for a sample in transit
\ref DCPS_QoS_Liveliness "LIVELINESS"                       | Set the method by which an instance is considered alive (publishing)
\ref DCPS_QoS_Ownership "OWNERSHIP"                         | Specifies if samples should be treated as having a single of multiple owners
\ref DCPS_QoS_TimeBasedFilter "TIME_BASED_FILTER"           | Filter based on the time separation between samples
\ref DCPS_QoS_Reliability "RELIABILITY"                     | Set the required reliability of a DataReader/DataWriter pair, reliable or best effort
\ref DCPS_QoS_DestinationOrder "DESTINATION_ORDER"          | Controls the logical order of the samples, by reception time-stamp or source time-stamp
\ref DCPS_QoS_History "HISTORY"                             | Specify how many generations of the same instance to keep
\ref DCPS_QoS_ResourceLimits "RESOURCE_LIMITS"              | Specify the amount of resources the DataReader can consume
\ref DCPS_QoS_ReaderDataLifecycle "READER_DATA_LIFECYCLE"   | Specify the lifecycle for data-instances
\ref DCPS_QoS_SubscriptionKey "SUBSCRIPTION_KEYS"           | Allows the DataReader to define its own set of keys on the data, different from the keys defined by the topic
\ref DCPS_QoS_ReaderLifespan "READER_LIFESPAN"              | Automatically remove samples from the DataReader after a specified timeout.
\ref DCPS_QoS_Share "SHARE"                                 | Used to share a DataReader between multiple processes


### Default QoS values

|QoS                    | Attribute                 | Value|
|-----------------------|---------------------------|------|
|\ref DCPS_QoS_UserData "USER_DATA"                 | value.length              | 0|
|\ref DCPS_QoS_Durability "DURABILITY"              | kind                      | VOLATILE|
|\ref DCPS_QoS_Deadline "DEADLINE"                  | period                    | DURATION_INFINITE|
|\ref DCPS_QoS_LatencyBudget "LATENCY_BUDGET"       | duration                  | 0|
|\ref DCPS_QoS_Liveliness "LIVELINESS"              | kind \n  lease_duration   | AUTOMATIC \n DURATION_INFINITE|
|\ref DCPS_QoS_Ownership "OWNERSHIP"                | kind                      | SHARED|
|\ref DCPS_QoS_TimeBasedFilter "TIME_BASED_FILTER"  | minimum_separation        | 0|
|\ref DCPS_QoS_Reliability "RELIABILITY"            | kind \n  max_blocking_time \n synchronous | BEST_EFFORT \n 100 ms \n FALSE|
|\ref DCPS_QoS_DestinationOrder "DESTINATION_ORDER" | kind                      | BY_RECEPTION_TIMESTAMP|
|\ref DCPS_QoS_History "HISTORY"                    | kind \n depth             | KEEP_LAST \n 1|
|\ref DCPS_QoS_ResourceLimits "RESOURCE_LIMITS"     | max_samples \n max_instances \n max_samples_per_instance  | LENGTH_UNLIMITED \n LENGTH_UNLIMITED \n LENGTH_UNLIMITED|
|\ref DCPS_QoS_ReaderDataLifecycle "READER_DATA_LIFECYCLE"  | autopurge_nowriter_samples_delay \n autopurge_disposed_samples_delay \n autopurge_dispose_all \n enable_invalid_samples \n invalid_sample_visibility.kind | DURATION_INFINITE \n DURATION_INFINITE \n FALSE \n TRUE \n MINIMUM_INVALID_SAMPLES|
|\ref DCPS_QoS_SubscriptionKey "SUBSCRIPTION_KEYS"  | use_key_list \n key_list.length | FALSE \n  0|
|\ref DCPS_QoS_ReaderLifespan "READER_LIFESPAN"     | use_lifespan \n duration  | FALSE \n DURATION_INFINITE |
|\ref DCPS_QoS_Share "SHARE"                        | name \n enable            | NULL \n FALSE|

### Related Status Conditions

Status   | Brief
---------|---------
\ref DCPS_Status_SampleRejected "SAMPLE_REJECTED"                       | A received sample has been rejected
\ref DCPS_Status_LivelinessChanged "LIVELINESS_CHANGED"                 | The liveliness of a DataWriter has changed
\ref DCPS_Status_RequestedDeadlineMissed "REQUESTED_DEADLINE_MISSED"    | A deadline was not met
\ref DCPS_Status_RequestedIncompatibleQoS "REQUESTED_INCOMPATIBLE_QOS"  | A QoS policy was not compatible with the offering
DATA_AVAILABLE                                                          | New information available
\ref DCPS_Status_SampleLost "SAMPLE_LOST"                               | A sample has been lost
\ref DCPS_Status_SubscriptionMatched "SUBSCRIPTION_MATCHED"             | Found matching DataWriter with compatible QoS and Topic


### Related Listeners
Listener | Brief
---------|---------
\ref DCPS_Status_SampleRejected "on_sample_rejected()"                       | A received sample has been rejected
\ref DCPS_Status_LivelinessChanged "on_liveliness_changed()"                 | The liveliness of a DataWriter has changed
\ref DCPS_Status_RequestedDeadlineMissed "on_requested_deadline_missed()"    | A deadline was not met
\ref DCPS_Status_RequestedIncompatibleQoS "on_requested_incompatible_qos()"  | A QoS policy was not compatible with the offering
on_data_available()                                                          | New information available
\ref DCPS_Status_SampleLost "on_sample_lost()"                               | A sample has been lost
\ref DCPS_Status_SubscriptionMatched "on_subscription_match()"               | Found matching DataWriter with compatible QoS and Topic
