import sys

from setuptools import find_packages
from setuptools import setup


install_requires = [
    'setuptools',
]
if sys.version_info < (3, 4):
    install_requires.append('trollius')
package_excludes = ['tests*', 'docs*']
if sys.version_info < (3, ):
    # On non-Python3 installs, avoid installing the asyncio files
    # which contain Python3 specific syntax.
    package_excludes.append(
        'osrf_pycommon.process_utils.async_execute_process_asyncio'
    )
packages = find_packages(exclude=package_excludes)

package_name = 'osrf_pycommon'

setup(
    name=package_name,
    version='0.1.8',
    packages=packages,
    data_files=[
        ('share/' + package_name, ['package.xml']),
    ],
    install_requires=install_requires,
    zip_safe=True,
    author='William Woodall',
    author_email='william@osrfoundation.org',
    maintainer='William Woodall',
    maintainer_email='william@osrfoundation.org',
    url='http://osrf-pycommon.readthedocs.org/',
    keywords=['osrf', 'utilities'],
    classifiers=[
        'Intended Audience :: Developers',
        'License :: OSI Approved :: Apache Software License',
        'Programming Language :: Python',
    ],
    description="Commonly needed Python modules, "
                "used by Python software developed at OSRF",
    license='Apache 2.0',
    test_suite='tests',
)
