/*
 * Decompiled with CFR 0.152.
 */
package com.rivescript;

import com.rivescript.Client;
import com.rivescript.ClientManager;
import com.rivescript.ObjectHandler;
import com.rivescript.Topic;
import com.rivescript.TopicManager;
import com.rivescript.Trigger;
import com.rivescript.Util;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RiveScript {
    private boolean debug = false;
    private int depth = 50;
    private String error = "";
    private static Random rand = new Random();
    public static final double VERSION = 0.05;
    private static final double RS_VERSION = 2.0;
    private static final String CMD_DEFINE = "!";
    private static final String CMD_TRIGGER = "+";
    private static final String CMD_PREVIOUS = "%";
    private static final String CMD_REPLY = "-";
    private static final String CMD_CONTINUE = "^";
    private static final String CMD_REDIRECT = "@";
    private static final String CMD_CONDITION = "*";
    private static final String CMD_LABEL = ">";
    private static final String CMD_ENDLABEL = "<";
    private TopicManager topics = new TopicManager();
    private ClientManager clients = new ClientManager();
    private HashMap<String, ObjectHandler> handlers = new HashMap();
    private HashMap<String, String> objects = new HashMap();
    private Vector<String> vTopics = new Vector();
    private HashMap<String, String> globals = new HashMap();
    private HashMap<String, String> vars = new HashMap();
    private HashMap<String, Vector<String>> arrays = new HashMap();
    private HashMap<String, String> subs = new HashMap();
    private String[] subs_s = null;
    private HashMap<String, String> person = new HashMap();
    private String[] person_s = null;

    public RiveScript(boolean debug) {
        this.debug = debug;
        Topic.setDebug(this.debug);
    }

    public RiveScript() {
        this(false);
    }

    public String error() {
        return this.error;
    }

    protected boolean error(String message) {
        this.error = message;
        return false;
    }

    public boolean loadDirectory(String path, String[] exts) {
        this.say("Load directory: " + path);
        File dh = new File(path);
        for (int i = 0; i < exts.length; ++i) {
            this.say("Searching for files of type: " + exts[i]);
            final String type = exts[i];
            String[] files = dh.list(new FilenameFilter(){

                @Override
                public boolean accept(File d, String name) {
                    return name.endsWith(type);
                }
            });
            if (files == null) {
                return this.error("Couldn't read any files from directory " + path);
            }
            for (int j = 0; j < files.length; ++j) {
                this.loadFile(path + "/" + files[j]);
            }
        }
        return true;
    }

    public boolean loadDirectory(String path) {
        String[] exts = new String[]{".rive", ".rs"};
        return this.loadDirectory(path, exts);
    }

    public boolean loadFile(String file) {
        this.say("Load file: " + file);
        File fh = new File(file);
        if (!fh.exists()) {
            return this.error(file + ": file not found.");
        }
        if (!fh.isFile()) {
            return this.error(file + ": not a regular file.");
        }
        if (!fh.canRead()) {
            return this.error(file + ": can't read from file.");
        }
        Vector<String> lines = new Vector<String>();
        try {
            String line;
            FileInputStream fis = new FileInputStream(fh);
            DataInputStream dis = new DataInputStream(fis);
            BufferedReader br = new BufferedReader(new InputStreamReader(dis));
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            dis.close();
        }
        catch (FileNotFoundException e) {
            return this.error(file + ": file not found exception.");
        }
        catch (IOException e) {
            this.trace(e);
            return this.error(file + ": IOException while reading.");
        }
        String[] code = Util.Sv2s(lines);
        return this.parse(file, code);
    }

    public boolean stream(String code) {
        String[] lines = code.split("\n");
        return this.parse("(streamed)", lines);
    }

    public boolean stream(String[] code) {
        return this.parse("(streamed)", code);
    }

    public void setHandler(String name, ObjectHandler handler) {
        this.handlers.put(name, handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setGlobal(String name, String value) {
        boolean delete = false;
        if (value == null || value == "<undef>") {
            delete = true;
        }
        if (name.equals("debug")) {
            if (value.equals("true") || value.equals("1") || value.equals("yes")) {
                this.debug = true;
            } else {
                if (!value.equals("false") && !value.equals("0") && !value.equals("no") && !delete) return this.error("Global variable \"debug\" needs a boolean value");
                this.debug = false;
            }
        } else if (name.equals("depth")) {
            try {
                this.depth = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return this.error("Global variable \"depth\" needs an integer value");
            }
        }
        if (delete) {
            this.globals.remove(name);
            return true;
        } else {
            this.globals.put(name, value);
        }
        return true;
    }

    public boolean setVariable(String name, String value) {
        if (value == null || value == "<undef>") {
            this.vars.remove(name);
        } else {
            this.vars.put(name, value);
        }
        return true;
    }

    public boolean setSubstitution(String pattern, String output) {
        if (output == null || output == "<undef>") {
            this.subs.remove(pattern);
        } else {
            this.subs.put(pattern, output);
        }
        return true;
    }

    public boolean setPersonSubstitution(String pattern, String output) {
        if (output == null || output == "<undef>") {
            this.person.remove(pattern);
        } else {
            this.person.put(pattern, output);
        }
        return true;
    }

    public boolean setUservar(String user, String name, String value) {
        if (value == null || value == "<undef>") {
            this.clients.client(user).delete(name);
        } else {
            this.clients.client(user).set(name, value);
        }
        return true;
    }

    public boolean setUservars(String user, HashMap<String, String> data) {
        this.clients.client(user).setData(data);
        return true;
    }

    public String[] getUsers() {
        return this.clients.listClients();
    }

    public HashMap<String, String> getUservars(String user) {
        if (this.clients.clientExists(user)) {
            return this.clients.client(user).getData();
        }
        return null;
    }

    public String getUservar(String user, String name) {
        if (this.clients.clientExists(user)) {
            return this.clients.client(user).get(name);
        }
        return null;
    }

    protected boolean parse(String filename, String[] code) {
        String topic = "random";
        int lineno = 0;
        boolean comment = false;
        boolean inobj = false;
        String objName = "";
        String objLang = "";
        Vector<String> objBuff = null;
        String onTrig = "";
        String lastcmd = "";
        String isThat = "";
        HashMap<String, String> local_options = new HashMap<String, String>();
        local_options.put("concat", "none");
        for (int i = 0; i < code.length; ++i) {
            ++lineno;
            String line = code[i];
            this.say("Line: " + line);
            line = line.trim();
            if (inobj) {
                if (line.startsWith("<object") || line.startsWith("< object")) {
                    if (this.handlers.containsKey(objLang)) {
                        this.handlers.get(objLang).onLoad(objName, Util.Sv2s(objBuff));
                        this.objects.put(objName, objLang);
                    }
                    objName = "";
                    objLang = "";
                    objBuff = null;
                    inobj = false;
                    continue;
                }
                objBuff.add(line);
                continue;
            }
            if (line.startsWith("/*")) {
                if (line.indexOf("*/") > -1) continue;
                comment = true;
            } else {
                if (line.startsWith("/")) continue;
                if (line.indexOf("*/") > -1) {
                    comment = false;
                    continue;
                }
            }
            if (comment || line.length() < 2) continue;
            String cmd = line.substring(0, 1);
            line = line.substring(1).trim();
            this.say("\tCmd: " + cmd);
            if (line.indexOf(" // ") > -1) {
                String[] split = line.split(" // ");
                line = split[0];
            }
            if (cmd.equals(CMD_TRIGGER)) {
                isThat = "";
            }
            for (int j = i + 1; j < code.length; ++j) {
                String peek = code[j].trim();
                if (peek.length() == 0) continue;
                String peekCmd = peek.substring(0, 1);
                if ((peek = peek.substring(1).trim()).length() <= 0) continue;
                if (!peekCmd.equals(CMD_CONTINUE) && !peekCmd.equals(CMD_PREVIOUS)) break;
                if (cmd.equals(CMD_TRIGGER)) {
                    if (peekCmd.equals(CMD_PREVIOUS)) {
                        isThat = peek;
                        break;
                    }
                    isThat = "";
                }
                if (cmd.equals(CMD_DEFINE) && peekCmd.equals(CMD_CONTINUE)) {
                    line = line + "<crlf>" + peek;
                }
                if (cmd.equals(CMD_CONTINUE) || cmd.equals(CMD_PREVIOUS) || cmd.equals(CMD_DEFINE)) continue;
                if (!peekCmd.equals(CMD_CONTINUE)) break;
                String concat = "";
                if (((String)local_options.get("concat")).equals("space")) {
                    concat = " ";
                } else if (((String)local_options.get("concat")).equals("newline")) {
                    concat = "\n";
                }
                line = line + concat + peek;
            }
            if (cmd.equals(CMD_DEFINE)) {
                this.say("\t! DEFINE");
                String[] whatis = line.split("\\s*=\\s*", 2);
                String[] left = whatis[0].split("\\s+", 2);
                String type = left[0];
                String var = "";
                String value = "";
                boolean delete = false;
                if (left.length == 2) {
                    var = left[1].trim().toLowerCase();
                }
                if (whatis.length == 2) {
                    value = whatis[1].trim();
                }
                if (!type.equals("array")) {
                    value = value.replaceAll("<crlf>", "");
                }
                if (type.equals("version")) {
                    this.say("\tUsing RiveScript version " + value);
                    double version = 0.0;
                    try {
                        version = Double.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        this.cry("RiveScript version \"" + value + "\" not a valid floating number", filename, lineno);
                        continue;
                    }
                    if (!(version > 2.0)) continue;
                    this.cry("We can't parse RiveScript v" + value + " documents", filename, lineno);
                    return false;
                }
                if (var.equals("")) {
                    this.cry("Missing a " + type + " variable name", filename, lineno);
                    continue;
                }
                if (value.equals("")) {
                    this.cry("Missing a " + type + " value", filename, lineno);
                    continue;
                }
                if (value.equals("<undef>")) {
                    delete = true;
                }
                if (type.equals("local")) {
                    this.say("\tSet local parser option " + var + " = " + value);
                    local_options.put(var, value);
                    continue;
                }
                if (type.equals("global")) {
                    this.say("\tSet global " + var + " = " + value);
                    this.setGlobal(var, value);
                    continue;
                }
                if (type.equals("var")) {
                    this.say("\tSet bot variable " + var + " = " + value);
                    this.setVariable(var, value);
                    continue;
                }
                if (type.equals("array")) {
                    this.say("\tSet array " + var);
                    if (delete) {
                        this.arrays.remove(var);
                        continue;
                    }
                    String[] parts = value.split("<crlf>");
                    Vector<String> items = new Vector<String>();
                    for (int a = 0; a < parts.length; ++a) {
                        String[] pieces = parts[a].indexOf("|") > -1 ? parts[a].split("\\|") : parts[a].split("\\s+");
                        for (int b = 0; b < pieces.length; ++b) {
                            items.add(pieces[b]);
                        }
                    }
                    this.arrays.put(var, items);
                    continue;
                }
                if (type.equals("sub")) {
                    this.say("\tSubstitution " + var + " => " + value);
                    this.setSubstitution(var, value);
                    continue;
                }
                if (type.equals("person")) {
                    this.say("\tPerson substitution " + var + " => " + value);
                    this.setPersonSubstitution(var, value);
                    continue;
                }
                this.cry("Unknown definition type \"" + type + "\"", filename, lineno);
                continue;
            }
            if (cmd.equals(CMD_LABEL)) {
                this.say("\t> LABEL");
                String[] label = line.split("\\s+");
                String type = "";
                String name = "";
                if (label.length >= 1) {
                    type = label[0].trim().toLowerCase();
                }
                if (label.length >= 2) {
                    name = label[1].trim();
                }
                if (type.equals("begin")) {
                    this.say("\tFound the BEGIN Statement.");
                    type = "topic";
                    name = "__begin__";
                }
                if (type.equals("topic")) {
                    this.say("\tSet topic to " + name);
                    onTrig = "";
                    topic = name;
                    if (label.length >= 3) {
                        boolean mode_includes = true;
                        int mode_inherits = 2;
                        int mode = 0;
                        for (int a = 2; a < label.length; ++a) {
                            if (label[a].toLowerCase().equals("includes")) {
                                mode = 1;
                                continue;
                            }
                            if (label[a].toLowerCase().equals("inherits")) {
                                mode = 2;
                                continue;
                            }
                            if (mode <= 0) continue;
                            if (mode == 1) {
                                this.topics.topic(topic).includes(label[a]);
                                continue;
                            }
                            if (mode != 2) continue;
                            this.topics.topic(topic).inherits(label[a]);
                        }
                    }
                }
                if (!type.equals("object")) continue;
                String lang = "";
                if (label.length >= 3) {
                    lang = label[2].toLowerCase();
                }
                onTrig = "";
                if (lang.length() == 0) {
                    this.cry("Trying to parse unknown programming language (assuming it's JavaScript)", filename, lineno);
                    lang = "javascript";
                }
                if (!this.handlers.containsKey(lang)) {
                    this.say("We can't handle " + lang + " object code!");
                    continue;
                }
                objName = name;
                objLang = lang;
                objBuff = new Vector<String>();
                inobj = true;
                continue;
            }
            if (cmd.equals(CMD_ENDLABEL)) {
                this.say("\t< ENDLABEL");
                String type = line.trim().toLowerCase();
                if (type.equals("begin") || type.equals("topic")) {
                    this.say("\t\tEnd topic label.");
                    topic = "random";
                    continue;
                }
                if (type.equals("object")) {
                    this.say("\t\tEnd object label.");
                    inobj = false;
                    continue;
                }
                this.cry("Unknown end topic type \"" + type + "\"", filename, lineno);
                continue;
            }
            if (cmd.equals(CMD_TRIGGER)) {
                this.say("\t+ TRIGGER: " + line);
                if (isThat.length() > 0) {
                    onTrig = line + "{previous}" + isThat;
                    this.topics.topic(topic).trigger(line).hasPrevious(true);
                    this.topics.topic(topic).addPrevious(line, isThat);
                    continue;
                }
                onTrig = line;
                continue;
            }
            if (cmd.equals(CMD_REPLY)) {
                this.say("\t- REPLY: " + line);
                if (onTrig.length() == 0) {
                    this.cry("Reply found before trigger", filename, lineno);
                    continue;
                }
                this.topics.topic(topic).trigger(onTrig).addReply(line);
                continue;
            }
            if (cmd.equals(CMD_PREVIOUS) || cmd.equals(CMD_CONTINUE)) continue;
            if (cmd.equals(CMD_REDIRECT)) {
                this.say("\t@ REDIRECT: " + line);
                if (onTrig.length() == 0) {
                    this.cry("Redirect found before trigger", filename, lineno);
                    continue;
                }
                this.topics.topic(topic).trigger(onTrig).addRedirect(line);
                continue;
            }
            if (cmd.equals(CMD_CONDITION)) {
                this.say("\t* CONDITION: " + line);
                if (onTrig.length() == 0) {
                    this.cry("Redirect found before trigger", filename, lineno);
                    continue;
                }
                this.topics.topic(topic).trigger(onTrig).addCondition(line);
                continue;
            }
            this.cry("Unrecognized command \"" + cmd + "\"", filename, lineno);
        }
        return true;
    }

    public void sortReplies() {
        String[] topics = this.topics.listTopics();
        this.say("There are " + topics.length + " topics to sort replies for.");
        this.topics.sortReplies();
        this.subs_s = Util.sortByLength(Util.SSh2s(this.subs));
        this.person_s = Util.sortByLength(Util.SSh2s(this.person));
    }

    public String reply(String username, String message) {
        this.say("Get reply to [" + username + "] " + message);
        message = this.formatMessage(message);
        String reply = "";
        if (this.topics.exists("__begin__")) {
            String begin = this.reply(username, "request", true, 0);
            if (begin.indexOf("{ok}") > -1) {
                reply = this.reply(username, message, false, 0);
                reply = begin = begin.replaceAll("\\{ok\\}", reply);
            }
            reply = this.processTags(username, this.clients.client(username), message, reply, new Vector<String>(), new Vector<String>(), 0);
        } else {
            reply = this.reply(username, message, false, 0);
        }
        this.clients.client(username).addInput(message);
        this.clients.client(username).addReply(reply);
        return reply;
    }

    private String reply(String user, String message, boolean begin, int step) {
        String topic = "random";
        Vector<String> stars = new Vector<String>();
        Vector<String> botstars = new Vector<String>();
        String reply = "";
        Client profile = this.clients.client(user);
        topic = profile.get("topic");
        if (!this.topics.exists(topic)) {
            this.cry("User " + user + " was in a missing topic named \"" + topic + "\"!");
            topic = "random";
            profile.set("topic", "random");
        }
        if (step > this.depth) {
            reply = "ERR: Deep Recursion Detected!";
            this.cry(reply);
            return reply;
        }
        if (begin) {
            topic = "__begin__";
        }
        Trigger matched = null;
        boolean foundMatch = false;
        String matchedTrigger = "";
        if (step == 0) {
            this.say("Looking for a %Previous");
            String[] allTopics = new String[]{topic};
            allTopics = this.topics.getTopicTree(topic, 0);
            for (int i = 0; i < allTopics.length; ++i) {
                this.say("Seeing if " + allTopics[i] + " has a %Previous");
                if (!this.topics.topic(allTopics[i]).hasPrevious()) continue;
                this.say("Topic " + allTopics[i] + " has at least one %Previous");
                String[] previous = this.topics.topic(allTopics[i]).listPrevious();
                block3: for (int j = 0; j < previous.length; ++j) {
                    this.say("Candidate: " + previous[j]);
                    String lastReply = this.formatMessage(profile.getReply(1));
                    String regexp = this.triggerRegexp(user, profile, previous[j]);
                    this.say("Compare " + lastReply + " <=> " + previous[j] + " (" + regexp + ")");
                    Pattern re = Pattern.compile(CMD_CONTINUE + regexp + "$");
                    Matcher m = re.matcher(lastReply);
                    while (m.find()) {
                        this.say("OMFG the lastReply matches!");
                        for (int s = 1; s <= m.groupCount(); ++s) {
                            this.say("Add botstar: " + m.group(s));
                            botstars.add(m.group(s));
                        }
                        String[] candidates = this.topics.topic(allTopics[i]).listPreviousTriggers(previous[j]);
                        for (int k = 0; k < candidates.length; ++k) {
                            this.say("Does the user's message match " + candidates[k] + "?");
                            String humanside = this.triggerRegexp(user, profile, candidates[k]);
                            this.say("Compare " + message + " <=> " + candidates[k] + " (" + humanside + ")");
                            Pattern reH = Pattern.compile(CMD_CONTINUE + humanside + "$");
                            Matcher mH = reH.matcher(message);
                            if (mH.find()) {
                                this.say("It's a match!!!");
                                String realTrigger = candidates[k] + "{previous}" + previous[j];
                                if (this.topics.topic(allTopics[i]).triggerExists(realTrigger)) {
                                    for (int s = 1; s <= mH.groupCount(); ++s) {
                                        this.say("Add star: " + mH.group(s));
                                        stars.add(mH.group(s));
                                    }
                                    foundMatch = true;
                                    matchedTrigger = candidates[k];
                                    matched = this.topics.topic(allTopics[i]).trigger(realTrigger);
                                }
                            }
                            if (foundMatch) break;
                        }
                        if (!foundMatch) continue;
                        continue block3;
                    }
                }
            }
        }
        if (!foundMatch) {
            String[] triggers = this.topics.topic(topic).listTriggers();
            for (int a = 0; a < triggers.length; ++a) {
                String trigger = triggers[a];
                String regexp = this.triggerRegexp(user, profile, trigger);
                this.say("Try to match \"" + message + "\" against \"" + trigger + "\" (" + regexp + ")");
                Pattern re = Pattern.compile(CMD_CONTINUE + regexp + "$");
                Matcher m = re.matcher(message);
                if (!m.find()) continue;
                this.say("The trigger matches! Star count: " + m.groupCount());
                int starcount = m.groupCount();
                for (int s = 1; s <= starcount; ++s) {
                    this.say("Add star: " + m.group(s));
                    stars.add(m.group(s));
                }
                if (this.topics.topic(topic).triggerExists(trigger)) {
                    matched = this.topics.topic(topic).trigger(trigger);
                } else {
                    this.say("Trigger doesn't exist under this topic, trying to find it!");
                    matched = this.topics.findTriggerByInheritance(topic, trigger, 0);
                }
                foundMatch = true;
                matchedTrigger = trigger;
                break;
            }
        }
        profile.set("__lastmatch__", matchedTrigger);
        if (foundMatch) {
            this.say("They were successfully matched to a trigger!");
            for (int n = 0; n < 1; ++n) {
                int i;
                if (matched == null) {
                    this.cry("Unknown error: they matched trigger " + matchedTrigger + ", but it doesn't exist?");
                    foundMatch = false;
                    break;
                }
                Trigger trigger = matched;
                this.say("The trigger matched belongs to topic " + trigger.topic());
                String[] conditions = trigger.listConditions();
                if (conditions.length > 0) {
                    this.say("This trigger has some conditions!");
                    boolean truth = false;
                    for (int c = 0; c < conditions.length; ++c) {
                        String[] halves = conditions[c].split("\\s*=>\\s*");
                        String condition = halves[0].trim();
                        String potreply = halves[1].trim();
                        Pattern reCond = Pattern.compile("^(.+?)\\s+(==|eq|\\!=|ne|<>|<|<=|>|>=)\\s+(.+?)$");
                        Matcher mCond = reCond.matcher(condition);
                        while (mCond.find()) {
                            String left = mCond.group(1).trim();
                            String eq = mCond.group(2).trim();
                            String right = mCond.group(3).trim();
                            left = this.processTags(user, profile, message, left, stars, botstars, step + 1);
                            right = this.processTags(user, profile, message, right, stars, botstars, step + 1);
                            this.say("Compare: " + left + " " + eq + " " + right);
                            if (left.length() == 0) {
                                left = "undefined";
                            }
                            if (right.length() == 0) {
                                right = "undefined";
                            }
                            if (eq.equals("eq") || eq.equals("ne") || eq.equals("==") || eq.equals("!=") || eq.equals("<>")) {
                                if ((eq.equals("eq") || eq.equals("==")) && left.equals(right)) {
                                    truth = true;
                                    break;
                                }
                                if ((eq.equals("ne") || eq.equals("!=") || eq.equals("<>")) && !left.equals(right)) {
                                    truth = true;
                                    break;
                                }
                            }
                            int lt = 0;
                            int rt = 0;
                            try {
                                lt = Integer.parseInt(left);
                                rt = Integer.parseInt(right);
                            }
                            catch (NumberFormatException e) {
                                break;
                            }
                            if (eq.equals("==") || eq.equals("!=") || eq.equals("<>")) {
                                if (eq.equals("==") && lt == rt) {
                                    truth = true;
                                    break;
                                }
                                if (!eq.equals("!=") && !eq.equals("<>") || lt == rt) continue;
                                truth = true;
                                break;
                            }
                            if (eq.equals(CMD_ENDLABEL) && lt < rt) {
                                truth = true;
                                break;
                            }
                            if (eq.equals("<=") && lt <= rt) {
                                truth = true;
                                break;
                            }
                            if (eq.equals(CMD_LABEL) && lt > rt) {
                                truth = true;
                                break;
                            }
                            if (!eq.equals(">=") || lt < rt) continue;
                            truth = true;
                            break;
                        }
                        if (!truth) continue;
                        reply = potreply;
                        break;
                    }
                }
                if (reply.length() > 0) break;
                String[] redirects = trigger.listRedirects();
                String[] replies = trigger.listReplies();
                Vector<Integer> bucket = new Vector<Integer>();
                Pattern reWeight = Pattern.compile("\\{weight=(\\d+?)\\}");
                for (i = 0; i < redirects.length; ++i) {
                    if (redirects[i].indexOf("{weight=") > -1) {
                        Matcher mWeight = reWeight.matcher(redirects[i]);
                        if (!mWeight.find()) continue;
                        int weight = Integer.parseInt(mWeight.group(1));
                        if (weight > 1) {
                            for (int j = 0; j < weight; ++j) {
                                this.say("Trigger has a redirect (weight " + weight + "): " + redirects[i]);
                                bucket.add(i);
                            }
                            continue;
                        }
                        this.say("Trigger has a redirect (weight " + weight + "): " + redirects[i]);
                        bucket.add(i);
                        continue;
                    }
                    this.say("Trigger has a redirect: " + redirects[i]);
                    bucket.add(i);
                }
                for (i = 0; i < replies.length; ++i) {
                    if (replies[i].indexOf("{weight=") > -1) {
                        Matcher mWeight = reWeight.matcher(replies[i]);
                        if (!mWeight.find()) continue;
                        int weight = Integer.parseInt(mWeight.group(1));
                        if (weight > 1) {
                            for (int j = 0; j < weight; ++j) {
                                this.say("Trigger has a reply (weight " + weight + "): " + replies[i]);
                                bucket.add(redirects.length + i);
                            }
                            continue;
                        }
                        this.say("Trigger has a reply (weight " + weight + "): " + replies[i]);
                        bucket.add(redirects.length + i);
                        continue;
                    }
                    this.say("Trigger has a reply: " + replies[i]);
                    bucket.add(redirects.length + i);
                }
                int[] choices = Util.Iv2s(bucket);
                if (choices.length <= 0) continue;
                int choice = choices[rand.nextInt(choices.length)];
                this.say("Possible choices: " + choices.length + "; chosen: " + choice);
                if (choice < redirects.length) {
                    String redirect = redirects[choice].replaceAll("\\{weight=\\d+\\}", "");
                    this.say("Chosen a redirect to " + redirect + CMD_DEFINE);
                    reply = this.reply(user, redirect, begin, step + 1);
                    continue;
                }
                if ((choice -= redirects.length) >= replies.length) continue;
                this.say("Chosen a reply: " + replies[choice]);
                reply = replies[choice];
            }
        }
        if (!foundMatch) {
            reply = "ERR: No Reply Matched";
        } else if (reply.length() == 0) {
            reply = "ERR: No Reply Found";
        }
        this.say("Final reply: " + reply);
        if (begin) {
            String tag;
            if (reply.indexOf("<set") > -1) {
                Pattern reSet = Pattern.compile("<set (.+?)=(.+?)>");
                Matcher mSet = reSet.matcher(reply);
                while (mSet.find()) {
                    tag = mSet.group(0);
                    String var = mSet.group(1);
                    String value = mSet.group(2);
                    profile.set(var, value);
                    reply = reply.replace(tag, "");
                }
            }
            if (reply.indexOf("{topic=") > -1) {
                Pattern reTopic = Pattern.compile("\\{topic=(.+?)\\}");
                Matcher mTopic = reTopic.matcher(reply);
                while (mTopic.find()) {
                    tag = mTopic.group(0);
                    topic = mTopic.group(1);
                    this.say("Set user's topic to: " + topic);
                    profile.set("topic", topic);
                    reply = reply.replace(tag, "");
                }
            }
        } else {
            reply = this.processTags(user, profile, message, reply, stars, botstars, step);
        }
        return reply;
    }

    private String triggerRegexp(String user, Client profile, String trigger) {
        String text;
        String value;
        String var;
        String tag;
        String regexp = trigger.replaceAll("^\\*$", "<zerowidthstar>");
        regexp = regexp.replaceAll("\\*", "(.+?)");
        regexp = regexp.replaceAll("#", "(\\\\d+?)");
        regexp = regexp.replaceAll("_", "(\\\\w+?)");
        regexp = regexp.replaceAll("\\{weight=\\d+\\}", "");
        if ((regexp = regexp.replaceAll("<zerowidthstar>", "(.*?)")).indexOf("[") > -1) {
            Pattern reOpts = Pattern.compile("\\s*\\[(.+?)\\]\\s*");
            Matcher mOpts = reOpts.matcher(regexp);
            while (mOpts.find()) {
                String optional = mOpts.group(0);
                String contents = mOpts.group(1);
                String[] parts = contents.split("\\|");
                StringBuffer re = new StringBuffer();
                for (int i = 0; i < parts.length; ++i) {
                    re.append("\\s*" + parts[i] + "\\s*");
                    if (i >= parts.length - 1) continue;
                    re.append("|");
                }
                String pipes = re.toString();
                pipes = pipes.replaceAll("\\(.+?\\)", "(?:.+?)");
                pipes = pipes.replaceAll("\\(\\d+?\\)", "(?:\\\\d+?");
                pipes = pipes.replaceAll("\\(\\w+?\\)", "(?:\\\\w+?)");
                pipes = "(?:" + pipes + "|\\s*)";
                regexp = regexp.replace(optional, pipes);
            }
        }
        if ((regexp = regexp.replaceAll("\\\\w", "[a-z ]")).indexOf(CMD_REDIRECT) > -1) {
            Pattern reArray = Pattern.compile("\\@(.+?)\\b");
            Matcher mArray = reArray.matcher(regexp);
            while (mArray.find()) {
                String array = mArray.group(0);
                String name = mArray.group(1);
                if (this.arrays.containsKey(name)) {
                    String[] values = Util.Sv2s(this.arrays.get(name));
                    StringBuffer joined = new StringBuffer();
                    for (int i = 0; i < values.length; ++i) {
                        joined.append(values[i]);
                        if (i >= values.length - 1) continue;
                        joined.append("|");
                    }
                    String rep = "(?:" + joined.toString() + ")";
                    regexp = regexp.replace(array, rep);
                    continue;
                }
                regexp = regexp.replace(array, "");
            }
        }
        if (regexp.indexOf("<bot") > -1) {
            Pattern reBot = Pattern.compile("<bot (.+?)>");
            Matcher mBot = reBot.matcher(regexp);
            while (mBot.find()) {
                tag = mBot.group(0);
                var = mBot.group(1);
                value = this.vars.get(var).toLowerCase().replace("[^a-z0-9 ]+", "");
                if (this.vars.containsKey(var)) {
                    regexp = regexp.replace(tag, value);
                    continue;
                }
                regexp = regexp.replace(tag, "undefined");
            }
        }
        if (regexp.indexOf("<get") > -1) {
            Pattern reGet = Pattern.compile("<get (.+?)>");
            Matcher mGet = reGet.matcher(regexp);
            while (mGet.find()) {
                tag = mGet.group(0);
                var = mGet.group(1);
                value = profile.get(var).toLowerCase().replaceAll("[^a-z0-9 ]+", "");
                regexp = regexp.replace(tag, value);
            }
        }
        regexp = regexp.replaceAll("<input>", "<input1>");
        if ((regexp = regexp.replaceAll("<reply>", "<reply1>")).indexOf("<input") > -1) {
            Pattern reInput = Pattern.compile("<input([0-9])>");
            Matcher mInput = reInput.matcher(regexp);
            while (mInput.find()) {
                tag = mInput.group(0);
                int index = Integer.parseInt(mInput.group(1));
                text = profile.getInput(index).toLowerCase().replaceAll("[^a-z0-9 ]+", "");
                regexp = regexp.replace(tag, text);
            }
        }
        if (regexp.indexOf("<reply") > -1) {
            Pattern reReply = Pattern.compile("<reply([0-9])>");
            Matcher mReply = reReply.matcher(regexp);
            while (mReply.find()) {
                tag = mReply.group(0);
                int index = Integer.parseInt(mReply.group(1));
                text = profile.getReply(index).toLowerCase().replaceAll("[^a-z0-9 ]+", "");
                regexp = regexp.replace(tag, text);
            }
        }
        return regexp;
    }

    private String processTags(String user, Client profile, String message, String reply, Vector<String> vstars, Vector<String> vbotstars, int step) {
        String tag;
        Pattern reTag;
        String text;
        int index;
        String tag2;
        int i;
        vstars.add(0, "");
        vbotstars.add(0, "");
        if (vstars.size() == 1) {
            vstars.add("undefined");
        }
        if (vbotstars.size() == 1) {
            vbotstars.add("undefined");
        }
        String[] stars = Util.Sv2s(vstars);
        String[] botstars = Util.Sv2s(vbotstars);
        reply = reply.replaceAll("<person>", "{person}<star>{/person}");
        reply = reply.replaceAll("<@>", "{@<star>}");
        reply = reply.replaceAll("<formal>", "{formal}<star>{/formal}");
        reply = reply.replaceAll("<sentence>", "{sentence}<star>{/sentence}");
        reply = reply.replaceAll("<uppercase>", "{uppercase}<star>{/uppercase}");
        reply = reply.replaceAll("<lowercase>", "{lowercase}<star>{/lowercase}");
        reply = reply.replaceAll("\\{weight=\\d+\\}", "");
        reply = reply.replaceAll("<input>", "<input1>");
        reply = reply.replaceAll("<reply>", "<reply1>");
        reply = reply.replaceAll("<id>", user);
        reply = reply.replaceAll("\\\\s", " ");
        reply = reply.replaceAll("\\\\n", "\n");
        reply = reply.replaceAll("\\\\", "\\");
        reply = reply.replaceAll("\\#", "#");
        reply = reply.replaceAll("<star>", stars[1]);
        reply = reply.replaceAll("<botstar>", botstars[1]);
        for (i = 1; i < stars.length; ++i) {
            reply = reply.replaceAll("<star" + i + CMD_LABEL, stars[i]);
        }
        for (i = 1; i < botstars.length; ++i) {
            reply = reply.replaceAll("<botstar" + i + CMD_LABEL, botstars[i]);
        }
        if ((reply = reply.replaceAll("<(star|botstar)\\d+>", "")).indexOf("<input") > -1) {
            Pattern reInput = Pattern.compile("<input([0-9])>");
            Matcher mInput = reInput.matcher(reply);
            while (mInput.find()) {
                tag2 = mInput.group(0);
                index = Integer.parseInt(mInput.group(1));
                text = profile.getInput(index).toLowerCase().replaceAll("[^a-z0-9 ]+", "");
                reply = reply.replace(tag2, text);
            }
        }
        if (reply.indexOf("<reply") > -1) {
            Pattern reReply = Pattern.compile("<reply([0-9])>");
            Matcher mReply = reReply.matcher(reply);
            while (mReply.find()) {
                tag2 = mReply.group(0);
                index = Integer.parseInt(mReply.group(1));
                text = profile.getReply(index).toLowerCase().replaceAll("[^a-z0-9 ]+", "");
                reply = reply.replace(tag2, text);
            }
        }
        if (reply.indexOf("{random}") > -1) {
            Pattern reRandom = Pattern.compile("\\{random\\}(.+?)\\{\\/random\\}");
            Matcher mRandom = reRandom.matcher(reply);
            while (mRandom.find()) {
                tag2 = mRandom.group(0);
                String[] candidates = mRandom.group(1).split("\\|");
                String chosen = candidates[rand.nextInt(candidates.length)];
                reply = reply.replace(tag2, chosen);
            }
        }
        if (reply.indexOf("<bot") > -1) {
            Pattern reBot = Pattern.compile("<bot (.+?)>");
            Matcher mBot = reBot.matcher(reply);
            while (mBot.find()) {
                tag2 = mBot.group(0);
                String var = mBot.group(1);
                if (this.vars.containsKey(var)) {
                    reply = reply.replace(tag2, this.vars.get(var));
                    continue;
                }
                reply = reply.replace(tag2, "undefined");
            }
        }
        if (reply.indexOf("<env") > -1) {
            Pattern reEnv = Pattern.compile("<env (.+?)>");
            Matcher mEnv = reEnv.matcher(reply);
            while (mEnv.find()) {
                tag2 = mEnv.group(0);
                String var = mEnv.group(1);
                if (this.globals.containsKey(var)) {
                    reply = reply.replace(tag2, this.globals.get(var));
                    continue;
                }
                reply = reply.replace(tag2, "undefined");
            }
        }
        if (reply.indexOf("{!") > -1) {
            Pattern reStream = Pattern.compile("\\{\\!(.+?)\\}");
            Matcher mStream = reStream.matcher(reply);
            while (mStream.find()) {
                tag2 = mStream.group(0);
                String code = mStream.group(1);
                this.say("Stream new code in: " + code);
                this.stream(code);
                reply = reply.replace(tag2, "");
            }
        }
        if (reply.indexOf("{person}") > -1) {
            Pattern rePerson = Pattern.compile("\\{person\\}(.+?)\\{\\/person\\}");
            Matcher mPerson = rePerson.matcher(reply);
            while (mPerson.find()) {
                tag2 = mPerson.group(0);
                String text2 = mPerson.group(1);
                this.say("Run person substitutions: before: " + text2);
                text2 = Util.substitute(this.person_s, this.person, text2);
                this.say("After: " + text2);
                reply = reply.replace(tag2, text2);
            }
        }
        if (reply.indexOf("{formal}") > -1 || reply.indexOf("{sentence}") > -1 || reply.indexOf("{uppercase}") > -1 || reply.indexOf("{lowercase}") > -1) {
            String[] tags = new String[]{"formal", "sentence", "uppercase", "lowercase"};
            for (int i2 = 0; i2 < tags.length; ++i2) {
                reTag = Pattern.compile("\\{" + tags[i2] + "\\}(.+?)\\{\\/" + tags[i2] + "\\}");
                Matcher mTag = reTag.matcher(reply);
                while (mTag.find()) {
                    tag = mTag.group(0);
                    String text3 = mTag.group(1);
                    text3 = this.stringTransform(tags[i2], text3);
                    reply = reply.replace(tag, text3);
                }
            }
        }
        if (reply.indexOf("<set") > -1) {
            Pattern reSet = Pattern.compile("<set (.+?)=(.+?)>");
            Matcher mSet = reSet.matcher(reply);
            while (mSet.find()) {
                tag2 = mSet.group(0);
                String var = mSet.group(1);
                String value = mSet.group(2);
                profile.set(var, value);
                reply = reply.replace(tag2, "");
                this.say("Set user var " + var + "=" + value);
            }
        }
        if (reply.indexOf("<add") > -1 || reply.indexOf("<sub") > -1 || reply.indexOf("<mult") > -1 || reply.indexOf("<div") > -1) {
            String[] tags = new String[]{"add", "sub", "mult", "div"};
            for (int i3 = 0; i3 < tags.length; ++i3) {
                reTag = Pattern.compile(CMD_ENDLABEL + tags[i3] + " (.+?)=(.+?)>");
                Matcher mTag = reTag.matcher(reply);
                while (mTag.find()) {
                    tag = mTag.group(0);
                    String var = mTag.group(1);
                    String value = mTag.group(2);
                    String curvalue = profile.get(var);
                    int current = 0;
                    if (!curvalue.equals("undefined")) {
                        try {
                            current = Integer.parseInt(curvalue);
                        }
                        catch (NumberFormatException e) {
                            reply = reply.replace(tag, "[ERR: Can't \"" + tags[i3] + "\" non-numeric variable " + var + "]");
                            continue;
                        }
                    }
                    int modifier = 0;
                    try {
                        modifier = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        reply = reply.replace(tag, "[ERR: Can't \"" + tags[i3] + "\" non-numeric value " + value + "]");
                        continue;
                    }
                    if (tags[i3].equals("add")) {
                        current += modifier;
                    } else if (tags[i3].equals("sub")) {
                        current -= modifier;
                    } else if (tags[i3].equals("mult")) {
                        current *= modifier;
                    } else {
                        if (modifier == 0) {
                            reply = reply.replace(tag, "[ERR: Can't divide by zero!]");
                            continue;
                        }
                        current /= modifier;
                    }
                    profile.set(var, Integer.toString(current));
                    reply = reply.replace(tag, "");
                }
            }
        }
        if (reply.indexOf("<get") > -1) {
            Pattern reGet = Pattern.compile("<get (.+?)>");
            Matcher mGet = reGet.matcher(reply);
            while (mGet.find()) {
                tag2 = mGet.group(0);
                String var = mGet.group(1);
                reply = reply.replace(tag2, profile.get(var));
            }
        }
        if (reply.indexOf("{topic=") > -1) {
            Pattern reTopic = Pattern.compile("\\{topic=(.+?)\\}");
            Matcher mTopic = reTopic.matcher(reply);
            while (mTopic.find()) {
                tag2 = mTopic.group(0);
                String topic = mTopic.group(1);
                this.say("Set user's topic to: " + topic);
                profile.set("topic", topic);
                reply = reply.replace(tag2, "");
            }
        }
        if (reply.indexOf("{@") > -1) {
            Pattern reRed = Pattern.compile("\\{@(.+?)\\}");
            Matcher mRed = reRed.matcher(reply);
            while (mRed.find()) {
                tag2 = mRed.group(0);
                String target = mRed.group(1).trim();
                String subreply = this.reply(user, target, false, step + 1);
                reply = reply.replace(tag2, subreply);
            }
        }
        if (reply.indexOf("<call>") > -1) {
            Pattern reCall = Pattern.compile("<call>(.+?)<\\/call>");
            Matcher mCall = reCall.matcher(reply);
            while (mCall.find()) {
                tag2 = mCall.group(0);
                String data = mCall.group(1);
                String[] parts = data.split(" ");
                String name = parts[0];
                Vector<String> args = new Vector<String>();
                for (int i4 = 1; i4 < parts.length; ++i4) {
                    args.add(parts[i4]);
                }
                if (this.objects.containsKey(name)) {
                    String lang = this.objects.get(name);
                    String result = this.handlers.get(lang).onCall(name, user, Util.Sv2s(args));
                    reply = reply.replace(tag2, result);
                    continue;
                }
                reply = reply.replace(tag2, "[ERR: Object Not Found]");
            }
        }
        return reply;
    }

    private String stringTransform(String format, String text) {
        if (format.equals("uppercase")) {
            return text.toUpperCase();
        }
        if (format.equals("lowercase")) {
            return text.toLowerCase();
        }
        if (format.equals("formal")) {
            String[] words = text.split(" ");
            this.say("wc: " + words.length);
            for (int i = 0; i < words.length; ++i) {
                this.say("word: " + words[i]);
                String[] letters = words[i].split("");
                this.say("cc: " + letters.length);
                if (letters.length <= 1) continue;
                this.say("letter 1: " + letters[1]);
                letters[1] = letters[1].toUpperCase();
                this.say("new letter 1: " + letters[1]);
                words[i] = Util.join(letters, "");
                this.say("new word: " + words[i]);
            }
            return Util.join(words, " ");
        }
        if (format.equals("sentence")) {
            String[] letters = text.split("");
            if (letters.length > 1) {
                letters[1] = letters[1].toUpperCase();
            }
            return Util.join(letters, "");
        }
        return "[ERR: Unknown String Transform " + format + "]";
    }

    private String formatMessage(String message) {
        message = message.toLowerCase();
        message = Util.substitute(this.subs_s, this.subs, message);
        message = message.replaceAll("[^a-z0-9 ]", "");
        return message;
    }

    public void dumpSorted() {
        String[] topics = this.topics.listTopics();
        for (int t = 0; t < topics.length; ++t) {
            String topic = topics[t];
            String[] triggers = this.topics.topic(topic).listTriggers();
            this.println("Topic: " + topic);
            for (int i = 0; i < triggers.length; ++i) {
                this.println("       " + triggers[i]);
            }
        }
    }

    public void dumpTopics() {
        this.println("{");
        String[] topicList = this.topics.listTopics();
        for (int t = 0; t < topicList.length; ++t) {
            int i;
            String topic = topicList[t];
            String extra = "";
            String[] includes = this.topics.topic(topic).includes();
            String[] inherits = this.topics.topic(topic).inherits();
            if (includes.length > 0) {
                extra = "includes ";
                for (i = 0; i < includes.length; ++i) {
                    extra = extra + includes[i] + " ";
                }
            }
            if (inherits.length > 0) {
                extra = extra + "inherits ";
                for (i = 0; i < inherits.length; ++i) {
                    extra = extra + inherits[i] + " ";
                }
            }
            this.println("  '" + topic + "' " + extra + " => {");
            String[] trigList = this.topics.topic(topic).listTriggers();
            for (int i2 = 0; i2 < trigList.length; ++i2) {
                String[] red;
                String[] cond;
                String trig = trigList[i2];
                this.println("    '" + trig + "' => {");
                String[] reply = this.topics.topic(topic).trigger(trig).listReplies();
                if (reply.length > 0) {
                    this.println("      'reply' => [");
                    for (int r = 0; r < reply.length; ++r) {
                        this.println("        '" + reply[r] + "',");
                    }
                    this.println("      ],");
                }
                if ((cond = this.topics.topic(topic).trigger(trig).listConditions()).length > 0) {
                    this.println("      'condition' => [");
                    for (int r = 0; r < cond.length; ++r) {
                        this.println("        '" + cond[r] + "',");
                    }
                    this.println("      ],");
                }
                if ((red = this.topics.topic(topic).trigger(trig).listRedirects()).length > 0) {
                    this.println("      'redirect' => [");
                    for (int r = 0; r < red.length; ++r) {
                        this.println("        '" + red[r] + "',");
                    }
                    this.println("      ],");
                }
                this.println("    },");
            }
            this.println("  },");
        }
    }

    protected void println(String line) {
        System.out.println(line);
    }

    protected void say(String line) {
        if (this.debug) {
            System.out.println("[RS] " + line);
        }
    }

    protected void cry(String line) {
        System.out.println("<RS> " + line);
    }

    protected void cry(String text, String file, int line) {
        System.out.println("<RS> " + text + " at " + file + " line " + line + ".");
    }

    protected void trace(IOException e) {
        if (this.debug) {
            e.printStackTrace();
        }
    }
}

