/*
 * Decompiled with CFR 0.152.
 */
package com.rivescript;

import com.rivescript.Inheritance;
import com.rivescript.Trigger;
import com.rivescript.Util;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Topic {
    private static boolean debug = false;
    private HashMap<String, Trigger> triggers = new HashMap();
    private boolean hasPrevious = false;
    private HashMap<String, Vector<String>> previous = new HashMap();
    private Vector<String> includes = new Vector();
    private Vector<String> inherits = new Vector();
    private String[] sorted = null;
    String name = "";

    public Topic(String name) {
        this.name = name;
    }

    public static boolean setDebug(boolean debug) {
        return debug;
    }

    public Trigger trigger(String pattern) {
        if (!this.triggers.containsKey(pattern)) {
            Trigger newTrig = new Trigger(this.name, pattern);
            this.triggers.put(pattern, newTrig);
        }
        return this.triggers.get(pattern);
    }

    public boolean triggerExists(String trigger) {
        return this.triggers.containsKey(trigger);
    }

    public String[] listTriggers() {
        return this.listTriggers(false);
    }

    public String[] listTriggers(boolean raw) {
        if (raw) {
            Vector<String> trigs = new Vector<String>();
            Iterator<String> it = this.triggers.keySet().iterator();
            while (it.hasNext()) {
                String next = it.next().toString();
                this.say("RAW TRIGGER: " + next);
                trigs.add(next);
            }
            String[] result = new String[trigs.size()];
            int i = 0;
            Enumeration e = trigs.elements();
            while (e.hasMoreElements()) {
                result[i] = e.nextElement().toString();
                ++i;
            }
            return result;
        }
        if (this.sorted == null) {
            System.err.println("You called listTriggers() for topic " + this.name + " before its replies have been sorted!");
            return new String[0];
        }
        return this.sorted;
    }

    public void sortTriggers(String[] alltrigs) {
        int inherits;
        Vector<String> sorted = new Vector<String>();
        HashMap heritage = new HashMap();
        heritage.put(-1, new Vector());
        int highest = -1;
        Pattern reInherit = Pattern.compile("\\{inherits=(\\d+)\\}");
        for (int i = 0; i < alltrigs.length; ++i) {
            Matcher m;
            inherits = -1;
            if (alltrigs[i].indexOf("{inherits=") > -1 && (m = reInherit.matcher(alltrigs[i])).find() && (inherits = Integer.parseInt(m.group(1))) > highest) {
                highest = inherits;
            }
            alltrigs[i] = alltrigs[i].replaceAll("\\{inherits=\\d+\\}", "");
            if (!heritage.containsKey(inherits)) {
                heritage.put(inherits, new Vector());
            }
            ((Vector)heritage.get(inherits)).add(alltrigs[i]);
        }
        for (int h = -1; h <= highest; ++h) {
            if (!heritage.containsKey(h)) continue;
            inherits = h;
            this.say("Sorting triggers by heritage level " + inherits);
            String[] triggers = Util.Sv2s((Vector)heritage.get(inherits));
            HashMap<Integer, Vector<String>> prior = new HashMap<Integer, Vector<String>>();
            this.say("BEGIN sortTriggers in topic " + this.name);
            Pattern rePrior = Pattern.compile("\\{weight=(\\d+?)\\}");
            for (int i = 0; i < triggers.length; ++i) {
                int priority = 0;
                if (triggers[i].indexOf("{weight") > -1) {
                    Matcher m = rePrior.matcher(triggers[i]);
                    while (m.find()) {
                        priority = Integer.parseInt(m.group(1));
                    }
                }
                if (!prior.containsKey(priority)) {
                    prior.put(priority, new Vector());
                }
                prior.get(priority).add(triggers[i]);
            }
            int[] prior_sorted = Util.sortKeysDesc(prior);
            for (int p = 0; p < prior_sorted.length; ++p) {
                this.say("Sorting triggers w/ priority " + prior_sorted[p]);
                Vector<String> p_list = prior.get(prior_sorted[p]);
                int highest_inherits = inherits;
                Inheritance bucket = new Inheritance();
                Enumeration<String> e = p_list.elements();
                while (e.hasMoreElements()) {
                    String trigger = e.nextElement().toString();
                    String[] words = trigger.split("[ |\\*|\\#|\\_]");
                    int wc = 0;
                    for (int w = 0; w < words.length; ++w) {
                        if (words[w].length() <= 0) continue;
                        ++wc;
                    }
                    this.say("On trigger: " + trigger + " (it has " + wc + " words) - inherit level: " + inherits);
                    if (trigger.indexOf("_") > -1) {
                        if (wc > 0) {
                            bucket.addAlpha(wc, trigger);
                            continue;
                        }
                        bucket.addUnder(trigger);
                        continue;
                    }
                    if (trigger.indexOf("#") > -1) {
                        if (wc > 0) {
                            bucket.addNumber(wc, trigger);
                            continue;
                        }
                        bucket.addPound(trigger);
                        continue;
                    }
                    if (trigger.indexOf("*") > -1) {
                        if (wc > 0) {
                            bucket.addWild(wc, trigger);
                            continue;
                        }
                        bucket.addStar(trigger);
                        continue;
                    }
                    if (trigger.indexOf("[") > -1) {
                        bucket.addOption(wc, trigger);
                        continue;
                    }
                    bucket.addAtomic(wc, trigger);
                }
                this.say("Dumping sort bucket !");
                Vector<String> subsort = bucket.dump(new Vector<String>());
                Enumeration<String> e2 = subsort.elements();
                while (e2.hasMoreElements()) {
                    String next = e2.nextElement().toString();
                    this.say("ADD TO SORT: " + next);
                    sorted.add(next);
                }
            }
        }
        this.sorted = Util.Sv2s(sorted);
    }

    public void addPrevious(String pattern, String previous) {
        if (!this.previous.containsKey(previous)) {
            this.previous.put(previous, new Vector());
        }
        this.previous.get(previous).add(pattern);
    }

    public boolean hasPrevious() {
        return this.hasPrevious;
    }

    public String[] listPrevious() {
        Vector<String> vector = new Vector<String>();
        Iterator<String> sit = this.previous.keySet().iterator();
        while (sit.hasNext()) {
            vector.add(sit.next());
        }
        return Util.Sv2s(vector);
    }

    public String[] listPreviousTriggers(String previous) {
        if (this.previous.containsKey(previous)) {
            return Util.Sv2s(this.previous.get(previous));
        }
        return new String[0];
    }

    public void sortPrevious() {
        this.hasPrevious = false;
        HashMap prev2trig = new HashMap();
        String[] triggers = this.listTriggers(true);
        for (int i = 0; i < triggers.length; ++i) {
            String pattern = triggers[i];
            if (pattern.indexOf("{previous}") <= -1) continue;
            this.hasPrevious = true;
            String[] parts = pattern.split("\\{previous\\}", 2);
            String previous = parts[1];
            if (!prev2trig.containsKey(previous)) {
                prev2trig.put(previous, new Vector());
            }
            ((Vector)prev2trig.get(previous)).add(parts[0]);
        }
        this.previous = prev2trig;
    }

    public boolean previousExists(String previous) {
        return this.previous.containsKey(previous);
    }

    public String[] listPrevious(String previous) {
        if (this.previous.containsKey(previous)) {
            return Util.Sv2s(this.previous.get(previous));
        }
        return new String[0];
    }

    public void includes(String topic) {
        this.includes.add(topic);
    }

    public void inherits(String topic) {
        this.inherits.add(topic);
    }

    public String[] includes() {
        return Util.Sv2s(this.includes);
    }

    public String[] inherits() {
        return Util.Sv2s(this.inherits);
    }

    private void say(String line) {
        if (debug) {
            System.out.println("[RS::Topic] " + line);
        }
    }
}

