/*
 * Decompiled with CFR 0.152.
 */
package com.rivescript;

import com.rivescript.Topic;
import com.rivescript.Trigger;
import com.rivescript.Util;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class TopicManager {
    private HashMap<String, Topic> topics = new HashMap();
    private Vector<String> vTopics = new Vector();

    public Topic topic(String topic) {
        if (!this.topics.containsKey(topic)) {
            Topic newTopic = new Topic(topic);
            this.topics.put(topic, newTopic);
            this.vTopics.add(topic);
        }
        return this.topics.get(topic);
    }

    public boolean exists(String topic) {
        return this.topics.containsKey(topic);
    }

    public String[] listTopics() {
        String[] result = new String[this.vTopics.size()];
        int i = 0;
        Enumeration<String> e = this.vTopics.elements();
        while (e.hasMoreElements()) {
            result[i] = e.nextElement().toString();
            ++i;
        }
        return result;
    }

    public void sortReplies() {
        String[] topics = this.listTopics();
        for (int i = 0; i < topics.length; ++i) {
            String[] alltrig = this.topicTriggers(topics[i], 0, 0, false);
            this.topic(topics[i]).sortTriggers(alltrig);
            this.topic(topics[i]).sortPrevious();
        }
    }

    private String[] topicTriggers(String topic, int depth, int inheritance, boolean inherited) {
        String[] inherits;
        if (depth > 50) {
            System.err.println("Deep recursion while scanning topic inheritance (topic " + topic + " was involved)");
            return new String[0];
        }
        Vector<String> triggers = new Vector<String>();
        String[] includes = this.topic(topic).includes();
        if (includes.length > 0) {
            for (int i = 0; i < includes.length; ++i) {
                String[] recursive = this.topicTriggers(includes[i], depth + 1, inheritance, false);
                for (int j = 0; j < recursive.length; ++j) {
                    triggers.add(recursive[j]);
                }
            }
        }
        if ((inherits = this.topic(topic).inherits()).length > 0) {
            for (int i = 0; i < inherits.length; ++i) {
                String[] recursive = this.topicTriggers(inherits[i], depth + 1, inheritance + 1, true);
                for (int j = 0; j < recursive.length; ++j) {
                    triggers.add(recursive[j]);
                }
            }
        }
        String[] localTriggers = this.topic(topic).listTriggers(true);
        if (inherits.length > 0 || inherited) {
            for (int i = 0; i < localTriggers.length; ++i) {
                if (localTriggers[i].indexOf("{previous}") > -1) continue;
                triggers.add("{inherits=" + inheritance + "}" + localTriggers[i]);
            }
        } else {
            for (int i = 0; i < localTriggers.length; ++i) {
                if (localTriggers[i].indexOf("{previous}") > -1) continue;
                triggers.add(localTriggers[i]);
            }
        }
        return Util.Sv2s(triggers);
    }

    public Trigger findTriggerByInheritance(String topic, String pattern, int depth) {
        if (depth > 50) {
            System.err.println("Deep recursion while scanning topic inheritance (topic " + topic + " was involved)");
            return null;
        }
        String[] inherits = this.topic(topic).inherits();
        for (int i = 0; i < inherits.length; ++i) {
            if (this.topic(inherits[i]).triggerExists(pattern)) {
                return this.topic(inherits[i]).trigger(pattern);
            }
            Trigger match = this.findTriggerByInheritance(inherits[i], pattern, depth + 1);
            if (match == null) continue;
            return match;
        }
        String[] includes = this.topic(topic).includes();
        for (int i = 0; i < includes.length; ++i) {
            if (this.topic(includes[i]).triggerExists(pattern)) {
                return this.topic(includes[i]).trigger(pattern);
            }
            Trigger match = this.findTriggerByInheritance(includes[i], pattern, depth + 1);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public String[] getTopicTree(String topic, int depth) {
        if (depth >= 50) {
            System.err.println("Deep recursion while scanning topic inheritance (topic " + topic + " was involved)");
            return new String[0];
        }
        Vector<String> result = new Vector<String>();
        result.add(topic);
        String[] includes = this.topic(topic).includes();
        for (int i = 0; i < includes.length; ++i) {
            String[] children = this.getTopicTree(includes[i], depth + 1);
            for (int j = 0; j < children.length; ++j) {
                result.add(children[j]);
            }
        }
        String[] inherits = this.topic(topic).inherits();
        for (int i = 0; i < inherits.length; ++i) {
            String[] children = this.getTopicTree(includes[i], depth + 1);
            for (int j = 0; j < children.length; ++j) {
                result.add(children[j]);
            }
        }
        return Util.Sv2s(result);
    }
}

