/*
 * Decompiled with CFR 0.152.
 */
package com.rivescript.lang;

import com.rivescript.ObjectHandler;
import com.rivescript.RiveScript;
import com.rivescript.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.json.JSONException;
import org.json.JSONObject;

public class Perl
implements ObjectHandler {
    private String rsp4j;
    private RiveScript parent;
    private HashMap<String, String> codes = new HashMap();

    public Perl(RiveScript rivescript, String rsp4j) {
        this.parent = rivescript;
        this.rsp4j = rsp4j;
    }

    @Override
    public boolean onLoad(String name, String[] code) {
        this.codes.put(name, Util.join(code, "\n"));
        return true;
    }

    @Override
    public String onCall(String name, String user, String[] args) {
        try {
            JSONObject json = new JSONObject();
            json.put("id", user);
            json.put("message", Util.join(args, " "));
            json.put("code", this.codes.get(name));
            JSONObject vars = new JSONObject();
            HashMap<String, String> data = this.parent.getUservars(user);
            Iterator<String> it = data.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                vars.put(key, data.get(key));
            }
            json.put("vars", vars);
            String outgoing = json.toString();
            String incoming = "";
            try {
                String line;
                Process p = Runtime.getRuntime().exec(this.rsp4j + " --java");
                OutputStream stdIn = p.getOutputStream();
                BufferedReader stdOut = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                stdIn.write(outgoing.getBytes());
                stdIn.flush();
                stdIn.close();
                Vector<String> result = new Vector<String>();
                while ((line = stdOut.readLine()) != null) {
                    result.add(line);
                }
                incoming = Util.join(Util.Sv2s(result), "\n");
            }
            catch (IOException e) {
                System.err.println("IOException error in com.rivescript.lang.Perl: " + e.getMessage());
                return "[ERR: IOException: " + e.getMessage() + "]";
            }
            JSONObject reply = new JSONObject(incoming);
            if (reply.getString("status").equals("error")) {
                return "[ERR: " + reply.getString("message");
            }
            JSONObject newVars = reply.getJSONObject("vars");
            String[] keys = JSONObject.getNames(newVars);
            for (int i = 0; i < keys.length; ++i) {
                String value = newVars.getString(keys[i]);
                this.parent.setUservar(user, keys[i], value);
            }
            return reply.getString("reply");
        }
        catch (JSONException e) {
            System.err.println("JSONException in com.rivescript.lang.Perl: " + e.getMessage());
            return "[ERR: JSONException: " + e.getMessage() + "]";
        }
    }
}

