/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.extensions.Rating;
import com.google.gdata.data.youtube.EntryUtils;
import com.google.gdata.data.youtube.YouTubeNamespace;
import com.google.gdata.data.youtube.YtUsername;
import com.google.gdata.data.youtube.YtVideoId;
import com.google.gdata.util.Namespaces;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://gdata.youtube.com/schemas/2007#userEvent")
public class UserEventEntry
extends BaseEntry<UserEventEntry> {
    public static final String[] CATEGORIES = new String[]{"http://gdata.youtube.com/schemas/2007/userevents.cat"};

    public UserEventEntry() {
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#userEvent");
    }

    public Type getUserEventType() {
        for (Category category : this.getCategories()) {
            Type type;
            if (!"http://gdata.youtube.com/schemas/2007/userevents.cat".equals(category.getScheme()) || (type = Type.fromTerm(category.getTerm())) == null) continue;
            return type;
        }
        return null;
    }

    public void setEventType(Type type) {
        this.clearEventType();
        if (type != null) {
            this.getCategories().add(new Category("http://gdata.youtube.com/schemas/2007/userevents.cat", type.getTerm()));
        }
    }

    private void clearEventType() {
        Iterator categories = this.getCategories().iterator();
        while (categories.hasNext()) {
            Category category = (Category)categories.next();
            if (!"http://gdata.youtube.com/schemas/2007/userevents.cat".equals(category.getScheme())) continue;
            categories.remove();
        }
    }

    public String getVideoId() {
        YtVideoId videoId = (YtVideoId)this.getExtension(YtVideoId.class);
        return videoId == null ? null : videoId.getVideoId();
    }

    public void setVideoId(String videoId) {
        if (videoId == null) {
            this.removeExtension(YtVideoId.class);
        } else {
            this.setExtension((Extension)new YtVideoId(videoId));
        }
    }

    public String getUsername() {
        YtUsername username = (YtUsername)this.getExtension(YtUsername.class);
        return username == null ? null : username.getContent();
    }

    public void setUsername(String username) {
        if (username != null) {
            this.addExtension((Extension)new YtUsername(username));
        } else {
            this.removeExtension(YtUsername.class);
        }
    }

    public Rating getRating() {
        return (Rating)this.getExtension(Rating.class);
    }

    public void setRating(Rating rating) {
        if (rating == null) {
            this.removeExtension(Rating.class);
        } else {
            this.setExtension((Extension)rating);
        }
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declareAdditionalNamespace(YouTubeNamespace.NS);
        extProfile.declareAdditionalNamespace(Namespaces.gNs);
        extProfile.declareAdditionalNamespace(com.google.gdata.data.geo.Namespaces.GEO_RSS_NAMESPACE);
        extProfile.declareAdditionalNamespace(com.google.gdata.data.geo.Namespaces.GML_NAMESPACE);
        extProfile.declare(UserEventEntry.class, YtVideoId.class);
        extProfile.declare(UserEventEntry.class, YtUsername.class);
        extProfile.declare(UserEventEntry.class, Rating.getDefaultDescription(false));
        extProfile.declareArbitraryXmlExtension(UserEventEntry.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        VIDEO_UPLOADED,
        VIDEO_RATED,
        VIDEO_FAVORITED,
        VIDEO_SHARED,
        VIDEO_COMMENTED,
        USER_SUBSCRIPTION_ADDED,
        FRIEND_ADDED;


        public String getTerm() {
            return this.toString().toLowerCase();
        }

        public static Type fromTerm(String term) {
            try {
                return Type.valueOf(term.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

