/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.media.mediarss.MediaRating;
import com.google.gdata.util.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExtensionDescription.Default(nsAlias="media", nsUri="http://search.yahoo.com/mrss/", localName="rating", isRepeatable=true)
public class YouTubeMediaRating
extends MediaRating {
    private static final String ALL_COUNTRIES = "all";
    private CountryState countryState = CountryState.UNSET;
    private Set<String> countries = Collections.emptySet();

    public static ExtensionDescription getDefaultDescription() {
        return ExtensionDescription.getDefaultDescription(YouTubeMediaRating.class);
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        String countryValue;
        super.putAttributes(generator);
        switch (this.countryState) {
            case ALL: {
                countryValue = ALL_COUNTRIES;
                break;
            }
            case COUNTRIES: {
                countryValue = YouTubeMediaRating.join(this.countries);
                break;
            }
            case UNSET: {
                countryValue = null;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.countryState));
            }
        }
        if (countryValue != null) {
            generator.put((Object)"yt:country", (Object)countryValue);
        }
    }

    @Override
    protected void consumeAttributes(AttributeHelper attrsHelper) throws ParseException {
        super.consumeAttributes(attrsHelper);
        String countryValue = attrsHelper.consume("country", false);
        if (countryValue == null) {
            this.clearCountry();
        } else if (ALL_COUNTRIES.equals(countryValue)) {
            this.setAllCountries();
        } else {
            this.setCountries(YouTubeMediaRating.split(countryValue));
        }
    }

    public boolean hasCountries() {
        return this.countryState == CountryState.COUNTRIES;
    }

    public void setAllCountries() {
        this.countryState = CountryState.ALL;
        this.countries = Collections.emptySet();
    }

    public void clearCountry() {
        this.countryState = CountryState.UNSET;
        this.countries = Collections.emptySet();
    }

    public void setCountries(Collection<String> countries) {
        if (countries == null || countries.isEmpty()) {
            this.clearCountry();
        } else {
            this.countryState = CountryState.COUNTRIES;
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (String country : countries) {
                set.add(country);
            }
            this.countries = Collections.unmodifiableSet(set);
        }
    }

    public Set<String> getCountries() {
        return this.countries;
    }

    private static String join(Collection<String> strings) {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String string : strings) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(' ');
            }
            builder.append(string);
        }
        return builder.toString();
    }

    private static Set<String> split(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, " ");
        int count = tokenizer.countTokens();
        if (count == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> tokens = new LinkedHashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return Collections.unmodifiableSet(tokens);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CountryState {
        UNSET,
        ALL,
        COUNTRIES;

    }
}

