/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.epsilon.commons.util.StringProperties;
import org.eclipse.epsilon.emc.emf.AbstractEmfModel;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.models.IModel;

public class EmfMetaModel
extends AbstractEmfModel {
    public static final String PROPERTY_METAMODEL_URI = "metamodelUri";
    protected String metamodelUri;
    EPackage.Registry registry = null;

    public EmfMetaModel() {
    }

    public EmfMetaModel(String metamodelUri) {
        this.metamodelUri = metamodelUri;
    }

    public EmfMetaModel(String name, String metamodelUri) {
        this.setName(name);
        this.metamodelUri = metamodelUri;
    }

    public void loadModel() throws EolModelLoadingException {
        this.expand = false;
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(this.metamodelUri);
        if (ePackage == null) {
            throw new EolModelLoadingException(new Exception("Package with URI " + this.metamodelUri + " not found"), (IModel)this);
        }
        this.modelImpl = ePackage.eResource();
    }

    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        super.load(properties, basePath);
        this.metamodelUri = properties.getProperty(PROPERTY_METAMODEL_URI);
        this.load();
    }

    @Override
    protected EPackage.Registry getPackageRegistry() {
        if (this.registry == null) {
            this.registry = new EPackageRegistryImpl();
            this.registry.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        }
        return this.registry;
    }

    public boolean store() {
        return false;
    }

    public String getMetamodelUri() {
        return this.metamodelUri;
    }

    public void setMetamodelUri(String metamodelUri) {
        this.metamodelUri = metamodelUri;
    }
}

