/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.commons.util.StringProperties;
import org.eclipse.epsilon.emc.emf.AbstractEmfModel;
import org.eclipse.epsilon.emc.emf.ContainmentChangeAdapter;
import org.eclipse.epsilon.emc.emf.EmfModelResourceFactory;
import org.eclipse.epsilon.emc.emf.EmfModelResourceSet;
import org.eclipse.epsilon.emc.emf.EmfPropertySetter;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.execute.introspection.IReflectivePropertySetter;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IReflectiveModel;

public class EmfModel
extends AbstractEmfModel
implements IReflectiveModel {
    public static final String PROPERTY_EXPAND = "expand";
    public static final String PROPERTY_IS_METAMODEL_FILE_BASED = "isMetamodelFileBased";
    public static final String PROPERTY_METAMODEL_URI = "metamodelUri";
    public static final String PROPERTY_FILE_BASED_METAMODEL_URI = "fileBasedMetamodelUri";
    @Deprecated
    public static final String PROPERTY_METAMODEL_FILE = "metamodelFile";
    public static final String PROPERTY_MODEL_URI = "modelUri";
    @Deprecated
    public static final String PROPERTY_MODEL_FILE = "modelFile";
    protected String metamodelUri;
    protected List<EPackage> packages;
    protected boolean isMetamodelFileBased;
    protected URI modelUri = null;
    protected URI metamodelFileUri = null;
    protected boolean useExtendedMetadata = false;

    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        PropertyMigrator.migrateDeprecatedProperties(properties);
        super.load(properties, basePath);
        this.metamodelUri = properties.getProperty(PROPERTY_METAMODEL_URI);
        this.expand = properties.getBooleanProperty(PROPERTY_EXPAND, true);
        this.isMetamodelFileBased = properties.getBooleanProperty(PROPERTY_IS_METAMODEL_FILE_BASED, false);
        this.modelUri = URI.createURI((String)properties.getProperty(PROPERTY_MODEL_URI));
        if (this.isMetamodelFileBased) {
            this.metamodelFileUri = URI.createURI((String)properties.getProperty(PROPERTY_FILE_BASED_METAMODEL_URI));
        }
        this.load();
    }

    protected void loadModel() throws EolModelLoadingException {
        this.loadModelFromUri();
        this.setupContainmentChangeListeners();
    }

    public void setupContainmentChangeListeners() {
        if (this.modelImpl != null) {
            for (EObject eObject : this.allContents()) {
                boolean isAdapted = false;
                for (Adapter adapter : eObject.eAdapters()) {
                    if (!(adapter instanceof ContainmentChangeAdapter)) continue;
                    isAdapted = true;
                }
                if (isAdapted) continue;
                eObject.eAdapters().add((Object)new ContainmentChangeAdapter(eObject, eObject.eResource()));
            }
        }
    }

    public void loadModelFromUri() throws EolModelLoadingException {
        EmfModelResourceSet resourceSet = new EmfModelResourceSet();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", EmfModelResourceFactory.getInstance());
        if (EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore") == null) {
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        }
        Resource model = null;
        this.packages = new ArrayList<EPackage>();
        if (this.isMetamodelFileBased) {
            List<EPackage> metamodelPackages;
            try {
                metamodelPackages = EmfUtil.register(this.metamodelFileUri, resourceSet.getPackageRegistry());
            }
            catch (Exception e) {
                throw new EolModelLoadingException(e, (IModel)this);
            }
            for (EPackage metamodelPackage : metamodelPackages) {
                this.packages.add(metamodelPackage);
                EmfUtil.collectDependencies(metamodelPackage, this.packages);
            }
        } else {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(this.metamodelUri);
            this.packages.add(ePackage);
            EmfUtil.collectDependencies(ePackage, this.packages);
        }
        for (EPackage ep : this.packages) {
            String nsUri = ep.getNsURI();
            if (nsUri == null || nsUri.trim().length() == 0) {
                nsUri = ep.getName();
            }
            resourceSet.getPackageRegistry().put((Object)nsUri, (Object)ep);
        }
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        model = resourceSet.createResource(this.modelUri);
        if (this.readOnLoad) {
            try {
                model.load(null);
                if (this.expand) {
                    EcoreUtil.resolveAll((Resource)model);
                }
            }
            catch (IOException e) {
                throw new EolModelLoadingException((Exception)e, (IModel)this);
            }
        }
        this.modelImpl = model;
    }

    public boolean store() {
        if (this.modelImpl == null) {
            return false;
        }
        try {
            this.modelImpl.save(null);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getMetamodelFile() {
        return EmfUtil.getFile(this.metamodelFileUri);
    }

    public boolean isMetamodelFileBased() {
        return this.isMetamodelFileBased;
    }

    public String getMetamodelUri() {
        return this.metamodelUri;
    }

    public String getModelFile() {
        return EmfUtil.getFile(this.modelUri);
    }

    public URI getModelFileUri() {
        return this.modelUri;
    }

    public void setModelFileUri(URI modelFileUri) {
        this.modelUri = modelFileUri;
    }

    public URI getMetamodelFileUri() {
        return this.metamodelFileUri;
    }

    public void setMetamodelFileUri(URI metamodelFileUri) {
        this.metamodelFileUri = metamodelFileUri;
    }

    public void setMetamodelUri(String metamodelUri) {
        this.metamodelUri = metamodelUri;
    }

    public void setMetamodelFile(String metamodelFile) {
        this.metamodelFileUri = URI.createFileURI((String)metamodelFile);
    }

    public void setModelFile(String modelFile) {
        this.modelUri = URI.createFileURI((String)modelFile);
    }

    public void setMetamodelFileBased(boolean isMetamodelFileBased) {
        this.isMetamodelFileBased = isMetamodelFileBased;
    }

    public Collection<String> getPropertiesOf(String type) throws EolModelElementTypeNotFoundException {
        LinkedList<String> properties = new LinkedList<String>();
        for (EStructuralFeature feature : this.featuresForType(type)) {
            properties.add(feature.getName());
        }
        return properties;
    }

    private EList<EStructuralFeature> featuresForType(String type) throws EolModelElementTypeNotFoundException {
        return this.classForName(type).getEAllStructuralFeatures();
    }

    public IReflectivePropertySetter getPropertySetter() {
        return new EmfPropertySetter();
    }

    public boolean hasProperty(String type, String property) throws EolModelElementTypeNotFoundException {
        return this.getPropertiesOf(type).contains(property);
    }

    static class PropertyMigrator {
        PropertyMigrator() {
        }

        public static void migrateDeprecatedProperties(StringProperties properties) {
            PropertyMigrator.migrateModelFileProperty(properties);
            PropertyMigrator.migrateMetamodelFileProperty(properties);
        }

        private static void migrateModelFileProperty(StringProperties properties) {
            PropertyMigrator.migrateUriValue(properties, EmfModel.PROPERTY_MODEL_FILE, EmfModel.PROPERTY_MODEL_URI);
        }

        private static void migrateMetamodelFileProperty(StringProperties properties) {
            PropertyMigrator.migrateUriValue(properties, EmfModel.PROPERTY_METAMODEL_FILE, EmfModel.PROPERTY_FILE_BASED_METAMODEL_URI);
        }

        private static void migrateUriValue(StringProperties properties, String oldProperty, String newProperty) {
            if (properties.hasValueFor(oldProperty) && !properties.hasValueFor(newProperty)) {
                String oldValue = properties.getProperty(oldProperty);
                URI newValue = EmfUtil.createPlatformResourceURI(oldValue);
                properties.put((Object)newProperty, (Object)newValue);
            }
        }
    }
}

