/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.epsilon.emc.emf.EmfXMIResource;

public class EmfModelResourceFactory
extends XMIResourceFactoryImpl {
    protected static EmfModelResourceFactory instance;
    protected HashMap<String, Resource> resourceMap = new HashMap();

    public static EmfModelResourceFactory getInstance() {
        if (instance == null) {
            instance = new EmfModelResourceFactory();
        }
        return instance;
    }

    private EmfModelResourceFactory() {
    }

    public Resource createResource(URI uri) {
        if (this.resourceMap.containsKey(uri.toString())) {
            return this.resourceMap.get(uri.toString());
        }
        Resource.Factory resourceFactory = Resource.Factory.Registry.INSTANCE.getFactory(uri);
        EmfXMIResource resource = null;
        resource = resourceFactory != null && resourceFactory.getClass() != XMIResourceFactoryImpl.class ? resourceFactory.createResource(uri) : new EmfXMIResource(uri);
        if (resource instanceof XMLResource) {
            this.configure((XMLResource)resource);
        }
        resource.setTrackingModification(false);
        this.resourceMap.put(uri.toString(), (Resource)resource);
        return resource;
    }

    public void configure(XMLResource resource) {
        Map loadOptions = resource.getDefaultLoadOptions();
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
        loadOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
    }

    public void removeCachedResource(URI uri) {
        Resource toRemove = this.resourceMap.get(uri.toString());
        if (toRemove != null) {
            this.safeRemove(toRemove);
        }
    }

    protected void safeRemove(Resource toRemove) {
        if (!this.resourceMap.containsValue(toRemove)) {
            return;
        }
        boolean shouldRemove = true;
        for (Resource resource : this.resourceMap.values()) {
            if (resource.getResourceSet() == toRemove.getResourceSet() || !resource.getResourceSet().getResources().contains((Object)toRemove)) continue;
            shouldRemove = false;
            break;
        }
        if (shouldRemove) {
            this.resourceMap.remove(toRemove.getURI().toString());
            try {
                toRemove.unload();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            for (Resource resource : toRemove.getResourceSet().getResources()) {
                this.safeRemove(resource);
            }
        }
    }

    protected String toString(String header) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(header) + "\r\n");
        for (String key : this.resourceMap.keySet()) {
            buffer.append("+ " + key + "->" + this.resourceMap.get(key) + "\r\n");
        }
        return buffer.toString();
    }
}

