/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.emc.emf.EmfUtil;

public class InMemoryEmfModel
extends EmfModel {
    public InMemoryEmfModel(String name, Resource modelImpl, EPackage ... ePackages) {
        this.init(name, modelImpl, Arrays.asList(ePackages));
    }

    public InMemoryEmfModel(String name, Resource modelImpl, String ... nsUris) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        String[] stringArray = nsUris;
        int n = nsUris.length;
        int n2 = 0;
        while (n2 < n) {
            String nsUri = stringArray[n2];
            ePackages.add(EPackage.Registry.INSTANCE.getEPackage(nsUri));
            ++n2;
        }
        this.init(name, modelImpl, ePackages);
    }

    public InMemoryEmfModel(Resource modelImpl) {
        this.init("Model", modelImpl, Collections.EMPTY_LIST);
    }

    public InMemoryEmfModel(String name, Resource modelImpl) {
        this.init(name, modelImpl, Collections.EMPTY_LIST);
    }

    public InMemoryEmfModel(String name, Resource modelImpl, Collection<EPackage> ePackages) {
        this.init(name, modelImpl, ePackages);
    }

    protected void init(String name, Resource modelImpl, Collection<EPackage> ePackages) {
        this.setName(name);
        this.modelImpl = modelImpl;
        this.expand = true;
        modelImpl.getResourceSet().setResourceFactoryRegistry(Resource.Factory.Registry.INSTANCE);
        if (ePackages == null || ePackages.isEmpty()) {
            modelImpl.getResourceSet().setPackageRegistry(EPackage.Registry.INSTANCE);
        } else {
            for (EPackage ePackage : ePackages) {
                modelImpl.getResourceSet().getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
                ArrayList<EPackage> dependencies = new ArrayList<EPackage>();
                EmfUtil.collectDependencies(ePackage, dependencies);
                for (EPackage dependency : dependencies) {
                    modelImpl.getResourceSet().getPackageRegistry().put((Object)dependency.getNsURI(), (Object)dependency);
                }
            }
        }
        this.setupContainmentChangeListeners();
    }

    @Override
    public void loadModel() {
    }
}

