/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.emf.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.GenericXMLResourceFactoryImpl;
import org.eclipse.epsilon.commons.util.StringProperties;
import org.eclipse.epsilon.commons.util.StringUtil;
import org.eclipse.epsilon.emc.emf.AbstractEmfModel;
import org.eclipse.epsilon.emc.emf.xml.XmlPropertySetter;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;

public class XmlModel
extends AbstractEmfModel {
    public static String PROPERTY_MODEL_FILE = "modelFile";
    public static String PROPERTY_XSD_FILE = "xsdFile";
    protected String modelFile = "";
    protected String xsdFile = "";
    static String basePath = "E://Projects//Eclipse//3.3//workspace//org.eclipse.epsilon.eol.models.emf//src//org//epsilon//eol//models//emf//xml//";

    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        super.load(properties, basePath);
        this.modelFile = String.valueOf(StringUtil.toString((Object)basePath)) + properties.getProperty(PROPERTY_MODEL_FILE);
        this.xsdFile = String.valueOf(StringUtil.toString((Object)basePath)) + properties.getProperty(PROPERTY_XSD_FILE);
        this.load();
    }

    public static void main(String[] args) throws Exception {
        XmlModel model = new XmlModel();
        model.modelFile = String.valueOf(basePath) + "Test.xml";
        model.xsdFile = String.valueOf(basePath) + "TestCases.xsd";
        model.load();
        model.store(String.valueOf(model.modelFile) + "copy.xml");
    }

    protected void loadModel() throws EolModelLoadingException {
        Map etfm;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (this.xsdFile != null && this.xsdFile.endsWith("xsd")) {
            XSDEcoreBuilder xsdEcoreBuilder = new XSDEcoreBuilder();
            Collection eCorePackages = xsdEcoreBuilder.generate(URI.createFileURI((String)this.xsdFile));
            for (EPackage element : eCorePackages) {
                if (element.getNsURI() == null || element.getNsURI().length() == 0) {
                    element.setNsURI(element.getName());
                }
                resourceSet.getPackageRegistry().put((Object)element.getNsURI(), (Object)element);
            }
        }
        if (!(etfm = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()).containsKey("*")) {
            etfm.put("*", new GenericXMLResourceFactoryImpl());
        }
        Resource resource = resourceSet.createResource(URI.createFileURI((String)this.modelFile));
        try {
            if (this.readOnLoad) {
                resource.load(null);
            }
        }
        catch (IOException e) {
            throw new EolModelLoadingException((Exception)e, (IModel)this);
        }
        this.modelImpl = resource;
    }

    public boolean store() {
        return this.store(this.modelFile);
    }

    @Override
    public boolean store(String fileName) {
        OutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(fileName);
                this.modelImpl.save(fos, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return false;
            }
        }
        finally {
            try {
                fos.flush();
                ((FileOutputStream)fos).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public IPropertySetter getPropertySetter() {
        return new XmlPropertySetter();
    }
}

