/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.epsilon.commons.util.UriUtil;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.EglContext;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.CompositeFormatter;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.formatter.NullFormatter;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecification;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecificationFactory;
import org.eclipse.epsilon.egl.util.FileUtil;

public class EglTemplateFactory {
    protected final IEglContext context;
    protected URI root;
    private URI templateRoot;
    private String templateRootPath;
    private Formatter defaultFormatter = new NullFormatter();

    public EglTemplateFactory() {
        this.context = new EglContext(this);
    }

    public EglTemplateFactory(IEglContext context) {
        this.context = context;
    }

    public void setDefaultFormatter(Formatter defaultFormatter) {
        this.defaultFormatter = defaultFormatter;
    }

    public void setDefaultFormatters(Formatter ... defaultFormatters) {
        this.setDefaultFormatters(Arrays.asList(defaultFormatters));
    }

    public void setDefaultFormatters(Collection<Formatter> defaultFormatters) {
        this.setDefaultFormatter(new CompositeFormatter(defaultFormatters));
    }

    public IEglContext getContext() {
        return this.context;
    }

    public void setRoot(URI root) {
        this.root = root;
    }

    public String getTemplateRoot() {
        return this.templateRootPath;
    }

    public void setTemplateRoot(String path) throws EglRuntimeException {
        this.templateRootPath = path;
        this.templateRoot = this.resolveRoot(path);
    }

    protected URI resolveRoot(String path) throws EglRuntimeException {
        try {
            path = UriUtil.encode((String)path, (boolean)true);
            return UriUtil.resolve((String)path, (URI[])new URI[]{this.root});
        }
        catch (URISyntaxException e) {
            throw new EglRuntimeException("Could not resolve path: " + path, e, this.context.getModule().getAst());
        }
    }

    protected URI resolveTemplate(String path) throws EglRuntimeException {
        try {
            path = UriUtil.encode((String)path, (boolean)false);
            return UriUtil.resolve((String)path, (URI[])new URI[]{this.templateRoot, this.root});
        }
        catch (URISyntaxException e) {
            throw new EglRuntimeException("Could not resolve path: " + path, e, this.context.getModule().getAst());
        }
    }

    protected String name(String path) {
        String name = path;
        if (this.templateRootPath != null) {
            name = String.valueOf(new File(this.templateRootPath).getPath()) + FileUtil.FILE_SEP + name;
        }
        return name;
    }

    public EglTemplate load(File file) throws EglRuntimeException {
        String name = this.name(file.getAbsolutePath());
        try {
            return this.load(this.createTemplateSpecificationFactory().fromResource(name, UriUtil.fileToUri((File)file)));
        }
        catch (URISyntaxException e) {
            return this.handleFailedLoad(name, e);
        }
    }

    protected EglTemplate load(String code, File file) throws EglRuntimeException {
        String name = this.name(file.getAbsolutePath());
        try {
            return this.load(this.createTemplateSpecificationFactory().fromDirtyResource(name, code, UriUtil.fileToUri((File)file)));
        }
        catch (URISyntaxException e) {
            return this.handleFailedLoad(name, e);
        }
    }

    public EglTemplate load(String path) throws EglRuntimeException {
        return this.load(this.createTemplateSpecificationFactory().fromResource(this.name(path), this.resolveTemplate(path)));
    }

    public EglTemplate load(URI resource) throws EglRuntimeException {
        String name = resource.toString();
        return this.load(this.createTemplateSpecificationFactory().fromResource(name, resource));
    }

    protected EglTemplate load(EglTemplateSpecification spec) throws EglRuntimeException {
        try {
            return this.createTemplate(spec);
        }
        catch (Exception e) {
            return this.handleFailedLoad(spec.getName(), e);
        }
    }

    private EglTemplate handleFailedLoad(String name, Exception e) throws EglRuntimeException {
        String reason = e instanceof FileNotFoundException ? "Template not found" : "Could not process";
        if (this.context.getModule() == null) {
            throw new EglRuntimeException(String.valueOf(reason) + " '" + name + "'", e);
        }
        throw new EglRuntimeException(String.valueOf(reason) + " '" + name + "'", e, this.context.getModule().getAst());
    }

    public EglTemplate prepare(String code) throws Exception {
        return this.createTemplate(this.createTemplateSpecificationFactory().fromCode(code));
    }

    protected EglTemplate createTemplate(EglTemplateSpecification spec) throws Exception {
        return new EglTemplate(spec, this.context);
    }

    private EglTemplateSpecificationFactory createTemplateSpecificationFactory() {
        return new EglTemplateSpecificationFactory(this.defaultFormatter);
    }

    public String toString() {
        String root = this.templateRoot == null ? "" : this.templateRoot.toString();
        return "TemplateFactory: root='" + root + "'";
    }
}

