/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.context;

import java.util.Stack;
import org.eclipse.epsilon.egl.execute.context.ExecutableTemplateSpecification;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;

public class EglFrameStackManager {
    private final FrameStack frameStack;
    private final Stack<Frame> savedGlobals = new Stack();

    public EglFrameStackManager(FrameStack frameStack) {
        this.frameStack = frameStack;
    }

    public void prepareFrameStackFor(ExecutableTemplateSpecification spec) {
        this.saveGlobals();
        this.frameStack.enter(FrameType.PROTECTED, null);
        spec.addVariablesTo(this.frameStack);
    }

    public void restoreFrameStackToPreviousState() {
        this.frameStack.leave(null);
        this.restoreGlobals();
    }

    private void saveGlobals() {
        this.savedGlobals.push(this.frameStack.getGlobals().clone());
    }

    private void restoreGlobals() {
        this.frameStack.getGlobals().clear();
        this.frameStack.getGlobals().putAll(this.savedGlobals.pop().getAll());
    }
}

