/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.execute.context;

import org.eclipse.epsilon.egl.output.OutputBuffer;
import org.eclipse.epsilon.egl.traceability.Template;
import org.eclipse.epsilon.egl.traceability.Variable;
import org.eclipse.epsilon.eol.execute.context.FrameStack;

public class ExecutableTemplateSpecification {
    public Template template;
    public OutputBuffer outputBuffer;

    public ExecutableTemplateSpecification(Template template, OutputBuffer outputBuffer) {
        this.template = template;
        this.outputBuffer = outputBuffer;
    }

    public void addAsChild(ExecutableTemplateSpecification child) {
        this.template.add(child.template);
    }

    public void addVariablesTo(FrameStack frameStack) {
        this.addOutAsGlobalVariable(frameStack);
        this.addTemplateVariablesAsLocalVariables(frameStack);
    }

    private void addOutAsGlobalVariable(FrameStack frameStack) {
        frameStack.getGlobals().put(this.createEolVariable("out", this.outputBuffer));
    }

    private void addTemplateVariablesAsLocalVariables(FrameStack frameStack) {
        for (Variable variable : this.template.getVariables()) {
            frameStack.put(this.createEolVariable(variable.getName(), variable.getValue()));
        }
    }

    private org.eclipse.epsilon.eol.execute.context.Variable createEolVariable(String name, Object value) {
        return org.eclipse.epsilon.eol.execute.context.Variable.createReadOnlyVariable((String)name, (Object)value);
    }

    public String toString() {
        return this.template.toString();
    }
}

