/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.commons.module.IModule;
import org.eclipse.epsilon.commons.module.ModuleElement;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.parse.EpsilonTreeAdaptor;
import org.eclipse.epsilon.commons.parse.problem.ParseProblem;
import org.eclipse.epsilon.commons.util.UriUtil;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.internal.EglPreprocessorModule;
import org.eclipse.epsilon.egl.internal.IEglModule;
import org.eclipse.epsilon.egl.model.EglSection;
import org.eclipse.epsilon.egl.parse.EglLexer;
import org.eclipse.epsilon.egl.parse.EglParser;
import org.eclipse.epsilon.egl.traceability.Template;
import org.eclipse.epsilon.eol.EolLibraryModule;
import org.eclipse.epsilon.eol.EolOperations;

public class EglModule
extends EolLibraryModule
implements IEglModule {
    protected EglParser parser = null;
    protected EglLexer lexer = null;
    protected IEglContext context = null;
    protected Reader reader;
    protected EglPreprocessorModule preprocessorModule = null;
    private final List<EglSection> sections = new LinkedList<EglSection>();
    private URI templateRoot;

    public EglModule() {
        this.reset();
    }

    public EglModule(IEglContext context) {
        this.context = context;
        this.reset();
    }

    public boolean parse(String code) throws Exception {
        return this.parse(code, null);
    }

    public boolean parse(String code, File file) throws Exception {
        return this.parseFromLexer(new EglLexer(code), file);
    }

    public boolean parse(File file) throws Exception {
        try {
            this.reader = new BufferedReader(new FileReader(file));
            boolean bl = this.parseFromLexer(new EglLexer(this.reader), file);
            return bl;
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private boolean parseFromLexer(EglLexer lexer, File file) throws Exception {
        this.sourceFile = file;
        if (file != null) {
            this.sourceUri = file.toURI();
            try {
                this.templateRoot = UriUtil.fileToUri((File)file.getParentFile());
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return this.parseAndPreprocess(lexer, file);
    }

    public boolean parse(URI uri) throws Exception {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        try {
            this.sourceUri = uri;
            if (uri.getScheme() != null && uri.getScheme().equals("file")) {
                this.sourceFile = new File(uri);
            }
            this.templateRoot = uri;
            if (this.context != null) {
                this.context.getTemplateFactory().setRoot(uri);
            }
            this.reader = new BufferedReader(new InputStreamReader(uri.toURL().openStream()));
            boolean bl = this.parseAndPreprocess(new EglLexer(this.reader), null);
            return bl;
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    private boolean parseAndPreprocess(EglLexer lexer, File file) throws Exception {
        this.lexer = lexer;
        EpsilonTreeAdaptor astFactory = new EpsilonTreeAdaptor(file);
        this.parser = new EglParser(lexer, astFactory);
        this.parser.parse();
        this.ast = this.parser.getAST();
        boolean validEgl = this.parser.getParseProblems().size() == 0;
        boolean validEol = this.preprocess();
        if (validEgl && validEol) {
            this.buildModel();
        }
        return validEgl && validEol;
    }

    private boolean preprocess() {
        return this.preprocessorModule.preprocess(this.ast, this.sourceFile, this.sourceUri);
    }

    public void buildModel() throws Exception {
        for (AST child : this.ast.getChildren()) {
            EglSection section = EglSection.createFrom(child);
            if (section == null) continue;
            this.sections.add(section);
        }
    }

    @Override
    public String execute(Template template, Formatter postprocessor) throws EglRuntimeException {
        this.context.enter(template);
        String result = this.execute(postprocessor);
        this.context.exit();
        return result;
    }

    private String execute(Formatter postprocessor) throws EglRuntimeException {
        this.context.setModule((IModule)this);
        this.context.getTemplateFactory().setRoot(this.templateRoot);
        this.context.copyInto(this.preprocessorModule.getContext());
        this.preprocessorModule.execute();
        this.context.formatWith(postprocessor);
        this.checkOutput();
        return this.context.getOutputBuffer().toString();
    }

    private void checkOutput() throws EglRuntimeException {
        List<String> problems = this.context.getPartitioningProblems();
        if (problems.size() > 0) {
            throw new EglRuntimeException(problems.get(0), this.ast);
        }
    }

    public void reset() {
        super.reset();
        this.preprocessorModule = new EglPreprocessorModule();
    }

    @Override
    public IEglContext getContext() {
        return this.context;
    }

    public List<ParseProblem> getParseProblems() {
        ArrayList<ParseProblem> combinedErrors = new ArrayList<ParseProblem>(this.parser.getParseProblems());
        combinedErrors.addAll(this.preprocessorModule.getParseProblems());
        return combinedErrors;
    }

    public EolOperations getOperations() {
        return this.preprocessorModule.getOperations();
    }

    public AST getAst() {
        return this.preprocessorModule.getAst();
    }

    public List<ModuleElement> getChildren() {
        LinkedList<ModuleElement> children = new LinkedList<ModuleElement>();
        children.addAll(this.preprocessorModule.getImports());
        children.addAll(this.sections);
        children.addAll((Collection<ModuleElement>)this.preprocessorModule.getDeclaredOperations());
        return children;
    }
}

