/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.commons.module.ModuleElement;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.egl.model.EglDynamicSection;
import org.eclipse.epsilon.egl.model.EglShortcutSection;
import org.eclipse.epsilon.egl.model.EglStaticSection;
import org.eclipse.epsilon.egl.parse.Token;

public abstract class EglSection
implements ModuleElement {
    private final AST ast;

    public static EglSection createFrom(AST ast) {
        switch (Token.TokenType.typeOf(ast.getType())) {
            case START_TAG: {
                return new EglDynamicSection(ast);
            }
            case START_OUTPUT_TAG: {
                return new EglShortcutSection(ast);
            }
            case PLAIN_TEXT: {
                return new EglStaticSection(ast);
            }
        }
        return null;
    }

    protected EglSection(AST ast) {
        this.ast = ast;
    }

    public AST getAst() {
        return this.ast;
    }

    public List<?> getChildren() {
        return Collections.emptyList();
    }

    public abstract String getText();

    public String toString() {
        String text = this.getText();
        if (text.length() > 30) {
            return String.valueOf(text.substring(0, 30)) + "...";
        }
        return text;
    }
}

