/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.preprocessor;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.egl.parse.Token;
import org.eclipse.epsilon.egl.preprocessor.PreprocessorTrace;
import org.eclipse.epsilon.egl.util.FileUtil;
import org.eclipse.epsilon.egl.util.StringUtil;

public class Preprocessor {
    private StringBuffer eol = new StringBuffer();
    private final Map<Integer, Integer> colNumber = new TreeMap<Integer, Integer>();
    private PreprocessorTrace trace = new PreprocessorTrace();
    private AST child = null;

    private static String escape(String s) {
        String escaped = s;
        escaped = escaped.replaceAll("\\\\", "\\\\\\\\");
        escaped = escaped.replaceAll("\r", "\\\\r");
        escaped = escaped.replaceAll("\n", "\\\\n");
        escaped = escaped.replaceAll("\t", "\\\\t");
        escaped = escaped.replaceAll("\b", "\\\\b");
        escaped = escaped.replaceAll("\f", "\\\\f");
        escaped = escaped.replace("'", "\\'");
        escaped = escaped.replace("\"", "\\\"");
        return escaped;
    }

    private int getOffset(int lineNumber) {
        if (this.colNumber.containsKey(lineNumber)) {
            return this.colNumber.get(lineNumber);
        }
        return 0;
    }

    private void addToOffset(int lineNumber, int addend) {
        this.colNumber.put(lineNumber, this.getOffset(lineNumber) + addend);
    }

    private void updateOffset(int eglLineNumber, int correction, int textLength) {
        this.trace.incrementColumnCorrectionNumber(this.getOffset(eglLineNumber) + correction);
        this.addToOffset(eglLineNumber, correction + textLength + 2);
    }

    private void appendNewLineToEol(int eglLineNumber) {
        this.appendNewLineToEol(eglLineNumber, this.eol.length() > 0);
    }

    private void appendNewLineToEol(int eglLineNumber, boolean appendNewLine) {
        if (appendNewLine) {
            this.eol.append(FileUtil.NEWLINE);
        }
        this.trace.setEglLineNumberForCurrentEolLineNumber(eglLineNumber);
    }

    private void appendToEolOnANewLine(String text, int eglLineNumber) {
        this.appendNewLineToEol(eglLineNumber);
        this.eol.append(text);
    }

    private boolean eolEndsWith(String suffix) {
        if (suffix.length() > this.eol.length()) {
            return false;
        }
        return this.eol.substring(this.eol.length() - suffix.length(), this.eol.length()).equals(suffix);
    }

    public String convertToEol(AST ast) {
        this.eol = new StringBuffer();
        this.colNumber.clear();
        this.trace.reset();
        this.child = ast.getFirstChild();
        while (this.child != null) {
            switch (Token.TokenType.typeOf(this.child.getType())) {
                case START_COMMENT_TAG: {
                    int commentLength = this.child.getText().length();
                    AST current = this.child.getFirstChild();
                    while (current != null) {
                        commentLength += current.getText().length();
                        current = current.getNextSibling();
                    }
                    this.addToOffset(this.child.getLine(), commentLength);
                    this.gobbleNextIfNewLine();
                    break;
                }
                case PLAIN_TEXT: 
                case NEW_LINE: {
                    boolean isWhitespacePrecedingTagged;
                    this.addToOffset(this.child.getLine(), this.child.getText().length());
                    boolean bl = isWhitespacePrecedingTagged = Token.TokenType.typeOf(this.child.getType()) != Token.TokenType.NEW_LINE && StringUtil.isWhitespace(this.child.getText()) && this.child.getNextSibling() != null && (Token.TokenType.typeOf(this.child.getNextSibling().getType()) == Token.TokenType.START_TAG || Token.TokenType.typeOf(this.child.getNextSibling().getType()) == Token.TokenType.START_COMMENT_TAG);
                    if (isWhitespacePrecedingTagged) break;
                    this.appendToEolOnANewLine("out.print('" + Preprocessor.escape(this.child.getText()) + "');", this.child.getLine());
                    break;
                }
                case START_TAG: 
                case START_OUTPUT_TAG: {
                    if (!this.eolEndsWith(FileUtil.NEWLINE)) {
                        this.appendNewLineToEol(this.child.getLine());
                    }
                    if (Token.TokenType.typeOf(this.child.getType()) == Token.TokenType.START_TAG) {
                        AST textAst = this.child.getFirstChild();
                        boolean firstLine = true;
                        while (textAst != null && Token.TokenType.typeOf(textAst.getType()) != Token.TokenType.END_TAG) {
                            if (Token.TokenType.typeOf(textAst.getType()) == Token.TokenType.NEW_LINE) {
                                if (Token.TokenType.typeOf(textAst.getNextSibling().getType()) != Token.TokenType.END_TAG) {
                                    this.appendNewLineToEol(textAst.getLine() + 1, true);
                                    firstLine = false;
                                }
                            } else {
                                int correction = firstLine ? 2 : 0;
                                this.updateOffset(textAst.getLine(), correction, textAst.getText().length());
                                this.eol.append(textAst.getText());
                            }
                            textAst = textAst.getNextSibling();
                        }
                        this.gobbleNextIfNewLine();
                        break;
                    }
                    this.updateOffset(this.child.getLine(), 3, this.child.getFirstChild().getText().length());
                    String printCall = "out.printdyn(";
                    this.trace.incrementColumnCorrectionNumber(-printCall.length());
                    this.eol.append(String.valueOf(printCall) + this.child.getFirstChild().getText() + ");");
                }
            }
            this.child = this.child.getNextSibling();
        }
        return this.eol.toString();
    }

    private void gobbleNextIfNewLine() {
        boolean nextNodeIsNewLine;
        boolean bl = nextNodeIsNewLine = this.child.getNextSibling() != null && Token.TokenType.typeOf(this.child.getNextSibling().getType()) == Token.TokenType.NEW_LINE;
        if (nextNodeIsNewLine) {
            this.child = this.child.getNextSibling();
        }
    }

    public PreprocessorTrace getTrace() {
        return this.trace;
    }
}

