/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.spec;

import java.net.URI;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.egl.spec.CodeBackedTemplateSpecification;
import org.eclipse.epsilon.egl.spec.DirtyResourceBackedTemplateSpecification;
import org.eclipse.epsilon.egl.spec.EglTemplateSpecification;
import org.eclipse.epsilon.egl.spec.ResourceBackedTemplateSpecification;

public class EglTemplateSpecificationFactory {
    private final Formatter defaultFormatter;

    public EglTemplateSpecificationFactory(Formatter defaultFormatter) {
        this.defaultFormatter = defaultFormatter;
    }

    public EglTemplateSpecification fromCode(String code) {
        return new CodeBackedTemplateSpecification(code, this.defaultFormatter);
    }

    public EglTemplateSpecification fromResource(String name, URI resource) {
        return new ResourceBackedTemplateSpecification(name, resource, this.defaultFormatter);
    }

    public EglTemplateSpecification fromDirtyResource(String name, String latestCode, URI resource) {
        return new DirtyResourceBackedTemplateSpecification(name, latestCode, resource, this.defaultFormatter);
    }
}

