/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.traceability;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.egl.traceability.Content;
import org.eclipse.epsilon.egl.traceability.Template;

public abstract class Container<E extends Content>
extends Content<Template> {
    private final String name;
    private final URI uri;
    private final List<E> contents = new LinkedList();

    protected Container(Template parent, String name, URI uri) {
        super(parent);
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public URI getURI() {
        return this.uri;
    }

    public void add(E child) {
        if (child.equals(this)) {
            try {
                throw new IllegalArgumentException();
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
        ((Content)child).setParent((Container)this);
        this.contents.add(child);
    }

    public List<E> getChildren() {
        return Collections.unmodifiableList(this.contents);
    }

    public boolean hasChildren() {
        return !this.contents.isEmpty();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container that = (Container)o;
        return this.name.equals(that.name) && (this.uri == null ? that.uri == null : this.uri.equals(that.uri)) && this.contents.equals(that.contents);
    }

    public int hashCode() {
        int result = 17;
        result += 37 * this.name.hashCode();
        result += 37 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result += 37 * this.contents.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (!this.contents.isEmpty()) {
            sb.append(' ');
            sb.append(this.contents);
        }
        return sb.toString();
    }
}

