/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.console;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.epsilon.common.dt.console.EolRuntimeExceptionHyperlinkListener;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.IPatternMatchListener;

public class EpsilonConsole {
    private IOConsole ioConsole = new IOConsole("Epsilon", null);
    private static EpsilonConsole instance = null;
    private PrintStream infoPrintStream;
    private PrintStream debugPrintStream;
    private PrintStream errorPrintStream;
    private PrintStream warningPrintStream;
    private InputStream inputStream;

    private EpsilonConsole() {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                EpsilonConsole.this.debugPrintStream = EpsilonConsole.this.newPrintStream(display.getSystemColor(2));
                EpsilonConsole.this.errorPrintStream = EpsilonConsole.this.newPrintStream(display.getSystemColor(3));
                EpsilonConsole.this.warningPrintStream = EpsilonConsole.this.newPrintStream(display.getSystemColor(8));
                EpsilonConsole.this.infoPrintStream = EpsilonConsole.this.newPrintStream(display.getSystemColor(9));
                EpsilonConsole.this.inputStream = (InputStream)EpsilonConsole.this.ioConsole.getInputStream();
                EpsilonConsole.this.ioConsole.getInputStream().setColor(display.getSystemColor(5));
            }
        });
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.ioConsole});
        this.ioConsole.addPatternMatchListener((IPatternMatchListener)new EolRuntimeExceptionHyperlinkListener(this.ioConsole));
    }

    public static EpsilonConsole getInstance() {
        if (instance == null) {
            instance = new EpsilonConsole();
        }
        return instance;
    }

    public PrintStream newPrintStream(Color color) {
        IOConsoleOutputStream mcs = this.ioConsole.newOutputStream();
        mcs.setActivateOnWrite(true);
        mcs.setColor(color);
        return new PrintStream((OutputStream)mcs);
    }

    public void clear() {
        this.ioConsole.clearConsole();
    }

    public PrintStream getDebugStream() {
        return this.debugPrintStream;
    }

    public PrintStream getErrorStream() {
        return this.errorPrintStream;
    }

    public PrintStream getInfoStream() {
        return this.infoPrintStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void reportParseAnomaly(ParseProblem anomaly) {
    }

    public PrintStream getWarningStream() {
        return this.warningPrintStream;
    }
}

