/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epsilon.common.dt.editor.AbstractModuleEditorDocumentProvider;
import org.eclipse.epsilon.common.dt.editor.AbstractModuleEditorSourceViewerConfiguration;
import org.eclipse.epsilon.common.dt.editor.IModuleParseListener;
import org.eclipse.epsilon.common.dt.editor.contentassist.IAbstractModuleEditorTemplateContributor;
import org.eclipse.epsilon.common.dt.editor.outline.ModuleContentOutlinePage;
import org.eclipse.epsilon.common.dt.editor.outline.ModuleElementLabelProvider;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.ListBuilder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractModuleEditor
extends AbstractDecoratedTextEditor {
    protected Color backgroundColor = null;
    protected Job parseModuleJob = null;
    protected ArrayList<IModuleParseListener> moduleParsedListeners = new ArrayList();
    protected ArrayList<IAbstractModuleEditorTemplateContributor> templateContributors = new ArrayList();
    public static final Color COMMENT = new Color((Device)Display.getCurrent(), new RGB(63, 127, 95));
    public static final Color ANNOTATION;
    public static final Color EXECUTABLEANNOTATION;
    public static final Color STRING;
    public static final Color DEFAULT;
    public static final Color KEYWORD;
    public static final Color BUILTIN;
    public static final Color ASSERTION;
    public static final Color TYPE;
    public static final String PROBLEMMARKER = "org.eclipse.epsilon.common.dt.problemmarker";
    private ModuleContentOutlinePage outlinePage;
    public static final String EDITOR_MATCHING_BRACKETS = "matchingBrackets";
    public static final String EDITOR_MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    ProjectionSupport projectionSupport;
    AnnotationModel annotationModel;
    private static final String CONTENTASSIST_PROPOSAL_ID = "org.eclipse.common.dt.editor.AbsractModuleEditor.ContentAssistProposal";

    static {
        EXECUTABLEANNOTATION = ANNOTATION = new Color((Device)Display.getCurrent(), new RGB(184, 160, 0));
        STRING = new Color((Device)Display.getCurrent(), new RGB(42, 0, 255));
        DEFAULT = new Color((Device)Display.getCurrent(), new RGB(0, 0, 0));
        KEYWORD = new Color((Device)Display.getCurrent(), new RGB(127, 0, 85));
        BUILTIN = new Color((Device)Display.getCurrent(), new RGB(42, 0, 255));
        ASSERTION = new Color((Device)Display.getCurrent(), new RGB(255, 0, 0));
        TYPE = new Color((Device)Display.getCurrent(), new RGB(0, 192, 0));
    }

    public AbstractModuleEditor() {
        this.setDocumentProvider((IDocumentProvider)new AbstractModuleEditorDocumentProvider());
        this.setEditorContextMenuId("#TextEditorContext");
        this.setRulerContextMenuId("editor.rulerMenu");
    }

    public void addModuleParsedListener(IModuleParseListener listener) {
        this.moduleParsedListeners.add(listener);
    }

    public boolean removeModuleParsedListener(IModuleParseListener listener) {
        return this.moduleParsedListeners.remove(this.moduleParsedListeners);
    }

    public void addTemplateContributor(IAbstractModuleEditorTemplateContributor templateContributor) {
        this.templateContributors.add(templateContributor);
    }

    public boolean removeTemplateContributor(IAbstractModuleEditorTemplateContributor templateContributor) {
        return this.templateContributors.remove(templateContributor);
    }

    protected void notifyModuleParsedListeners(IModule module) {
        for (IModuleParseListener listener : this.moduleParsedListeners) {
            listener.moduleParsed(this, module);
        }
    }

    public void insertText(String text) {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        TextSelection selection = (TextSelection)this.getSelectionProvider().getSelection();
        try {
            doc.replace(selection.getOffset(), 0, text);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        char[] matchChars = new char[]{'(', ')', '[', ']', '{', '}'};
        DefaultCharacterPairMatcher matcher = new DefaultCharacterPairMatcher(matchChars, "__dftl_partitioning");
        support.setCharacterPairMatcher((ICharacterPairMatcher)matcher);
        support.setMatchingCharacterPainterPreferenceKeys(EDITOR_MATCHING_BRACKETS, EDITOR_MATCHING_BRACKETS_COLOR);
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault(EDITOR_MATCHING_BRACKETS, true);
        store.setDefault(EDITOR_MATCHING_BRACKETS_COLOR, "128,128,128");
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            return this.outlinePage;
        }
        return super.getAdapter(required);
    }

    public List<String> getAssertions() {
        return new ListBuilder().build((Object[])new String[]{"assert", "assertError"});
    }

    public List<String> getTypes() {
        return new ListBuilder().build((Object[])new String[]{"String", "Boolean", "Integer", "Real", "Any", "Map", "Collection", "Bag", "Sequence", "Set", "OrderedSet", "Native", "List"});
    }

    public abstract List<String> getKeywords();

    public abstract List<String> getBuiltinVariables();

    public ModuleContentOutlinePage createOutlinePage() {
        ModuleContentOutlinePage outline = new ModuleContentOutlinePage(this.getDocumentProvider(), (ITextEditor)this, this.createModuleElementLabelProvider());
        this.addModuleParsedListener(outline);
        return outline;
    }

    public abstract IModule createModule();

    public abstract ModuleElementLabelProvider createModuleElementLabelProvider();

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void init(IEditorSite site, IEditorInput input) {
        try {
            super.init(site, input);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        AbstractModuleEditorSourceViewerConfiguration sourceViewerConfiguration = new AbstractModuleEditorSourceViewerConfiguration(this);
        this.setSourceViewerConfiguration(sourceViewerConfiguration);
        this.outlinePage = this.createOutlinePage();
        this.parseModuleJob = new Job("Parsing module"){
            protected int status;
            {
                this.status = -1;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (!AbstractModuleEditor.this.isClosed()) {
                    int textHashCode = AbstractModuleEditor.this.getText().hashCode();
                    if (this.status != textHashCode) {
                        AbstractModuleEditor.this.parseModule();
                        this.status = textHashCode;
                    }
                    this.schedule(1000L);
                }
                return Status.OK_STATUS;
            }
        };
        this.parseModuleJob.setSystem(true);
        this.parseModuleJob.schedule(1000L);
    }

    public boolean isClosed() {
        return this.getDocumentProvider() == null;
    }

    public String getText() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
    }

    public void parseModule() {
        FileEditorInput fileInputEditor = (FileEditorInput)this.getEditorInput();
        IFile file = fileInputEditor.getFile();
        IModule module = this.createModule();
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        String code = doc.get();
        code = code.replaceAll("\t", " ");
        try {
            module.reset();
            module.parse(code, new File(file.getLocation().toOSString()));
        }
        catch (Exception exception) {}
        try {
            file.deleteMarkers(PROBLEMMARKER, true, 2);
            for (ParseProblem problem : module.getParseProblems()) {
                HashMap<String, Object> attr = new HashMap<String, Object>();
                attr.put("lineNumber", new Integer(problem.getLine()));
                attr.put("message", problem.getReason());
                int markerSeverity = problem.getSeverity() == 0 ? 2 : 1;
                attr.put("severity", markerSeverity);
                MarkerUtilities.createMarker((IResource)file, attr, (String)PROBLEMMARKER);
            }
        }
        catch (CoreException coreException) {}
        if (module != null && module.getParseProblems().size() == 0) {
            this.notifyModuleParsedListeners(module);
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        if (!this.supportsDirtyTextParsing()) {
            this.parseModule();
        }
    }

    protected abstract boolean supportsHyperlinks();

    protected abstract boolean supportsDirtyTextParsing();

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void close(boolean save) {
        this.parseModuleJob.cancel();
        super.close(save);
    }

    public final List<Template> getTemplates() {
        ArrayList<Template> templates = new ArrayList<Template>();
        for (IAbstractModuleEditorTemplateContributor contributor : this.templateContributors) {
            templates.addAll(contributor.getTemplates());
        }
        return templates;
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction action = new TextOperationAction(new ResourceBundle(){

            @Override
            public Enumeration<String> getKeys() {
                return null;
            }

            @Override
            protected Object handleGetObject(String key) {
                return null;
            }
        }, "ContentAssistProposal", (ITextEditor)this, 13);
        action.setActionDefinitionId(CONTENTASSIST_PROPOSAL_ID);
        this.setAction(CONTENTASSIST_PROPOSAL_ID, (IAction)action);
        this.setActionActivationCode(CONTENTASSIST_PROPOSAL_ID, ' ', -1, 262144);
    }
}

