/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.editor;

import org.eclipse.epsilon.common.dt.editor.AbstractModuleEditor;
import org.eclipse.epsilon.common.dt.editor.AbstractModuleEditorCommentScanner;
import org.eclipse.epsilon.common.dt.editor.AbstractModuleEditorScanner;
import org.eclipse.epsilon.common.dt.editor.autoclose.AutoCloseEditStrategy;
import org.eclipse.epsilon.common.dt.editor.contentassist.AbstractModuleEditorCompletionProcessor;
import org.eclipse.epsilon.common.dt.editor.hyperlinks.AbstractModuleEditorHyperlinkDetector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;

public class AbstractModuleEditorSourceViewerConfiguration
extends SourceViewerConfiguration {
    protected AbstractModuleEditor editor = null;
    protected AbstractModuleEditorScanner scanner;
    protected AbstractModuleEditorCommentScanner commentScanner;
    AbstractModuleEditorHyperlinkDetector hyperlinkDetector = null;

    public AbstractModuleEditorSourceViewerConfiguration(AbstractModuleEditor editor) {
        this.editor = editor;
        this.scanner = new AbstractModuleEditorScanner(editor);
        this.commentScanner = new AbstractModuleEditorCommentScanner();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        DefaultDamagerRepairer commentDR = new DefaultDamagerRepairer((ITokenScanner)this.commentScanner);
        reconciler.setDamager((IPresentationDamager)commentDR, "__comment");
        reconciler.setRepairer((IPresentationRepairer)commentDR, "__comment");
        return reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new DefaultIndentLineAutoEditStrategy(), new AutoCloseEditStrategy()};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        ITextDoubleClickStrategy clickStrat = new ITextDoubleClickStrategy(){

            public void doubleClicked(ITextViewer viewer) {
                try {
                    int caretOffset;
                    IDocument doc = viewer.getDocument();
                    int start = caretOffset = viewer.getSelectedRange().x;
                    int end = caretOffset;
                    boolean isIdentifierPart = Character.isJavaIdentifierPart(doc.getChar(start));
                    if (isIdentifierPart) {
                        while (Character.isJavaIdentifierPart(doc.getChar(start))) {
                            --start;
                        }
                        while (Character.isJavaIdentifierPart(doc.getChar(end))) {
                            ++end;
                        }
                    }
                    viewer.setSelectedRange(start + 1, end - start - 1);
                }
                catch (BadLocationException badLocationException) {}
            }
        };
        return clickStrat;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        return new MultipleHyperlinkPresenter(new RGB(0, 0, 255));
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (!this.editor.supportsHyperlinks()) {
            return null;
        }
        if (this.hyperlinkDetector == null) {
            this.hyperlinkDetector = new AbstractModuleEditorHyperlinkDetector();
            this.editor.addModuleParsedListener(this.hyperlinkDetector);
        }
        return new IHyperlinkDetector[]{this.hyperlinkDetector};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistance = new ContentAssistant();
        assistance.setContentAssistProcessor((IContentAssistProcessor)new AbstractModuleEditorCompletionProcessor(this.editor), "__dftl_partition_content_type");
        assistance.enableAutoActivation(true);
        assistance.setAutoActivationDelay(500);
        assistance.setProposalPopupOrientation(10);
        return assistance;
    }
}

