/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.editor.autoclose;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.common.dt.editor.autoclose.AutoCloseAction;
import org.eclipse.epsilon.common.dt.editor.autoclose.AutoCloseCandidate;
import org.eclipse.epsilon.common.dt.editor.autoclose.AutoClosePair;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;

public class AutoCloseEditStrategy
implements IAutoEditStrategy {
    protected List<AutoClosePair> autoClosePairs = new ArrayList<AutoClosePair>();
    protected AutoCloseAction lastAutoCloseAction = AutoCloseAction.NoAutoCloseAction;

    public AutoCloseEditStrategy() {
        this.autoClosePairs.add(new AutoClosePair('\"', '\"'));
        this.autoClosePairs.add(new AutoClosePair('\'', '\''));
        this.autoClosePairs.add(new AutoClosePair('(', ')'));
        this.autoClosePairs.add(new AutoClosePair('{', '}'));
        this.autoClosePairs.add(new AutoClosePair('[', ']'));
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        AutoCloseCandidate autoCloseCandidate = new AutoCloseCandidate(document, command);
        AutoCloseAction autoCloseAction = AutoCloseAction.NoAutoCloseAction;
        if (autoCloseCandidate.isBackspace() && this.lastAutoCloseAction != AutoCloseAction.NoAutoCloseAction && this.lastAutoCloseAction.getOffset() == command.offset) {
            command.text = "";
            command.length = 2;
            command.shiftsCaret = false;
        } else if (autoCloseCandidate.isSingleChar() && !Character.isJavaIdentifierPart(autoCloseCandidate.getNextChar())) {
            char ch = autoCloseCandidate.getChar();
            for (AutoClosePair pair : this.autoClosePairs) {
                if (pair.getLeft() != ch && pair.getRight() != ch) continue;
                if (pair.getRight() == ch && this.lastAutoCloseAction.matches(pair, command.offset)) {
                    autoCloseCandidate.ignore();
                    break;
                }
                if (pair.getLeft() != ch || !pair.isDifferent() && !autoCloseCandidate.evenInCurrentLine(ch) || !Character.isWhitespace(autoCloseCandidate.getNextChar())) break;
                autoCloseAction = autoCloseCandidate.close(pair);
                break;
            }
        }
        this.lastAutoCloseAction = autoCloseAction;
    }
}

