/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.editor.contentassist;

import java.util.List;
import org.eclipse.epsilon.common.dt.EpsilonCommonsPlugin;
import org.eclipse.epsilon.common.dt.editor.AbstractModuleEditor;
import org.eclipse.epsilon.common.dt.editor.contentassist.AbstractModuleEditorContentType;
import org.eclipse.epsilon.common.dt.editor.contentassist.TemplateWithImage;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

public class AbstractModuleEditorCompletionProcessor
extends TemplateCompletionProcessor {
    IRegion region = null;
    ITextViewer viewer = null;
    AbstractModuleEditor editor = null;
    Image templateImage = EpsilonCommonsPlugin.createImage("icons/template.gif");

    public AbstractModuleEditorCompletionProcessor(AbstractModuleEditor editor) {
        this.editor = editor;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        this.region = region;
        this.viewer = viewer;
        return AbstractModuleEditorContentType.INSTANCE;
    }

    protected int getIndent() {
        int indent = 0;
        try {
            int lineNumber = this.viewer.getDocument().getLineOfOffset(this.region.getOffset());
            IRegion lineInfo = this.viewer.getDocument().getLineInformation(lineNumber);
            String line = this.viewer.getDocument().get(lineInfo.getOffset(), this.region.getOffset() - lineInfo.getOffset());
            char[] cArray = line.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c == '\t') {
                    ++indent;
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {}
        return indent;
    }

    protected Image getImage(Template template) {
        if (template instanceof TemplateWithImage) {
            return ((TemplateWithImage)template).getImage();
        }
        return this.templateImage;
    }

    protected Template[] getTemplates(String contextTypeId) {
        List<Template> templates = this.editor.getTemplates();
        Template[] indented = new Template[templates.size()];
        int loopCount = 0;
        for (Template template : templates) {
            this.indentTemplate(template);
            indented[loopCount] = template;
            ++loopCount;
        }
        return indented;
    }

    protected void indentTemplate(Template original) {
        original.setPattern(this.addIndent(original.getPattern(), this.getIndent()));
    }

    protected String addIndent(String text, int indent) {
        String[] parts;
        String tabs = "";
        int i = 0;
        while (i < indent) {
            tabs = String.valueOf(tabs) + "\t";
            ++i;
        }
        int loopCount = 0;
        String indented = "";
        String[] stringArray = parts = text.split("\r\n");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            indented = loopCount == 0 ? line : String.valueOf(indented) + tabs + line;
            if (loopCount < parts.length - 1) {
                indented = String.valueOf(indented) + "\r\n";
            }
            ++loopCount;
            ++n2;
        }
        return indented;
    }
}

