/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.editor.hyperlinks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.epsilon.common.dt.editor.AbstractModuleEditor;
import org.eclipse.epsilon.common.dt.editor.IModuleParseListener;
import org.eclipse.epsilon.common.dt.editor.hyperlinks.ASTHyperlink;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.ArrayUtil;
import org.eclipse.epsilon.eol.EolOperation;
import org.eclipse.epsilon.eol.IEolLibraryModule;
import org.eclipse.epsilon.eol.util.EolParserUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;

public class AbstractModuleEditorHyperlinkDetector
implements IHyperlinkDetector,
IModuleParseListener {
    protected AbstractModuleEditor editor;
    protected HashMap<AST, IRegion> astRegions = new HashMap();
    protected IEolLibraryModule module = null;

    public List<IHyperlink> createHyperlinks(AST ast) {
        AST operationAst;
        EolOperation operation;
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>();
        for (Object op : this.module.getOperations()) {
            operation = (EolOperation)op;
            if (!operation.getName().equals(ast.getText()) || operation.getFormalParameters().size() != ast.getFirstChild().getChildren().size()) continue;
            operationAst = operation.getAst();
            hyperlinks.add(new ASTHyperlink(this.astRegions.get(ast), operationAst, operation.toString()));
        }
        if (hyperlinks.isEmpty()) {
            for (Object op : this.module.getOperations()) {
                operation = (EolOperation)op;
                if (!operation.getName().equals(ast.getText())) continue;
                operationAst = operation.getAst();
                hyperlinks.add(new ASTHyperlink(this.astRegions.get(ast), operationAst, operation.toString()));
            }
        }
        return hyperlinks;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        for (AST ast : this.astRegions.keySet()) {
            IHyperlink[] hyperlinks;
            IRegion candidateRegion = this.astRegions.get(ast);
            if (region.getOffset() > candidateRegion.getOffset() + candidateRegion.getLength() || region.getOffset() < candidateRegion.getOffset() || (hyperlinks = (IHyperlink[])new ArrayUtil().toArray(this.createHyperlinks(ast), IHyperlink.class)).length <= 0) continue;
            return hyperlinks;
        }
        return null;
    }

    @Override
    public void moduleParsed(AbstractModuleEditor editor, IModule module) {
        this.astRegions.clear();
        this.editor = editor;
        this.module = (IEolLibraryModule)module;
        this.findInterestingASTs(module.getAst());
    }

    protected void findInterestingASTs(AST ast) {
        if (ast == null) {
            return;
        }
        IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        if (EolParserUtil.isOperationCall((AST)ast)) {
            try {
                int linkOffset = doc.getLineOffset(ast.getLine() - 1) + ast.getColumn();
                this.astRegions.put(ast, (IRegion)new Region(linkOffset, ast.getText().length()));
            }
            catch (BadLocationException badLocationException) {}
        }
        for (Object child : ast.getChildren()) {
            if (!(child instanceof AST)) continue;
            this.findInterestingASTs((AST)child);
        }
    }
}

