/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.editor.outline;

import org.eclipse.epsilon.common.dt.EpsilonCommonsPlugin;
import org.eclipse.epsilon.common.dt.editor.AbstractModuleEditor;
import org.eclipse.epsilon.common.dt.editor.IModuleParseListener;
import org.eclipse.epsilon.common.dt.editor.outline.AlphabeticalSorter;
import org.eclipse.epsilon.common.dt.editor.outline.ModuleContentProvider;
import org.eclipse.epsilon.common.dt.editor.outline.ModuleElementLabelProvider;
import org.eclipse.epsilon.common.dt.util.EclipseUtil;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.util.ReflectionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class ModuleContentOutlinePage
extends ContentOutlinePage
implements IModuleParseListener {
    protected IDocumentProvider documentProvider;
    protected IModule module;
    protected ITextEditor editor;
    protected ModuleElementLabelProvider labelProvider;
    protected ModuleContentOutlinePage thiz;
    protected Action linkWithEditorAction;

    public ModuleContentOutlinePage(IDocumentProvider documentProvider, ITextEditor editor, ModuleElementLabelProvider labelProvider) {
        this.documentProvider = documentProvider;
        this.editor = editor;
        this.labelProvider = labelProvider;
        this.addSelectionChangedListener((ISelectionChangedListener)this);
        this.thiz = this;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)new ModuleContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        IToolBarManager toolbarManager = this.getSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)new AlphabeticallySortAction());
        this.linkWithEditorAction = new LinkWithEditorAction();
        toolbarManager.add((IAction)this.linkWithEditorAction);
    }

    public boolean isReady() {
        return this.notDisplayed() || this.getTreeViewer() != null;
    }

    private boolean notDisplayed() {
        return this.getControl() == null || !this.getControl().isVisible();
    }

    public AST toAst(Object o) {
        return (AST)o;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.linkWithEditorAction.isChecked()) {
            return;
        }
        ModuleElement element = (ModuleElement)((IStructuredSelection)event.getSelection()).getFirstElement();
        if (element == null || element.getAst() == null) {
            return;
        }
        AST firstConcreteChild = AstUtil.getFirstConcreteChild((AST)element.getAst());
        try {
            EclipseUtil.openEditorAt(firstConcreteChild.getFile(), firstConcreteChild.getLine(), firstConcreteChild.getColumn(), true);
        }
        catch (Exception exception) {}
    }

    public IModule getModule() {
        return this.module;
    }

    public void setModule(IModule module) {
        this.module = module;
    }

    @Override
    public void moduleParsed(AbstractModuleEditor editor, final IModule module) {
        if (this.getSite() != null) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ModuleContentOutlinePage.this.getTreeViewer() != null) {
                        ModuleContentOutlinePage.this.getTreeViewer().setInput((Object)module);
                    }
                }
            });
        }
    }

    class AlphabeticallySortAction
    extends Action {
        AlphabeticalSorter alphabeticalSorter;
        TreeViewer treeViewer;

        public AlphabeticallySortAction() {
            super(null, 2);
            this.alphabeticalSorter = null;
            this.treeViewer = null;
            this.setImageDescriptor(EpsilonCommonsPlugin.getImageDescriptor("icons/alphabeticalSorter.gif"));
            this.setDescription("Sorts the contents of the view alphabetically");
            this.alphabeticalSorter = new AlphabeticalSorter();
            this.treeViewer = (TreeViewer)ReflectionUtil.getFieldValue((Object)ModuleContentOutlinePage.this.thiz, (String)"treeViewer");
        }

        public void run() {
            if (this.isChecked()) {
                this.treeViewer.setSorter((ViewerSorter)this.alphabeticalSorter);
            } else {
                this.treeViewer.setSorter(null);
            }
        }
    }

    class LinkWithEditorAction
    extends Action {
        public LinkWithEditorAction() {
            super("Link with editor", 2);
            this.setDescription("Links the outline view with the editor");
            this.setImageDescriptor(EpsilonCommonsPlugin.getImageDescriptor("icons/linkwitheditor.gif"));
            this.setChecked(true);
        }
    }
}

