/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.nature;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epsilon.common.dt.util.LogUtil;

public abstract class ResourceBuildingIncrementalProjectBuilder
extends IncrementalProjectBuilder {
    private void refreshProject(IProgressMonitor monitor) {
        try {
            this.getProject().refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            this.reportError(e);
            e.printStackTrace();
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        this.refreshProject(monitor);
        return null;
    }

    private void incrementalBuild(IResourceDelta delta, final IProgressMonitor monitor) {
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    if (delta.getKind() == 1 || delta.getKind() == 4) {
                        ResourceBuildingIncrementalProjectBuilder.this.buildResource(delta.getResource(), monitor);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            this.reportError(e);
        }
    }

    private void fullBuild(final IProgressMonitor monitor) {
        try {
            this.getProject().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    ResourceBuildingIncrementalProjectBuilder.this.buildResource(resource, monitor);
                    return true;
                }
            });
        }
        catch (CoreException e) {
            this.reportError(e);
        }
    }

    protected void reportError(CoreException e) {
        LogUtil.log("Error encountered during build.", (Exception)((Object)e));
    }

    protected abstract void buildResource(IResource var1, IProgressMonitor var2);
}

