/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.tools;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epsilon.common.dt.EpsilonCommonsPlugin;
import org.eclipse.epsilon.common.dt.editor.AbstractModuleEditor;
import org.eclipse.epsilon.common.dt.launching.extensions.ToolExtension;
import org.eclipse.epsilon.common.dt.tools.ToolVariable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class ToolsView
extends ViewPart {
    private TreeViewer viewer;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)new InsertToolVariableDeclarationAction());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected class InsertToolVariableDeclarationAction
    extends Action {
        public InsertToolVariableDeclarationAction() {
            this.setText("Insert tool variable declaration");
            this.setImageDescriptor(EpsilonCommonsPlugin.getImageDescriptor("icons/insert.png"));
        }

        public void run() {
            Object selection;
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor instanceof AbstractModuleEditor && (selection = ((IStructuredSelection)ToolsView.this.viewer.getSelection()).getFirstElement()) instanceof ToolVariable) {
                Class toolClass = ((ToolVariable)selection).getClazz();
                String toolVariableDeclaration = "var " + ((ToolVariable)selection).getName() + " : new Native(\"" + toolClass.getCanonicalName() + "\");";
                ((AbstractModuleEditor)editor).insertText(toolVariableDeclaration);
            }
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        ViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<ToolVariable> toolClasses = new ArrayList<ToolVariable>();
            for (ToolExtension toolExtension : ToolExtension.getInstances()) {
                Bundle bundle = Platform.getBundle((String)toolExtension.getConfigurationElement().getContributor().getName());
                try {
                    ToolVariable toolVariable = new ToolVariable();
                    toolVariable.setClazz(bundle.loadClass(toolExtension.getClazz()));
                    toolVariable.setName(toolExtension.getDefaultName());
                    toolClasses.add(toolVariable);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            return toolClasses.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ToolVariable) {
                Class clazz = ((ToolVariable)parentElement).getClazz();
                return this.getMethods(clazz, true);
            }
            if (parentElement instanceof Method) {
                Method method = (Method)parentElement;
                if (method.getReturnType() != Void.TYPE) {
                    return this.getMethods(method.getReturnType(), false);
                }
                return Collections.EMPTY_LIST.toArray();
            }
            return Collections.EMPTY_LIST.toArray();
        }

        protected Object[] getMethods(Class clazz, boolean declaredOnly) {
            ArrayList<Method> methods = new ArrayList<Method>();
            Method[] classMethods = declaredOnly ? clazz.getDeclaredMethods() : clazz.getMethods();
            Method[] methodArray = classMethods;
            int n = classMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if ((method.getModifiers() & 1) != 0) {
                    methods.add(method);
                }
                ++n2;
            }
            return methods.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ToolVariable) {
                return true;
            }
            if (element instanceof Method) {
                return ((Method)element).getReturnType() != Void.TYPE;
            }
            return false;
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        Image classImage = EpsilonCommonsPlugin.getImageDescriptor("icons/class.png").createImage();
        Image methodImage = EpsilonCommonsPlugin.getImageDescriptor("icons/method.gif").createImage();

        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof ToolVariable) {
                Class clazz = ((ToolVariable)obj).getClazz();
                return String.valueOf(clazz.getSimpleName()) + " (" + clazz.getCanonicalName() + ")";
            }
            Method method = (Method)obj;
            String sig = "";
            sig = String.valueOf(method.getName()) + "(";
            int loop = 0;
            Class<?>[] classArray = method.getParameterTypes();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> parameterType = classArray[n2];
                sig = String.valueOf(sig) + parameterType.getSimpleName();
                if (++loop < method.getParameterTypes().length) {
                    sig = String.valueOf(sig) + ", ";
                }
                ++n2;
            }
            sig = String.valueOf(sig) + ") : " + method.getReturnType().getSimpleName();
            return sig;
        }

        public Image getImage(Object obj) {
            if (obj instanceof ToolVariable) {
                return this.classImage;
            }
            return this.methodImage;
        }
    }
}

