/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.dt.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epsilon.common.dt.EpsilonCommonsPlugin;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EclipseUtil {
    private EclipseUtil() {
    }

    public static IFile findIFile(AST ast) {
        if (ast == null) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (ast.getFile() != null) {
            Path path = new Path(ast.getFile().getAbsolutePath());
            return workspaceRoot.getFileForLocation((IPath)path);
        }
        if (ast.getUri() != null) {
            try {
                URI fileURI = FileLocator.toFileURL((URL)ast.getUri().toURL()).toURI();
                IFile[] files = workspaceRoot.findFilesForLocationURI(fileURI);
                if (files.length > 0) {
                    return files[0];
                }
            }
            catch (Exception ex) {
                EpsilonCommonsPlugin.getDefault().logException(ex);
            }
        }
        return null;
    }

    public static String getWorkspacePath() {
        return ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toPortableString();
    }

    public static String getWorkspaceFileAbsolutePath(String workspacePath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).getLocation().toOSString();
    }

    public static void openEditorAt(AST astNode) {
        IFile file = EclipseUtil.findIFile(astNode);
        if (file != null) {
            EclipseUtil.openEditorAt(file, astNode.getLine(), astNode.getColumn(), true);
        }
    }

    public static void openEditorAt(File file, int line, int column, boolean highlightLine) {
        if (file == null) {
            return;
        }
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI())[0];
        EclipseUtil.openEditorAt(iFile, line, column, highlightLine);
    }

    public static void openEditorAt(IFile file, final int line, final int column, final boolean highlightLine) {
        if (file == null) {
            return;
        }
        final FileEditorInput fileinput = new FileEditorInput(file);
        final IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    int realLine = line;
                    if (realLine == 0) {
                        realLine = 1;
                    }
                    AbstractTextEditor editor = (AbstractTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)fileinput, desc.getId(), false);
                    IDocument doc = editor.getDocumentProvider().getDocument((Object)fileinput);
                    if (highlightLine) {
                        editor.selectAndReveal(doc.getLineOffset(realLine - 1), doc.getLineLength(realLine - 1) - 1);
                    } else {
                        editor.selectAndReveal(doc.getLineOffset(realLine - 1) + column - 1, 0);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }
}

