/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.commons.profiling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.commons.profiling.FileMarker;
import org.eclipse.epsilon.commons.profiling.Stopwatch;

public class ProfilerTarget {
    protected String name;
    protected long startTime;
    protected long globalEndTime;
    protected long internalEndTime;
    protected long aggregatedWorked;
    protected long internalWorked;
    protected List<ProfilerTarget> children;
    protected ProfilerTarget parent;
    protected String data;
    protected FileMarker fileMarker;
    protected Stopwatch globalStopwatch;
    protected Stopwatch internalStopwatch;

    public ProfilerTarget(String name, Stopwatch globalStopwatch, String data, FileMarker fileMarker) {
        this.name = name;
        this.globalStopwatch = globalStopwatch;
        this.internalStopwatch = new Stopwatch();
        this.internalStopwatch.resume();
        this.startTime = globalStopwatch.getElapsed();
        this.globalEndTime = -1L;
        this.internalEndTime = -1L;
        this.children = new ArrayList<ProfilerTarget>();
        this.data = data;
        this.fileMarker = fileMarker;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void pause() {
        this.internalStopwatch.pause();
    }

    public void resume() {
        this.internalStopwatch.resume();
    }

    public void stop() {
        this.internalStopwatch.pause();
        this.globalEndTime = this.globalStopwatch.getElapsed();
        this.internalEndTime = this.internalStopwatch.getElapsed();
        this.aggregatedWorked = this.globalEndTime - this.startTime;
        this.internalWorked = this.internalStopwatch.getElapsed();
    }

    public void addChild(ProfilerTarget child) {
        this.children.add(child);
        child.parent = this;
    }

    public List<ProfilerTarget> getChildren() {
        return this.children;
    }

    public ProfilerTarget getParent() {
        return this.parent;
    }

    public boolean isRunning() {
        return this.globalEndTime == -1L;
    }

    public long getWorked(boolean aggregate) {
        if (!aggregate) {
            if (this.isRunning()) {
                return this.internalStopwatch.getElapsed();
            }
            return this.internalWorked;
        }
        if (this.isRunning()) {
            return this.globalStopwatch.getElapsed() - this.startTime;
        }
        return this.aggregatedWorked;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public FileMarker getFileMarker() {
        return this.fileMarker;
    }

    public void setFileMarker(FileMarker fileMarker) {
        this.fileMarker = fileMarker;
    }
}

