/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.commons.profiling;

public class Stopwatch {
    protected long lastPauseTime;
    protected long startTime = System.currentTimeMillis();
    protected long pauseDuration;
    protected boolean paused = false;

    public Stopwatch() {
        this.pause();
    }

    public synchronized void pause() {
        if (!this.paused) {
            this.lastPauseTime = System.currentTimeMillis();
            this.paused = true;
        }
    }

    public synchronized void resume() {
        if (this.paused) {
            this.pauseDuration += System.currentTimeMillis() - this.lastPauseTime;
            this.paused = false;
        }
    }

    public long getElapsed() {
        if (this.paused) {
            return this.lastPauseTime - this.pauseDuration - this.startTime;
        }
        return System.currentTimeMillis() - this.pauseDuration - this.startTime;
    }
}

