/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.commons.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.commons.parse.AST;

public class AstUtil {
    public static int getChildrenCount(AST parent) {
        int count = 0;
        if (parent == null) {
            return count;
        }
        AST child = parent.getFirstChild();
        while (child != null) {
            ++count;
            child = child.getNextSibling();
        }
        return count;
    }

    public static AST getChildAt(AST parent, int index) {
        int count = 0;
        if (parent == null) {
            return null;
        }
        AST child = parent.getFirstChild();
        while (child != null) {
            if (count == index) {
                return child;
            }
            child = child.getNextSibling();
            ++count;
        }
        return null;
    }

    public static List<AST> getChildren(AST parent) {
        return AstUtil.getChildren(parent, -1);
    }

    public static List<AST> getChildrenBut(AST parent, int type) {
        ArrayList<AST> children = new ArrayList<AST>();
        AST child = parent.getFirstChild();
        while (child != null) {
            if (child.getType() != type) {
                children.add(child);
            }
            child = child.getNextSibling();
        }
        return children;
    }

    public static List<AST> getChildren(AST parent, int ... type) {
        ArrayList<AST> children = new ArrayList<AST>();
        if (parent != null) {
            AST child = parent.getFirstChild();
            while (child != null) {
                int i = 0;
                while (i < type.length) {
                    if (child.getType() == type[i] || type[i] == -1) {
                        children.add(child);
                    }
                    ++i;
                }
                child = child.getNextSibling();
            }
        }
        return children;
    }

    public static AST getChild(AST parent, int type) {
        if (parent == null) {
            return null;
        }
        AST child = parent.getFirstChild();
        while (child != null) {
            if (child.getType() == type) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static AST getFirstConcreteChild(AST parent) {
        if (parent.getLine() > 0) {
            return parent;
        }
        AST child = parent.getFirstChild();
        while (child != null) {
            AST result = AstUtil.getFirstConcreteChild(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static int getParentType(AST child) {
        if (child.getParent() == null) {
            return -1;
        }
        return child.getParent().getType();
    }
}

