/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epsilon.common.dt.EpsilonPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EolPlugin
extends AbstractUIPlugin
implements EpsilonPlugin {
    public static final String PLUGIN_ID = "org.eclipse.epsilon.eol.dt";
    public static final String EOLPROGRAM = "SOURCE.EOL";
    private static EolPlugin plugin;

    public EolPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static EolPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Image createImage(String path) {
        try {
            URL BASE_URL = EolPlugin.getDefault().getBundle().getEntry("/");
            URL url = new URL(BASE_URL, path);
            return ImageDescriptor.createFromURL((URL)url).createImage();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void logException(Exception e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getLocalizedMessage(), (Throwable)e));
    }

    class DeltaVisitor {
        public IResource resource;

        DeltaVisitor() {
        }

        public void visitDelta(IResourceDelta delta) {
            if (delta.getResource().getFileExtension() != null && delta.getResource().getFileExtension().equals("eol")) {
                this.resource = delta.getResource();
            } else {
                int i = 0;
                while (i < delta.getAffectedChildren().length) {
                    this.visitDelta(delta.getAffectedChildren()[i]);
                    ++i;
                }
            }
        }
    }

    class EolResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        public IResource resource;

        EolResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            System.out.println("Visiting: " + delta.getResource());
            if (delta.getResource().getFileExtension().equals("eol")) {
                System.out.println("Changed....");
                this.resource = delta.getResource();
            }
            int i = 0;
            while (i < delta.getAffectedChildren().length) {
                delta.getAffectedChildren()[i].accept((IResourceDeltaVisitor)this);
                ++i;
            }
            return false;
        }
    }
}

