/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.debug;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.epsilon.common.dt.util.EclipseUtil;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dt.EolPlugin;
import org.eclipse.epsilon.eol.dt.debug.EolBreakpoint;
import org.eclipse.epsilon.eol.dt.debug.EolVariable;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class DebugModelPresentation
implements IDebugModelPresentation {
    private ListenerList listeners = new ListenerList();
    private Image imgLoopVariable = EolPlugin.getImageDescriptor("/icons/variable_loop.gif").createImage();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void dispose() {
        if (this.imgLoopVariable != null) {
            this.imgLoopVariable.dispose();
            this.imgLoopVariable = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    public IEditorInput getEditorInput(Object element) {
        IFile file = this.getIFile(element);
        if (file != null) {
            return new FileEditorInput(file);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        IFile file = this.getIFile(element);
        if (file != null) {
            return IDE.getDefaultEditor((IFile)file).getId();
        }
        return null;
    }

    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        EolVariable v;
        if (element instanceof EolVariable && (v = (EolVariable)((Object)element)).isLoop()) {
            return this.imgLoopVariable;
        }
        return null;
    }

    public String getText(Object element) {
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    private IFile getIFile(Object element) {
        EolBreakpoint eolB;
        IResource resource;
        IFile file = null;
        if (element instanceof EolBreakpoint && (resource = (eolB = (EolBreakpoint)((Object)element)).getMarker().getResource()) instanceof IFile) {
            file = (IFile)resource;
        }
        if (element instanceof AST) {
            file = EclipseUtil.findIFile((AST)((AST)element));
        }
        return file;
    }
}

