/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.debug;

import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dt.debug.EolDebugElement;
import org.eclipse.epsilon.eol.dt.debug.EolDebugTarget;
import org.eclipse.epsilon.eol.dt.debug.EolStackFrame;
import org.eclipse.epsilon.eol.execute.context.Frame;

public class EolThread
extends EolDebugElement
implements IThread {
    public EolThread(IDebugTarget target) {
        super(target);
    }

    public boolean canResume() {
        return this.getDebugTarget().canResume();
    }

    public boolean canSuspend() {
        return this.getDebugTarget().canSuspend();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended() && !this.isTerminated();
    }

    public boolean canStepOver() {
        return true;
    }

    public boolean canStepReturn() {
        return true;
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
        ((EolDebugTarget)this.getDebugTarget()).stepInto();
    }

    public void stepOver() throws DebugException {
        ((EolDebugTarget)this.getDebugTarget()).stepOver();
    }

    public void stepReturn() throws DebugException {
        ((EolDebugTarget)this.getDebugTarget()).stepReturn();
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        List frames = ((EolDebugTarget)this.getDebugTarget()).getModule().getContext().getFrameStack().getFrames();
        IStackFrame[] stackFrames = new IStackFrame[frames.size()];
        int i = 0;
        for (Frame frame : frames) {
            stackFrames[i] = new EolStackFrame(this, frame, this.getStackFrameName(i, frame));
            ++i;
        }
        return stackFrames;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.getStackFrames().length > 0;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        return this.getStackFrames()[0];
    }

    public String getName() throws DebugException {
        return this.getDebugTarget().getName();
    }

    public IBreakpoint[] getBreakpoints() {
        return null;
    }

    private String getStackFrameName(int position, Frame frame) {
        AST entryPoint = frame.getEntryPoint();
        if (entryPoint != null) {
            StringBuilder builder = new StringBuilder();
            if (entryPoint.getType() == 28) {
                builder.append(entryPoint.getFirstChild().toString());
            } else {
                builder.append(entryPoint.toString());
            }
            builder.append(" at ");
            builder.append(entryPoint.getUri().toString());
            return builder.toString();
        }
        return "globals";
    }
}

