/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.common.dt.editor.AbstractModuleEditor;
import org.eclipse.epsilon.common.dt.editor.IModuleParseListener;
import org.eclipse.epsilon.common.dt.editor.contentassist.IAbstractModuleEditorTemplateContributor;
import org.eclipse.epsilon.common.dt.editor.contentassist.TemplateWithImage;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.eol.EolFormalParameter;
import org.eclipse.epsilon.eol.EolOperation;
import org.eclipse.epsilon.eol.IEolLibraryModule;
import org.eclipse.epsilon.eol.dt.EolPlugin;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.graphics.Image;

public class EolEditorOperationTemplateContributor
implements IAbstractModuleEditorTemplateContributor,
IModuleParseListener {
    protected List<Template> templates = new ArrayList<Template>();
    Image operationImage = EolPlugin.getDefault().createImage("icons/operation.gif");

    public void moduleParsed(AbstractModuleEditor editor, IModule module) {
        this.templates.clear();
        if (module == null || !(module instanceof IEolLibraryModule)) {
            return;
        }
        for (EolOperation op : ((IEolLibraryModule)module).getOperations()) {
            this.templates.add(this.createTemplate(op));
        }
    }

    public List<Template> getTemplates() {
        return this.templates;
    }

    protected Template createTemplate(EolOperation op) {
        String call = op.getName();
        call = String.valueOf(call) + "(";
        Iterator it = op.getFormalParameters().iterator();
        while (it.hasNext()) {
            EolFormalParameter fp = (EolFormalParameter)it.next();
            call = String.valueOf(call) + "${" + fp.getName() + "}";
            if (!it.hasNext()) continue;
            call = String.valueOf(call) + ", ";
        }
        call = String.valueOf(call) + ")";
        return new TemplateWithImage(op.toString(), "operation", "", call, false, this.operationImage);
    }
}

