/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.launching;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.epsilon.common.dt.console.EpsilonConsole;
import org.eclipse.epsilon.common.dt.launching.EclipseExecutionController;
import org.eclipse.epsilon.common.dt.launching.extensions.ModelTypeExtension;
import org.eclipse.epsilon.common.dt.util.EclipseUtil;
import org.eclipse.epsilon.common.dt.util.LogUtil;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.eol.dt.ExtensionPointToolNativeTypeDelegate;
import org.eclipse.epsilon.eol.dt.userinput.JFaceUserInput;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinter;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.userinput.IUserInput;
import org.eclipse.ui.PlatformUI;

public class EclipseContextManager {
    public static void teardown(IEolContext context, IProgressMonitor progressMonitor) {
        context.getModelRepository().dispose();
        context.getExecutorFactory().getExecutionController().dispose();
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, progressMonitor);
        }
        catch (CoreException e) {
            LogUtil.log((Exception)((Object)e));
        }
    }

    public static void teardown(IEolContext context) {
        context.getModelRepository().dispose();
        context.getExecutorFactory().getExecutionController().dispose();
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            LogUtil.log((Exception)((Object)e));
        }
    }

    public static void setup(IEolContext context) {
        EclipseContextManager.loadPrettyPrinters(context);
        EclipseContextManager.loadIo(context);
        context.getNativeTypeDelegates().add(new ExtensionPointToolNativeTypeDelegate());
    }

    public static void setup(IEolContext context, IProgressMonitor progressMonitor) {
        EclipseExecutionController executionController = new EclipseExecutionController(progressMonitor);
        context.getExecutorFactory().setExecutionController((ExecutionController)executionController);
        EclipseContextManager.setup(context);
    }

    public static void setup(IEolContext context, ILaunchConfiguration configuration, IProgressMonitor progressMonitor, ILaunch launch) throws EolRuntimeException {
        EclipseContextManager.setup(context, configuration, progressMonitor, launch, true);
    }

    public static void setup(IEolContext context, ILaunchConfiguration configuration, IProgressMonitor progressMonitor, ILaunch launch, boolean loadModels) throws EolRuntimeException {
        if (loadModels) {
            EclipseContextManager.loadModels(context, configuration, progressMonitor);
        }
        EclipseContextManager.setup(context, progressMonitor);
    }

    private static void loadIo(IEolContext context) {
        if (PlatformUI.isWorkbenchRunning()) {
            context.setOutputStream(EpsilonConsole.getInstance().getDebugStream());
            context.setErrorStream(EpsilonConsole.getInstance().getErrorStream());
            context.setWarningStream(EpsilonConsole.getInstance().getWarningStream());
        }
        context.setUserInput((IUserInput)new JFaceUserInput(context.getPrettyPrinterManager()));
    }

    private static void loadPrettyPrinters(IEolContext context) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.epsilon.common.dt.prettyPrinter");
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement configurationElement = configurationElements[i];
            try {
                PrettyPrinter prettyPrinter = (PrettyPrinter)configurationElement.createExecutableExtension("class");
                context.getPrettyPrinterManager().addPrettyPrinter(prettyPrinter);
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    private static void loadModels(IEolContext context, ILaunchConfiguration configuration, IProgressMonitor progressMonitor) {
        String subtask = "Loading models";
        progressMonitor.subTask(subtask);
        progressMonitor.beginTask(subtask, 100);
        List models = null;
        try {
            models = configuration.getAttribute("models", new ArrayList());
        }
        catch (CoreException e1) {
            e1.printStackTrace(context.getErrorStream());
        }
        ListIterator li = models.listIterator();
        while (li.hasNext()) {
            String modelDescriptor = li.next().toString();
            StringProperties properties = new StringProperties();
            properties.load(modelDescriptor);
            IModel model = null;
            try {
                model = ModelTypeExtension.forType((String)properties.getProperty("type")).createModel();
                model.load(properties, EclipseUtil.getWorkspacePath());
                context.getModelRepository().addModel(model);
            }
            catch (Exception e) {
                e.printStackTrace();
                EpsilonConsole.getInstance().getErrorStream().print(e.toString());
                LogUtil.log((Exception)e);
            }
        }
        progressMonitor.done();
    }
}

