/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dt.launching.contextual;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.epsilon.common.dt.util.LogUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class EolLaunchShortcut
implements ILaunchShortcut2 {
    protected void launch(IFile file, String mode) {
        try {
            ILaunchConfiguration[] launchConfigurations = this.getLaunchConfigurations(file);
            if (launchConfigurations.length == 0) {
                ILaunchConfigurationWorkingCopy configuration = this.getLaunchConfigurationType().newInstance(file.getParent(), DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(file.getName())).getWorkingCopy();
                configuration.setAttribute("source", file.getFullPath().toPortableString());
                configuration.doSave();
                String groupId = mode.equals("debug") ? "org.eclipse.debug.ui.launchGroup.debug" : "org.eclipse.debug.ui.launchGroup.run";
                DebugUITools.openLaunchConfigurationDialog((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)configuration, (String)groupId, null);
            } else {
                launchConfigurations[0].launch(mode, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    protected ILaunchConfigurationType getLaunchConfigurationType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(this.getLaunchConfigurationTypeId());
    }

    protected String getLaunchConfigurationTypeId() {
        return "org.epsilon.eol.eclipse.dt.launching.EolLaunchConfigurationDelegate";
    }

    protected ILaunchConfiguration[] getLaunchConfigurations(IFile file) {
        try {
            ILaunchConfigurationType type = this.getLaunchConfigurationType();
            ArrayList<ILaunchConfiguration> launchConfigurationsList = new ArrayList<ILaunchConfiguration>();
            Object object = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            int n = ((ILaunchConfiguration[])object).length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = object[n2];
                Path launchConfigutationPath = new Path(config.getAttribute("source", ""));
                if (file.getFullPath().equals((Object)launchConfigutationPath)) {
                    launchConfigurationsList.add(config);
                }
                ++n2;
            }
            ILaunchConfiguration[] launchConfigurations = new ILaunchConfiguration[launchConfigurationsList.size()];
            int i = 0;
            object = launchConfigurationsList.iterator();
            while (object.hasNext()) {
                ILaunchConfiguration launchConfiguration;
                launchConfigurations[i] = launchConfiguration = (ILaunchConfiguration)object.next();
                ++i;
            }
            return launchConfigurations;
        }
        catch (CoreException e) {
            LogUtil.log((Exception)((Object)e));
            return null;
        }
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        Object o;
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            return this.getLaunchConfigurations((IFile)o);
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        if (editorpart.getEditorInput() instanceof IFileEditorInput) {
            return this.getLaunchConfigurations(((IFileEditorInput)editorpart.getEditorInput()).getFile());
        }
        return null;
    }

    public void launch(ISelection selection, String mode) {
        Object o;
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.launch((IFile)o, mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            this.launch(((IFileEditorInput)editor.getEditorInput()).getFile(), mode);
        }
    }

    public IResource getLaunchableResource(ISelection selection) {
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return null;
    }
}

