/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.commons.module.AbstractModuleElement;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.EolFormalParameter;
import org.eclipse.epsilon.eol.EolFormalParameterList;
import org.eclipse.epsilon.eol.annotations.EolAnnotationsUtil;
import org.eclipse.epsilon.eol.annotations.IEolAnnotation;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolMap;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eol.types.EolType;

public class EolOperation
extends AbstractModuleElement {
    private String name = "";
    private AST contextTypeAst;
    private EolType contextType;
    private AST returnTypeAst;
    private EolType returnType;
    private AST body;
    private EolFormalParameterList formalParameters = null;
    private AST ast;
    protected EolMap cache;

    public void clearCache() {
        if (this.isCached()) {
            this.cache.clear();
        }
        this.returnType = null;
        this.contextType = null;
        this.formalParameters.clearCache();
    }

    public EolOperation() {
    }

    public EolOperation(AST ast) {
        this.parse(ast);
    }

    public void parse(AST ast) {
        AST nameAst = null;
        if (ast.getFirstChild().getType() == 63) {
            this.contextTypeAst = ast.getFirstChild();
            nameAst = this.contextTypeAst.getNextSibling();
        } else {
            nameAst = ast.getFirstChild();
        }
        AST paramListAst = null;
        AST returnAst = null;
        AST bodyAst = null;
        if (nameAst.getNextSibling().getType() == 25) {
            paramListAst = nameAst.getNextSibling();
        }
        if (paramListAst != null) {
            if (paramListAst.getNextSibling().getType() == 63) {
                returnAst = paramListAst.getNextSibling();
                bodyAst = returnAst.getNextSibling();
            } else {
                bodyAst = paramListAst.getNextSibling();
            }
        } else if (nameAst.getNextSibling().getType() == 63) {
            returnAst = nameAst.getNextSibling();
            bodyAst = returnAst.getNextSibling();
        } else {
            bodyAst = nameAst.getNextSibling();
        }
        this.ast = ast;
        this.body = bodyAst;
        this.name = nameAst.getText();
        this.returnTypeAst = returnAst;
        this.formalParameters = new EolFormalParameterList(paramListAst);
    }

    public AST getAst() {
        return this.ast;
    }

    public void setAst(AST ast) {
        this.ast = ast;
    }

    public AST getBody() {
        return this.body;
    }

    public void setBody(AST body) {
        this.body = body;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EolFormalParameterList getFormalParameters() {
        return this.formalParameters;
    }

    public String toString() {
        String contextTypeName = "";
        String returnTypeName = "";
        if (this.contextTypeAst != null) {
            contextTypeName = " - " + this.contextTypeAst.getText();
        }
        if (this.returnTypeAst != null) {
            returnTypeName = " : " + this.returnTypeAst.getText();
        }
        return String.valueOf(this.name) + "(" + this.formalParameters + ")" + returnTypeName + contextTypeName;
    }

    public void setFormalParameters(EolFormalParameterList formalParameters) {
        this.formalParameters = formalParameters;
    }

    public synchronized boolean isCached() {
        if (EolAnnotationsUtil.hasAnnotation(this.ast, "cached") && this.formalParameters.isEmpty()) {
            if (this.cache == null) {
                this.cache = new EolMap();
            }
            return true;
        }
        return false;
    }

    public Object execute(Object self, List parameterValues, IEolContext context) throws EolRuntimeException {
        return this.execute(self, parameterValues, context, true);
    }

    public Object execute(Object self, List parameterValues, IEolContext context, boolean inNewStackFrame) throws EolRuntimeException {
        if (this.isCached() && this.cache.containsKey(self)) {
            return this.cache.get(self);
        }
        FrameStack scope = context.getFrameStack();
        if (inNewStackFrame) {
            scope.enter(FrameType.PROTECTED, this.getAst());
            scope.put(Variable.createReadOnlyVariable("self", self));
        }
        int i = 0;
        while (i < this.formalParameters.size()) {
            EolFormalParameter fp = (EolFormalParameter)this.formalParameters.get(i);
            scope.put(new Variable(fp.getName(), parameterValues.get(i), fp.getType(context)));
            ++i;
        }
        this.evaluatePreConditions(context);
        Object result = null;
        result = Return.getValue(this.executeBody(context));
        this.checkResultType(result, context);
        this.evaluatePostConditions(context, result);
        if (inNewStackFrame) {
            scope.leave(this.getAst());
        }
        if (this.isCached() && !this.cache.containsKey(self)) {
            this.cache.put(self, result);
        }
        return result;
    }

    protected Object executeBody(IEolContext context) throws EolRuntimeException {
        return context.getExecutorFactory().executeAST(this.getBody(), context);
    }

    protected void evaluatePreConditions(IEolContext context) throws EolRuntimeException {
        for (IEolAnnotation annotation : EolAnnotationsUtil.getAnnotations(this.ast, "pre")) {
            Object satisfied = annotation.getValue(context);
            if (satisfied instanceof Boolean) {
                if (((Boolean)satisfied).booleanValue()) continue;
                throw new EolRuntimeException("Pre-condition not satisfied", annotation.getAst());
            }
            throw new EolIllegalReturnException("Boolean", satisfied, annotation.getAst(), context);
        }
    }

    protected void checkResultType(Object result, IEolContext context) throws EolRuntimeException {
        if (this.returnTypeAst != null && result != null) {
            if (this.returnType == null) {
                this.returnType = (EolType)context.getExecutorFactory().executeAST(this.returnTypeAst, context);
            }
            if (!this.returnType.isKind(result)) {
                throw new EolRuntimeException(String.valueOf(this.name) + " is expected to return a " + this.returnType.getName() + ", but returned a " + result.getClass());
            }
        }
    }

    protected void evaluatePostConditions(IEolContext context, Object result) throws EolRuntimeException {
        context.getFrameStack().put(Variable.createReadOnlyVariable("_result", result));
        for (IEolAnnotation annotation : EolAnnotationsUtil.getAnnotations(this.ast, "post")) {
            Object satisfied = annotation.getValue(context);
            if (satisfied instanceof Boolean) {
                if (((Boolean)satisfied).booleanValue()) continue;
                throw new EolRuntimeException("Post-condition not satisfied", annotation.getAst());
            }
            throw new EolIllegalReturnException("Boolean", satisfied, annotation.getAst(), context);
        }
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public EolType getReturnType(IEolContext context) throws EolRuntimeException {
        if (this.returnType == null) {
            this.returnType = this.returnTypeAst != null ? (EolType)context.getExecutorFactory().executeAST(this.returnTypeAst, context) : EolAnyType.Instance;
        }
        return this.returnType;
    }

    public EolType getContextType(IEolContext context) throws EolRuntimeException {
        if (this.contextType == null) {
            this.contextType = this.contextTypeAst != null ? (EolType)context.getExecutorFactory().executeAST(this.contextTypeAst, context) : EolNoType.Instance;
        }
        return this.contextType;
    }
}

