/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom;

import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.util.AstUtil;
import org.eclipse.epsilon.eol.dom.AndOperatorExpression;
import org.eclipse.epsilon.eol.dom.AssignmentStatement;
import org.eclipse.epsilon.eol.dom.BinaryOperatorExpression;
import org.eclipse.epsilon.eol.dom.BooleanExpression;
import org.eclipse.epsilon.eol.dom.BreakAllStatement;
import org.eclipse.epsilon.eol.dom.BreakStatement;
import org.eclipse.epsilon.eol.dom.CaseDefaultStatement;
import org.eclipse.epsilon.eol.dom.CaseExpressionStatement;
import org.eclipse.epsilon.eol.dom.CaseStatement;
import org.eclipse.epsilon.eol.dom.ContinueStatement;
import org.eclipse.epsilon.eol.dom.DeleteStatement;
import org.eclipse.epsilon.eol.dom.DivOperatorExpression;
import org.eclipse.epsilon.eol.dom.DomElement;
import org.eclipse.epsilon.eol.dom.EnumerationLiteralExpression;
import org.eclipse.epsilon.eol.dom.EqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.ExpressionStatement;
import org.eclipse.epsilon.eol.dom.FeatureCallExpression;
import org.eclipse.epsilon.eol.dom.ForStatement;
import org.eclipse.epsilon.eol.dom.IfStatement;
import org.eclipse.epsilon.eol.dom.ImpliesOperatorExpression;
import org.eclipse.epsilon.eol.dom.Import;
import org.eclipse.epsilon.eol.dom.IntegerExpression;
import org.eclipse.epsilon.eol.dom.LessThanOperatorExpression;
import org.eclipse.epsilon.eol.dom.LessThanOrEqualOperatorExpression;
import org.eclipse.epsilon.eol.dom.MethodCallExpression;
import org.eclipse.epsilon.eol.dom.MinusOperatorExpression;
import org.eclipse.epsilon.eol.dom.MoreThanOperatorExpression;
import org.eclipse.epsilon.eol.dom.MoreThanOrEqualOperatorExpression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.NegativeOperatorExpression;
import org.eclipse.epsilon.eol.dom.NotEqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.NotOperatorExpression;
import org.eclipse.epsilon.eol.dom.OperationDefinition;
import org.eclipse.epsilon.eol.dom.OperatorExpression;
import org.eclipse.epsilon.eol.dom.OrOperatorExpression;
import org.eclipse.epsilon.eol.dom.PlusOperatorExpression;
import org.eclipse.epsilon.eol.dom.Program;
import org.eclipse.epsilon.eol.dom.PropertyCallExpression;
import org.eclipse.epsilon.eol.dom.RealExpression;
import org.eclipse.epsilon.eol.dom.ReturnStatement;
import org.eclipse.epsilon.eol.dom.StarOperatorExpression;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.dom.StringExpression;
import org.eclipse.epsilon.eol.dom.SwitchStatement;
import org.eclipse.epsilon.eol.dom.UnaryOperatorExpression;
import org.eclipse.epsilon.eol.dom.VariableDeclarationExpression;
import org.eclipse.epsilon.eol.dom.WhileStatement;
import org.eclipse.epsilon.eol.dom.XorOperatorExpression;

public class DomElementFactory {
    public DomElement createDomElement(AST ast, DomElement container) {
        DomElement e = null;
        switch (ast.getType()) {
            case 60: {
                e = this.createProgram(ast);
                break;
            }
            case 30: {
                e = this.createForStatement(ast);
                break;
            }
            case 24: {
                e = this.createVariableDeclarationExpression(ast);
                break;
            }
            case 65: {
                e = this.createImport(ast);
                break;
            }
            case 9: {
                e = this.createFeatureCallExpression(ast);
                break;
            }
            case 11: {
                e = this.createFeatureCallExpression(ast);
                break;
            }
            case 19: {
                e = this.createNameOrMethodCallExpression(ast);
                break;
            }
            case 62: {
                e = this.createNameOrMethodCallExpression(ast);
                break;
            }
            case 58: {
                e = this.createOperatorExpression(ast);
                break;
            }
            case 31: {
                e = this.createIfStatement(ast);
                break;
            }
            case 8: {
                e = this.createIntegerExpression(ast);
                break;
            }
            case 12: {
                e = this.createBooleanExpression(ast);
                break;
            }
            case 14: {
                e = this.createStringExpression(ast);
                break;
            }
            case 4: {
                e = this.createRealExpression(ast);
                break;
            }
            case 26: {
                e = this.createAssignmentStatement(ast);
                break;
            }
            case 33: {
                e = this.createWhileStatement(ast);
                break;
            }
            case 48: {
                e = this.createVariableDeclarationExpression(ast);
                break;
            }
            case 49: {
                e = this.createVariableDeclarationExpression(ast);
                break;
            }
            case 28: {
                e = this.createOperationDefinition(ast);
                break;
            }
            case 37: {
                e = this.createReturnStatement(ast);
                break;
            }
            case 40: {
                e = this.createContinueStatement(ast);
                break;
            }
            case 38: {
                e = this.createBreakStatement(ast);
                break;
            }
            case 39: {
                e = this.createBreakAllStatement(ast);
                break;
            }
            case 52: {
                e = this.createDeleteStatement(ast);
                break;
            }
            case 34: {
                e = this.createSwitchStatement(ast);
                break;
            }
            case 35: {
                e = this.createCaseStatement(ast);
                break;
            }
            case 36: {
                e = this.createCaseStatement(ast);
                break;
            }
            case 64: {
                e = this.createEnumerationLiteralExpression(ast);
            }
        }
        if (e == null) {
            throw new RuntimeException("Cannot create dom element for " + ast.getText() + "->" + ast.getType());
        }
        e.setContainer(container);
        return e;
    }

    protected EnumerationLiteralExpression createEnumerationLiteralExpression(AST ast) {
        EnumerationLiteralExpression e = new EnumerationLiteralExpression();
        return e;
    }

    protected CaseStatement createCaseStatement(AST ast) {
        CaseStatement statement = null;
        AST expressionAst = null;
        if (ast.getType() == 35) {
            statement = new CaseExpressionStatement();
            expressionAst = ast.getFirstChild();
            ((CaseExpressionStatement)statement).setExpression(this.createExpression(expressionAst, statement));
        } else {
            statement = new CaseDefaultStatement();
        }
        for (AST statementAst : ast.getChildren()) {
            if (statementAst == expressionAst) continue;
            statement.getBody().add(this.createStatement(statementAst, statement));
        }
        return statement;
    }

    protected SwitchStatement createSwitchStatement(AST ast) {
        SwitchStatement statement = new SwitchStatement();
        AST expressionAst = ast.getFirstChild();
        statement.setExpression(this.createExpression(expressionAst, statement));
        for (AST caseAst : ast.getChildren()) {
            if (caseAst == expressionAst) continue;
            statement.getCases().add((CaseStatement)this.createDomElement(caseAst, statement));
        }
        return statement;
    }

    protected ReturnStatement createReturnStatement(AST ast) {
        ReturnStatement statement = new ReturnStatement();
        if (ast.getFirstChild() != null) {
            statement.setReturned(this.createExpression(ast.getFirstChild(), statement));
        }
        return statement;
    }

    protected DeleteStatement createDeleteStatement(AST ast) {
        DeleteStatement statement = new DeleteStatement();
        if (ast.getFirstChild() != null) {
            statement.setDeleted(this.createExpression(ast.getFirstChild(), statement));
        }
        return statement;
    }

    protected BreakStatement createBreakStatement(AST ast) {
        return new BreakStatement();
    }

    protected BreakAllStatement createBreakAllStatement(AST ast) {
        return new BreakAllStatement();
    }

    protected ContinueStatement createContinueStatement(AST ast) {
        return new ContinueStatement();
    }

    protected OperationDefinition createOperationDefinition(AST ast) {
        OperationDefinition operation = new OperationDefinition();
        return operation;
    }

    protected WhileStatement createWhileStatement(AST ast) {
        WhileStatement statement = new WhileStatement();
        statement.setCondition(this.createExpression(ast.getFirstChild(), statement));
        for (AST statementAst : ast.getChild(1).getChildren()) {
            statement.getBody().add(this.createStatement(statementAst, statement));
        }
        return statement;
    }

    protected AssignmentStatement createAssignmentStatement(AST ast) {
        AssignmentStatement statement = new AssignmentStatement();
        statement.setLhs(this.createExpression(ast.getChild(0), statement));
        statement.setRhs(this.createExpression(ast.getChild(1), statement));
        return statement;
    }

    protected IntegerExpression createIntegerExpression(AST ast) {
        IntegerExpression exp = new IntegerExpression();
        exp.setValue(ast.getText());
        return exp;
    }

    protected BooleanExpression createBooleanExpression(AST ast) {
        BooleanExpression exp = new BooleanExpression();
        exp.setValue(ast.getText());
        return exp;
    }

    protected StringExpression createStringExpression(AST ast) {
        StringExpression exp = new StringExpression();
        exp.setValue(ast.getText());
        return exp;
    }

    protected RealExpression createRealExpression(AST ast) {
        RealExpression exp = new RealExpression();
        exp.setValue(ast.getText());
        return exp;
    }

    protected Expression createExpression(AST ast, DomElement parent) {
        return (Expression)this.createDomElement(ast, parent);
    }

    protected IfStatement createIfStatement(AST ast) {
        IfStatement statement = new IfStatement();
        AST conditionAst = ast.getFirstChild();
        AST ifBodyAst = conditionAst.getNextSibling();
        AST elseBodyAst = ifBodyAst.getNextSibling();
        statement.setCondition(this.createExpression(conditionAst, statement));
        for (AST statementAst : ifBodyAst.getChildren()) {
            statement.getIfBody().add(this.createStatement(statementAst, statement));
        }
        if (elseBodyAst != null) {
            for (AST statementAst : elseBodyAst.getChildren()) {
                statement.getElseBody().add(this.createStatement(statementAst, statement));
            }
        }
        return statement;
    }

    protected OperatorExpression createOperatorExpression(AST ast) {
        OperatorExpression exp = null;
        String operator = ast.getText();
        if (operator.equals("and")) {
            exp = new AndOperatorExpression();
        } else if (operator.equals("or")) {
            exp = new OrOperatorExpression();
        } else if (operator.equals("xor")) {
            exp = new XorOperatorExpression();
        } else if (operator.equals("implies")) {
            exp = new ImpliesOperatorExpression();
        } else if (operator.equals("not")) {
            exp = new NotOperatorExpression();
        } else if (operator.equals("+")) {
            exp = new PlusOperatorExpression();
        } else if (operator.equals("-")) {
            exp = ast.getChildren().size() == 1 ? new NegativeOperatorExpression() : new MinusOperatorExpression();
        } else if (operator.equals("*")) {
            exp = new StarOperatorExpression();
        } else if (operator.equals("/")) {
            exp = new DivOperatorExpression();
        } else if (operator.equals("=") || operator.equals("==")) {
            exp = new EqualsOperatorExpression();
        } else if (operator.equals("<>") || operator.equals("!=")) {
            exp = new NotEqualsOperatorExpression();
        } else if (operator.equals(">")) {
            exp = new MoreThanOperatorExpression();
        } else if (operator.equals("<")) {
            exp = new LessThanOperatorExpression();
        } else if (operator.equals("<=")) {
            exp = new LessThanOrEqualOperatorExpression();
        } else if (operator.equals(">=")) {
            exp = new MoreThanOrEqualOperatorExpression();
        }
        if (exp instanceof BinaryOperatorExpression) {
            ((BinaryOperatorExpression)exp).setLhs((Expression)this.createDomElement(ast.getChild(0), exp));
            try {
                ((BinaryOperatorExpression)exp).setRhs((Expression)this.createDomElement(ast.getChild(1), exp));
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(ast.getLine()) + ":" + ast.getColumn());
            }
        } else {
            ((UnaryOperatorExpression)exp).setExpression((Expression)this.createDomElement(ast.getFirstChild(), exp));
        }
        return exp;
    }

    protected DomElement createNameOrMethodCallExpression(AST ast) {
        AST parametersAst = ast.getFirstChild();
        if (parametersAst != null && parametersAst.getType() == 46) {
            MethodCallExpression exp = new MethodCallExpression();
            exp.setMethod(ast.getText());
            for (AST parameterAst : parametersAst.getChildren()) {
                exp.getArguments().add((Expression)this.createDomElement(parameterAst, exp));
            }
            return exp;
        }
        NameExpression exp = new NameExpression();
        exp.setName(ast.getText());
        return exp;
    }

    protected FeatureCallExpression createFeatureCallExpression(AST ast) {
        AST targetAst = ast.getFirstChild();
        AST featureAst = targetAst.getNextSibling();
        AST parametersAst = featureAst.getFirstChild();
        FeatureCallExpression exp = null;
        if (parametersAst == null) {
            FeatureCallExpression pexp = exp = new PropertyCallExpression();
            String property = featureAst.getText();
            if (property.startsWith("~")) {
                ((PropertyCallExpression)pexp).setExtended(true);
                ((PropertyCallExpression)pexp).setProperty(property.substring(1));
            } else {
                ((PropertyCallExpression)pexp).setProperty(property);
            }
        } else {
            exp = new MethodCallExpression();
            MethodCallExpression mexp = (MethodCallExpression)exp;
            mexp.setMethod(featureAst.getText());
            for (AST parameterAst : parametersAst.getChildren()) {
                mexp.getArguments().add((Expression)this.createDomElement(parameterAst, mexp));
            }
        }
        exp.setArrow(ast.getType() == 11);
        exp.setTarget((Expression)this.createDomElement(targetAst, exp));
        return exp;
    }

    protected Statement createStatement(AST ast, DomElement container) {
        Statement statement = null;
        DomElement e = this.createDomElement(ast, container);
        if (e instanceof Statement) {
            statement = (Statement)e;
            return statement;
        }
        if (e instanceof EqualsOperatorExpression) {
            EqualsOperatorExpression exp = (EqualsOperatorExpression)e;
            AssignmentStatement as = new AssignmentStatement();
            as.setContainer(container);
            as.setLhs(exp.getLhs());
            as.setRhs(exp.getRhs());
            as.getLhs().setContainer(as);
            as.getRhs().setContainer(as);
            statement = as;
        } else {
            statement = new ExpressionStatement();
            statement.setContainer(container);
            ((ExpressionStatement)statement).setExpression((Expression)e);
            ((Expression)e).setContainer(statement);
        }
        return statement;
    }

    protected Import createImport(AST ast) {
        Import imp = new Import();
        imp.setImported(ast.getFirstChild().getText());
        return imp;
    }

    protected Program createProgram(AST ast) {
        Program program = new Program();
        for (AST importAst : AstUtil.getChildren((AST)ast, (int[])new int[]{65})) {
            program.getImports().add((Import)this.createDomElement(importAst, program));
        }
        AST block = AstUtil.getChild((AST)ast, (int)61);
        for (AST statementAst : block.getChildren()) {
            program.getStatements().add(this.createStatement(statementAst, program));
        }
        return program;
    }

    protected VariableDeclarationExpression createVariableDeclarationExpression(AST ast) {
        VariableDeclarationExpression declaration = new VariableDeclarationExpression();
        AST nameAst = ast.getFirstChild();
        declaration.setName(nameAst.getText());
        AST typeAst = nameAst.getNextSibling();
        if (typeAst != null) {
            declaration.setType(typeAst.getText());
        }
        declaration.setCreate(ast.getType() == 49);
        return declaration;
    }

    protected ForStatement createForStatement(AST ast) {
        ForStatement statement = new ForStatement();
        AST iteratorAst = ast.getFirstChild();
        AST iteratedAst = iteratorAst.getNextSibling();
        statement.setIterator((VariableDeclarationExpression)this.createDomElement(iteratorAst, statement));
        statement.setIterated((Expression)this.createDomElement(iteratedAst, statement));
        AST bodyAst = AstUtil.getChild((AST)ast, (int)61);
        for (AST statementAst : bodyAst.getChildren()) {
            statement.getBody().add(this.createStatement(statementAst, statement));
        }
        return statement;
    }
}

