/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dom.print;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.epsilon.eol.dom.AndOperatorExpression;
import org.eclipse.epsilon.eol.dom.AssignmentStatement;
import org.eclipse.epsilon.eol.dom.BooleanExpression;
import org.eclipse.epsilon.eol.dom.BreakAllStatement;
import org.eclipse.epsilon.eol.dom.BreakStatement;
import org.eclipse.epsilon.eol.dom.CaseStatement;
import org.eclipse.epsilon.eol.dom.ContinueStatement;
import org.eclipse.epsilon.eol.dom.DivOperatorExpression;
import org.eclipse.epsilon.eol.dom.DomElement;
import org.eclipse.epsilon.eol.dom.EnumerationLiteralExpression;
import org.eclipse.epsilon.eol.dom.EqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.ExpressionStatement;
import org.eclipse.epsilon.eol.dom.ForStatement;
import org.eclipse.epsilon.eol.dom.IfStatement;
import org.eclipse.epsilon.eol.dom.ImpliesOperatorExpression;
import org.eclipse.epsilon.eol.dom.Import;
import org.eclipse.epsilon.eol.dom.IntegerExpression;
import org.eclipse.epsilon.eol.dom.LessThanOperatorExpression;
import org.eclipse.epsilon.eol.dom.LessThanOrEqualOperatorExpression;
import org.eclipse.epsilon.eol.dom.MethodCallExpression;
import org.eclipse.epsilon.eol.dom.MinusOperatorExpression;
import org.eclipse.epsilon.eol.dom.MoreThanOperatorExpression;
import org.eclipse.epsilon.eol.dom.MoreThanOrEqualOperatorExpression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.NotOperatorExpression;
import org.eclipse.epsilon.eol.dom.OrOperatorExpression;
import org.eclipse.epsilon.eol.dom.PlusOperatorExpression;
import org.eclipse.epsilon.eol.dom.Program;
import org.eclipse.epsilon.eol.dom.PropertyCallExpression;
import org.eclipse.epsilon.eol.dom.RealExpression;
import org.eclipse.epsilon.eol.dom.ReturnStatement;
import org.eclipse.epsilon.eol.dom.StarOperatorExpression;
import org.eclipse.epsilon.eol.dom.Statement;
import org.eclipse.epsilon.eol.dom.StringExpression;
import org.eclipse.epsilon.eol.dom.SwitchStatement;
import org.eclipse.epsilon.eol.dom.VariableDeclarationExpression;
import org.eclipse.epsilon.eol.dom.WhileStatement;
import org.eclipse.epsilon.eol.dom.XorOperatorExpression;
import org.eclipse.epsilon.eol.dom.print.AndOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.AssignmentStatementPrinter;
import org.eclipse.epsilon.eol.dom.print.BreakAllStatementPrinter;
import org.eclipse.epsilon.eol.dom.print.BreakStatementPrinter;
import org.eclipse.epsilon.eol.dom.print.CaseStatementPrinter;
import org.eclipse.epsilon.eol.dom.print.ContinueStatementPrinter;
import org.eclipse.epsilon.eol.dom.print.DivOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.DomElementPrinter;
import org.eclipse.epsilon.eol.dom.print.EnumerationLiteralExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.EqualsOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.ExpressionStatementPrinter;
import org.eclipse.epsilon.eol.dom.print.ForStatementPrinter;
import org.eclipse.epsilon.eol.dom.print.IfStatementPrinter;
import org.eclipse.epsilon.eol.dom.print.ImpliesOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.ImportPrinter;
import org.eclipse.epsilon.eol.dom.print.LessThanOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.LessThanOrEqualOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.LiteralValueExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.MethodCallExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.MinusOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.MoreThanOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.MoreThanOrEqualOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.NameExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.NotOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.OrOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.PlusOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.ProgramPrinter;
import org.eclipse.epsilon.eol.dom.print.PropertyCallExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.ReturnStatementPrinter;
import org.eclipse.epsilon.eol.dom.print.StarOperatorExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.StringExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.SwitchStatementPrinter;
import org.eclipse.epsilon.eol.dom.print.VariableDeclarationExpressionPrinter;
import org.eclipse.epsilon.eol.dom.print.WhileStatementPrinter;
import org.eclipse.epsilon.eol.dom.print.XorOperatorExpressionPrinter;

public class DomElementPrinterFactory {
    protected int indentation = 0;
    protected HashSet<String> keywords = null;

    public String print(DomElement e) {
        DomElementPrinter printer = null;
        if (e instanceof ForStatement) {
            printer = new ForStatementPrinter();
        } else if (e instanceof Program) {
            printer = new ProgramPrinter();
        } else if (e instanceof Import) {
            printer = new ImportPrinter();
        } else if (e instanceof StringExpression) {
            printer = new StringExpressionPrinter();
        } else if (e instanceof IntegerExpression) {
            printer = new LiteralValueExpressionPrinter();
        } else if (e instanceof BooleanExpression) {
            printer = new LiteralValueExpressionPrinter();
        } else if (e instanceof RealExpression) {
            printer = new LiteralValueExpressionPrinter();
        } else if (e instanceof AssignmentStatement) {
            printer = new AssignmentStatementPrinter();
        } else if (e instanceof VariableDeclarationExpression) {
            printer = new VariableDeclarationExpressionPrinter();
        } else if (e instanceof PropertyCallExpression) {
            printer = new PropertyCallExpressionPrinter();
        } else if (e instanceof MethodCallExpression) {
            printer = new MethodCallExpressionPrinter();
        } else if (e instanceof NameExpression) {
            printer = new NameExpressionPrinter();
        } else if (e instanceof PlusOperatorExpression) {
            printer = new PlusOperatorExpressionPrinter();
        } else if (e instanceof MinusOperatorExpression) {
            printer = new MinusOperatorExpressionPrinter();
        } else if (e instanceof StarOperatorExpression) {
            printer = new StarOperatorExpressionPrinter();
        } else if (e instanceof DivOperatorExpression) {
            printer = new DivOperatorExpressionPrinter();
        } else if (e instanceof AndOperatorExpression) {
            printer = new AndOperatorExpressionPrinter();
        } else if (e instanceof OrOperatorExpression) {
            printer = new OrOperatorExpressionPrinter();
        } else if (e instanceof XorOperatorExpression) {
            printer = new XorOperatorExpressionPrinter();
        } else if (e instanceof EqualsOperatorExpression) {
            printer = new EqualsOperatorExpressionPrinter();
        } else if (e instanceof MoreThanOperatorExpression) {
            printer = new MoreThanOperatorExpressionPrinter();
        } else if (e instanceof LessThanOperatorExpression) {
            printer = new LessThanOperatorExpressionPrinter();
        } else if (e instanceof MoreThanOrEqualOperatorExpression) {
            printer = new MoreThanOrEqualOperatorExpressionPrinter();
        } else if (e instanceof LessThanOrEqualOperatorExpression) {
            printer = new LessThanOrEqualOperatorExpressionPrinter();
        } else if (e instanceof ImpliesOperatorExpression) {
            printer = new ImpliesOperatorExpressionPrinter();
        } else if (e instanceof ExpressionStatement) {
            printer = new ExpressionStatementPrinter();
        } else if (e instanceof IfStatement) {
            printer = new IfStatementPrinter();
        } else if (e instanceof WhileStatement) {
            printer = new WhileStatementPrinter();
        } else if (e instanceof ContinueStatement) {
            printer = new ContinueStatementPrinter();
        } else if (e instanceof BreakStatement) {
            printer = new BreakStatementPrinter();
        } else if (e instanceof BreakAllStatement) {
            printer = new BreakAllStatementPrinter();
        } else if (e instanceof ReturnStatement) {
            printer = new ReturnStatementPrinter();
        } else if (e instanceof CaseStatement) {
            printer = new CaseStatementPrinter();
        } else if (e instanceof SwitchStatement) {
            printer = new SwitchStatementPrinter();
        } else if (e instanceof EnumerationLiteralExpression) {
            printer = new EnumerationLiteralExpressionPrinter();
        } else if (e instanceof NotOperatorExpression) {
            printer = new NotOperatorExpressionPrinter();
        }
        if (printer == null) {
            throw new RuntimeException("No printer for " + e);
        }
        String str = "";
        if (e instanceof Statement) {
            str = this.whitespace();
        }
        return String.valueOf(str) + printer.print(e, this);
    }

    public String whitespace() {
        String str = "";
        int i = 0;
        while (i < this.indentation) {
            str = String.valueOf(str) + "   ";
            ++i;
        }
        return str;
    }

    protected Collection<String> getKeywords() {
        if (this.keywords == null) {
            this.keywords = new HashSet();
            this.keywords.add("for");
        }
        return this.keywords;
    }

    protected boolean isValidIdentifier(String s) {
        if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < s.length()) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String escapeName(String name) {
        if (this.getKeywords().contains(name) || !this.isValidIdentifier(name)) {
            return "`" + name + "`";
        }
        return name;
    }

    public String print(Collection c, String delimiter) {
        Iterator it = c.iterator();
        String str = "";
        while (it.hasNext()) {
            str = String.valueOf(str) + this.print((DomElement)it.next());
            if (!it.hasNext()) continue;
            str = String.valueOf(str) + delimiter;
        }
        return str;
    }

    public String addQuotes(String s) {
        return "\"" + s + "\"";
    }

    public String print(Collection c) {
        return this.print(c, true);
    }

    public String print(Collection c, boolean newline) {
        if (newline) {
            return this.print(c, this.newline());
        }
        return this.print(c, "");
    }

    public String newline() {
        return System.getProperty("line.separator");
    }

    public String indent() {
        ++this.indentation;
        return "";
    }

    public String outdent() {
        --this.indentation;
        if (this.indentation < 0) {
            this.indentation = 0;
        }
        return "";
    }
}

