/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.NameExecutor;
import org.eclipse.epsilon.eol.execute.PointExecutor;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;

public abstract class AssignExecutor
extends AbstractExecutor {
    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        AST varAst = ast.getFirstChild();
        AST valueAst = varAst.getNextSibling();
        Object varAstResult = null;
        if (varAst.getType() == 9) {
            PointExecutor pointExecutor = (PointExecutor)context.getExecutorFactory().getExecutorFor(9);
            varAstResult = pointExecutor.execute(varAst, context, true);
        } else if (varAst.getType() == 19 || varAst.getType() == 62) {
            NameExecutor nameExecutor = (NameExecutor)context.getExecutorFactory().getExecutorFor(19);
            varAstResult = nameExecutor.execute(varAst, context, true);
        } else {
            varAstResult = context.getExecutorFactory().executeAST(varAst, context);
        }
        Object valueAstResult = context.getExecutorFactory().executeAST(valueAst, context);
        if (varAstResult instanceof IPropertySetter) {
            IPropertySetter setter = (IPropertySetter)varAstResult;
            try {
                Object value = this.getRhsEquivalent(setter.getObject(), valueAstResult, context);
                setter.invoke(value);
            }
            catch (EolRuntimeException ex) {
                if (ex.getAst() == null) {
                    ex.setAst(setter.getAst());
                }
                throw ex;
            }
        } else if (varAstResult instanceof Variable) {
            Variable variable = (Variable)varAstResult;
            try {
                Object value = this.getRhsEquivalent(variable.getValue(), valueAstResult, context);
                variable.setValue(value, context);
            }
            catch (EolRuntimeException ex) {
                ex.setAst(varAst);
                throw ex;
            }
        } else {
            throw new EolRuntimeException("Internall error. Expected either a SetterMethod or a Variable and got an " + varAstResult + "instead", ast);
        }
        return null;
    }

    public abstract Object getRhsEquivalent(Object var1, Object var2, IEolContext var3) throws EolRuntimeException;
}

