/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import java.util.Collection;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolBag;
import org.eclipse.epsilon.eol.types.EolOrderedSet;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.types.EolSet;

public class CollectionExecutor
extends AbstractExecutor {
    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        Collection collection = null;
        collection = ast.getText().equals("Sequence") || ast.getText().equals("List") ? new EolSequence() : (ast.getText().equals("Set") ? new EolSet() : (ast.getText().equals("OrderedSet") ? new EolOrderedSet() : new EolBag()));
        AST expressionListAst = ast.getFirstChild();
        if (expressionListAst != null) {
            if (expressionListAst.getType() == 54) {
                AST statementAst = expressionListAst.getFirstChild();
                while (statementAst != null) {
                    Object value = context.getExecutorFactory().executeAST(statementAst, context);
                    collection.add(value);
                    statementAst = statementAst.getNextSibling();
                }
            } else {
                AST rangeStartAst = expressionListAst.getFirstChild();
                AST rangeEndAst = rangeStartAst.getNextSibling();
                Object rangeStart = context.getExecutorFactory().executeAST(rangeStartAst, context);
                Object rangeEnd = context.getExecutorFactory().executeAST(rangeEndAst, context);
                if (rangeStart instanceof Integer && rangeEnd instanceof Integer) {
                    Integer s = (Integer)rangeStart;
                    Integer e = (Integer)rangeEnd;
                    if (s > e) {
                        int i = s;
                        while (i >= e) {
                            collection.add(i);
                            --i;
                        }
                    } else {
                        int i = s;
                        while (i <= e) {
                            collection.add(i);
                            ++i;
                        }
                    }
                } else {
                    if (!(rangeStart instanceof Integer)) {
                        throw new EolRuntimeException("The start of a range should be of type Integer", rangeStartAst);
                    }
                    if (!(rangeEnd instanceof Integer)) {
                        throw new EolRuntimeException("The end of a range should be of type Integer", rangeEndAst);
                    }
                }
            }
        }
        return collection;
    }
}

