/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.flowcontrol.EolTerminationException;
import org.eclipse.epsilon.eol.execute.AbortExecutor;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.ArrowExecutor;
import org.eclipse.epsilon.eol.execute.BooleanExecutor;
import org.eclipse.epsilon.eol.execute.BreakAllStatementExecutor;
import org.eclipse.epsilon.eol.execute.BreakStatementExecutor;
import org.eclipse.epsilon.eol.execute.CollectionExecutor;
import org.eclipse.epsilon.eol.execute.ContinueExecutor;
import org.eclipse.epsilon.eol.execute.DefaultAssignExecutor;
import org.eclipse.epsilon.eol.execute.DeleteStatementExecutor;
import org.eclipse.epsilon.eol.execute.EnumerationValueExecutor;
import org.eclipse.epsilon.eol.execute.EolModuleExecutor;
import org.eclipse.epsilon.eol.execute.ForStatementExecutor;
import org.eclipse.epsilon.eol.execute.FormalParameterListExecutor;
import org.eclipse.epsilon.eol.execute.IfStatementExecutor;
import org.eclipse.epsilon.eol.execute.IntegerExecutor;
import org.eclipse.epsilon.eol.execute.ItemSelectorExecutor;
import org.eclipse.epsilon.eol.execute.MapExecutor;
import org.eclipse.epsilon.eol.execute.NameExecutor;
import org.eclipse.epsilon.eol.execute.NewExecutor;
import org.eclipse.epsilon.eol.execute.OperatorExecutor;
import org.eclipse.epsilon.eol.execute.ParametersExecutor;
import org.eclipse.epsilon.eol.execute.PointExecutor;
import org.eclipse.epsilon.eol.execute.RealExecutor;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.ReturnStatementExecutor;
import org.eclipse.epsilon.eol.execute.StatementBlockExecutor;
import org.eclipse.epsilon.eol.execute.StringExecutor;
import org.eclipse.epsilon.eol.execute.SwitchStatementExecutor;
import org.eclipse.epsilon.eol.execute.ThrowStatementExecutor;
import org.eclipse.epsilon.eol.execute.TransactionExecutor;
import org.eclipse.epsilon.eol.execute.TypeExecutor;
import org.eclipse.epsilon.eol.execute.VarStatementExecutor;
import org.eclipse.epsilon.eol.execute.WhileStatementExecutor;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.control.DefaultExecutionController;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;
import org.eclipse.epsilon.eol.execute.control.IExecutionListener;

public class ExecutorFactory {
    protected ExecutionController executionController = null;
    protected HashMap<Integer, AbstractExecutor> executorCache = new HashMap();
    protected AST activeAst = null;
    protected ArrayList<IExecutionListener> executionListeners = new ArrayList();

    public ExecutorFactory() {
        this.executionController = new DefaultExecutionController();
        this.cacheExecutors();
    }

    public void addExecutionListener(IExecutionListener listener) {
        this.executionListeners.add(listener);
    }

    public boolean removeExecutionListener(IExecutionListener listener) {
        return this.executionListeners.remove(listener);
    }

    public ExecutionController getExecutionController() {
        return this.executionController;
    }

    public void setExecutionController(ExecutionController executionController) {
        this.executionController = executionController;
    }

    protected void cacheExecutors() {
        this.executorCache.put(58, new OperatorExecutor());
        this.executorCache.put(8, new IntegerExecutor());
        this.executorCache.put(14, new StringExecutor());
        this.executorCache.put(26, new DefaultAssignExecutor());
        this.executorCache.put(27, new DefaultAssignExecutor());
        this.executorCache.put(9, new PointExecutor());
        this.executorCache.put(19, new NameExecutor());
        this.executorCache.put(62, new NameExecutor());
        this.executorCache.put(61, new StatementBlockExecutor());
        this.executorCache.put(31, new IfStatementExecutor());
        this.executorCache.put(34, new SwitchStatementExecutor());
        this.executorCache.put(12, new BooleanExecutor());
        this.executorCache.put(11, new ArrowExecutor());
        this.executorCache.put(48, new VarStatementExecutor());
        this.executorCache.put(42, new CollectionExecutor());
        this.executorCache.put(73, new MapExecutor());
        this.executorCache.put(4, new RealExecutor());
        this.executorCache.put(30, new ForStatementExecutor());
        this.executorCache.put(25, new FormalParameterListExecutor());
        this.executorCache.put(60, new EolModuleExecutor());
        this.executorCache.put(46, new ParametersExecutor());
        this.executorCache.put(63, new TypeExecutor());
        this.executorCache.put(37, new ReturnStatementExecutor());
        this.executorCache.put(72, new ItemSelectorExecutor());
        this.executorCache.put(38, new BreakStatementExecutor());
        this.executorCache.put(39, new BreakAllStatementExecutor());
        this.executorCache.put(64, new EnumerationValueExecutor());
        this.executorCache.put(40, new ContinueExecutor());
        this.executorCache.put(33, new WhileStatementExecutor());
        this.executorCache.put(53, new ThrowStatementExecutor());
        this.executorCache.put(52, new DeleteStatementExecutor());
        this.executorCache.put(49, new NewExecutor());
        this.executorCache.put(41, new TransactionExecutor());
        this.executorCache.put(43, new AbortExecutor());
    }

    public AbstractExecutor getExecutorFor(int type) {
        return this.executorCache.get(type);
    }

    public Object executeBlockOrExpressionAst(AST ast, IEolContext context) throws EolRuntimeException {
        if (ast == null) {
            return null;
        }
        if (ast.getType() == 61) {
            return this.executeAST(ast, context);
        }
        return new Return(this.executeAST(ast, context));
    }

    public Object executeBlockOrExpressionAst(AST ast, IEolContext context, Object default_) {
        if (ast == null) {
            return default_;
        }
        try {
            if (ast.getType() == 61) {
                Object result = this.executeAST(ast, context);
                if (result instanceof Return) {
                    return ((Return)result).getValue();
                }
                return default_;
            }
            return this.executeAST(ast, context);
        }
        catch (EolRuntimeException ex) {
            context.getErrorStream().println(ex.toString());
            return default_;
        }
    }

    public Object executeAST(AST ast, IEolContext context, boolean asStatement) throws EolRuntimeException {
        if (ast == null) {
            return null;
        }
        if (asStatement && ast.getType() == 58 && "=".equals(ast.getText())) {
            ast.getToken().setType(26);
            ast.getToken().setText(":=");
        }
        return this.executeAST(ast, context);
    }

    /*
     * Unable to fully structure code
     */
    public Object executeAST(AST ast, IEolContext context) throws EolRuntimeException {
        if (ast == null) {
            return null;
        }
        this.activeAst = ast;
        if (this.executionController != null) {
            if (this.executionController.isTerminated()) {
                throw new EolTerminationException(ast);
            }
            try {
                this.executionController.control(ast, context);
            }
            catch (Exception ex) {
                throw new EolInternalException(ex);
            }
        }
        if ((executor = this.getExecutorFor(ast.getType())) == null) {
            throw new EolRuntimeException("No executor found for type #" + ast.getType(), ast);
        }
        for (IExecutionListener listener : this.executionListeners) {
            listener.aboutToExecute(ast, context);
        }
        try {
            var7_8 = executor.execute(ast, context);
            return var7_8;
        }
        catch (Exception ex) {
            if (ex instanceof EolRuntimeException) {
                eolEx = (EolRuntimeException)ex;
                if (eolEx.getAst() == null) {
                    eolEx.setAst(ast);
                }
                throw eolEx;
            }
            throw new EolInternalException(ex, ast);
        }
        finally {
            ** for (listener : this.executionListeners)
        }
lbl-1000:
        // 1 sources

        {
            listener.finishedExecuting(ast, context);
            continue;
        }
lbl31:
        // 1 sources

        throw var6_13;
    }

    public AST getActiveAst() {
        return this.activeAst;
    }
}

