/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.EolOperation;
import org.eclipse.epsilon.eol.IEolLibraryModule;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.execute.operations.simple.AbstractSimpleOperation;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public class PointExecutor
extends AbstractExecutor {
    public Object execute(AST ast, IEolContext context, boolean returnSetter) throws EolRuntimeException {
        AST objectAst = ast.getFirstChild();
        AST featureCallAst = objectAst.getNextSibling();
        Object source = context.getExecutorFactory().executeAST(objectAst, context);
        return this.execute(source, featureCallAst, context, returnSetter);
    }

    protected boolean isArrow() {
        return false;
    }

    public Object execute(Object source, AST featureCallAst, IEolContext context, boolean returnSetter) throws EolRuntimeException {
        AST parametersAst = featureCallAst.getFirstChild();
        if (parametersAst == null) {
            if (source == null) {
                throw new EolRuntimeException("Called feature " + featureCallAst.getText() + " on undefined object", featureCallAst);
            }
            if (returnSetter) {
                IPropertySetter setter = context.getIntrospectionManager().getPropertySetterFor(source, featureCallAst.getText(), context);
                setter.setAst(featureCallAst);
                return setter;
            }
            IPropertyGetter getter = context.getIntrospectionManager().getPropertyGetterFor(source, featureCallAst.getText(), context);
            getter.setAst(featureCallAst);
            return this.wrap(getter.invoke(source, featureCallAst.getText()));
        }
        return this.executeOperation(context, source, featureCallAst);
    }

    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        return this.execute(ast, context, false);
    }

    public Object executeOperation(IEolContext context, Object source, AST featureCallAst) throws EolRuntimeException {
        EolOperation helper;
        AST parametersAst = featureCallAst.getFirstChild();
        if (parametersAst.getType() == 25) {
            return context.getOperationFactory().executeOperation(source, featureCallAst, context);
        }
        AbstractOperation operation = context.getOperationFactory().getOperationFor(featureCallAst, context);
        if (operation != null && !operation.isOverridable()) {
            return operation.execute(source, featureCallAst, context);
        }
        ArrayList parameters = (ArrayList)context.getExecutorFactory().executeAST(parametersAst, context);
        if (context.getModule() instanceof IEolLibraryModule && !this.isArrow() && (helper = ((IEolLibraryModule)context.getModule()).getOperations().getOperation(source, featureCallAst, (List)parameters, context)) != null) {
            return ((IEolLibraryModule)context.getModule()).getOperations().execute(source, helper, featureCallAst, parameters, context);
        }
        ObjectMethod objectMethod = context.getOperationContributorRegistry().getContributedMethod(source, featureCallAst.getText(), parameters.toArray(), context);
        if (objectMethod != null) {
            return this.wrap(ReflectionUtil.executeMethod(objectMethod.getObject(), objectMethod.getMethod(), parameters.toArray(), featureCallAst));
        }
        if (operation != null) {
            if (operation instanceof AbstractSimpleOperation) {
                return ((AbstractSimpleOperation)operation).execute(source, parameters, context, featureCallAst);
            }
            return operation.execute(source, featureCallAst, context);
        }
        throw new EolIllegalOperationException(source, featureCallAst.getText(), featureCallAst, context.getPrettyPrinterManager());
    }

    public Object wrap(Object o) {
        if (o instanceof Iterator) {
            EolSequence list = new EolSequence();
            Iterator it = (Iterator)o;
            while (it.hasNext()) {
                list.add(it.next());
            }
            return list;
        }
        if (o instanceof Object[]) {
            EolSequence list = new EolSequence();
            Object[] objectArray = (Object[])o;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                list.add(item);
                ++n2;
            }
            return list;
        }
        if (o instanceof Iterable && !(o instanceof Collection)) {
            EolSequence list = new EolSequence();
            for (Object item : (Iterable)o) {
                list.add(item);
            }
            return list;
        }
        return o;
    }
}

